/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.ui;

import com.e1c.langtool.v8.dt.internal.ui.ExternalDependenciesModule;
import com.e1c.langtool.v8.dt.internal.ui.ServiceModule;
import com.e1c.langtool.v8.dt.settings.McoreFeatureSettings;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.framework.BundleContext;

public class V8UiPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.e1c.langtool.v8.dt.ui";
    private static final String IMAGES_PATH = "/icons";
    public static final String T_OBJ16 = "/obj16/";
    public static final String T_ETOOL16 = "/etool16/";
    public static final String WIZARD_BANNER_FOLDER = "/wizban/";
    public static final String IMG_OBJS_TRANSLATIONS = "com.e1c.langtool.v8.dt.ui/obj16/translations.png";
    public static final String IMG_OBJS_TRANSLATIONS_RUN = "com.e1c.langtool.v8.dt.ui/obj16/translations_run.png";
    public static final String IMG_OBJS_MANUAL_SYNC = "com.e1c.langtool.v8.dt.ui/obj16/manual_sync.png";
    public static final String IMG_OBJS_AUTO_SYNC = "com.e1c.langtool.v8.dt.ui/obj16/auto_sync.png";
    public static final String IMG_OBJS_SYNC_MODE = "com.e1c.langtool.v8.dt.ui/obj16/sync_mode.png";
    public static final String IMG_OBJS_EQUALITY_NEED_UPDATE = "com.e1c.langtool.v8.dt.ui/obj16/equality_need_update.png";
    public static final String IMG_OBJS_EQUALITY_NOT_CREATED = "com.e1c.langtool.v8.dt.ui/obj16/equality_not_created.png";
    public static final String IMG_OBJS_EQUALITY_SYNCHRONIZED = "com.e1c.langtool.v8.dt.ui/obj16/equality_synchronized.png";
    public static final String IMG_OBJS_EQUALITY_SYNCHRONIZING = "com.e1c.langtool.v8.dt.ui/obj16/equality_synchronizing.png";
    public static final String IMG_ETOOL16_OPEN_TRANSLATION = "com.e1c.langtool.v8.dt.ui/etool16/open_translation_edit.png";
    public static final String IMAGE_WIZARD_BANNER_LANGUAGE_CONVERTER_SETTINGS = "com.e1c.langtool.v8.dt.ui/wizban/language_converter_wizard.png";
    public static final String IMAGE_WIZARD_BANNER_LANGUAGE_CLEANER_SETTINGS = "com.e1c.langtool.v8.dt.ui/wizban/language_cleaner_wizard.png";
    private static V8UiPlugin plugin;
    private volatile Injector injector;
    private BundleContext bundleContext;

    public static V8UiPlugin getDefault() {
        return plugin;
    }

    public static void log(IStatus status) {
        plugin.getLog().log(status);
    }

    public static void logError(Throwable throwable) {
        V8UiPlugin.log(V8UiPlugin.createErrorStatus(throwable.getMessage(), throwable));
    }

    public static void logError(String message, Throwable throwable) {
        V8UiPlugin.log(V8UiPlugin.createErrorStatus(message, throwable));
    }

    public static void logInfo(String message) {
        V8UiPlugin.log(V8UiPlugin.createInfoStatus(message));
    }

    public static IStatus createErrorStatus(String message, Throwable throwable) {
        return new Status(4, PLUGIN_ID, 0, message, throwable);
    }

    public static IStatus createWarningStatus(String message) {
        return new Status(2, PLUGIN_ID, 0, message, null);
    }

    public static IStatus createWarningStatus(String message, Exception throwable) {
        return new Status(2, PLUGIN_ID, 0, message, (Throwable)throwable);
    }

    public static IStatus createInfoStatus(String message) {
        return new Status(1, PLUGIN_ID, 0, message, null);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.bundleContext = context;
        plugin = this;
        McoreFeatureSettings.INSTANCE.getClass();
    }

    public void stop(BundleContext context) throws Exception {
        this.injector = null;
        plugin = null;
        super.stop(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Injector getInjector() {
        Injector localInstance = this.injector;
        if (localInstance != null) return localInstance;
        Class<V8UiPlugin> clazz = V8UiPlugin.class;
        synchronized (V8UiPlugin.class) {
            localInstance = this.injector;
            if (localInstance != null) return localInstance;
            this.injector = localInstance = this.createInjector();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return localInstance;
        }
    }

    public IPreferenceStore getPreferenceStore(IProject project) {
        ProjectScope projectScope = new ProjectScope(project);
        ScopedPreferenceStore store = new ScopedPreferenceStore((IScopeContext)projectScope, PLUGIN_ID);
        store.setSearchContexts(new IScopeContext[]{projectScope, InstanceScope.INSTANCE});
        return store;
    }

    protected BundleContext getContext() {
        return this.bundleContext;
    }

    private Injector createInjector() {
        try {
            return Guice.createInjector((Module[])new Module[]{new ServiceModule(), new ExternalDependenciesModule((Plugin)this)});
        }
        catch (Exception e) {
            V8UiPlugin.log(V8UiPlugin.createErrorStatus("Failed to create injector for " + this.getBundle().getSymbolicName(), e));
            throw new RuntimeException("Failed to create injector for " + this.getBundle().getSymbolicName(), e);
        }
    }

    public static Image getImage(String id) {
        return plugin.getImageRegistry().get(id);
    }

    public static ImageDescriptor getImageDescriptor(String id) {
        return plugin.getImageRegistry().getDescriptor(id);
    }

    protected void initializeImageRegistry(ImageRegistry imageRegistry) {
        imageRegistry.put(IMG_OBJS_TRANSLATIONS, V8UiPlugin.createImageDescriptorFromKey(IMG_OBJS_TRANSLATIONS));
        imageRegistry.put(IMG_OBJS_TRANSLATIONS_RUN, V8UiPlugin.createImageDescriptorFromKey(IMG_OBJS_TRANSLATIONS_RUN));
        imageRegistry.put(IMG_OBJS_MANUAL_SYNC, V8UiPlugin.createImageDescriptorFromKey(IMG_OBJS_MANUAL_SYNC));
        imageRegistry.put(IMG_OBJS_AUTO_SYNC, V8UiPlugin.createImageDescriptorFromKey(IMG_OBJS_AUTO_SYNC));
        imageRegistry.put(IMG_OBJS_SYNC_MODE, V8UiPlugin.createImageDescriptorFromKey(IMG_OBJS_SYNC_MODE));
        imageRegistry.put(IMG_OBJS_EQUALITY_NEED_UPDATE, V8UiPlugin.createImageDescriptorFromKey(IMG_OBJS_EQUALITY_NEED_UPDATE));
        imageRegistry.put(IMG_OBJS_EQUALITY_NOT_CREATED, V8UiPlugin.createImageDescriptorFromKey(IMG_OBJS_EQUALITY_NOT_CREATED));
        imageRegistry.put(IMG_OBJS_EQUALITY_SYNCHRONIZED, V8UiPlugin.createImageDescriptorFromKey(IMG_OBJS_EQUALITY_SYNCHRONIZED));
        imageRegistry.put(IMG_OBJS_EQUALITY_SYNCHRONIZING, V8UiPlugin.createImageDescriptorFromKey(IMG_OBJS_EQUALITY_SYNCHRONIZING));
        imageRegistry.put(IMG_ETOOL16_OPEN_TRANSLATION, V8UiPlugin.createImageDescriptorFromKey(IMG_ETOOL16_OPEN_TRANSLATION));
        imageRegistry.put(IMAGE_WIZARD_BANNER_LANGUAGE_CONVERTER_SETTINGS, V8UiPlugin.createImageDescriptorFromKey(IMAGE_WIZARD_BANNER_LANGUAGE_CONVERTER_SETTINGS));
    }

    private static ImageDescriptor createImageDescriptorFromKey(String key) {
        String path = IMAGES_PATH + key.substring(PLUGIN_ID.length());
        return V8UiPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }
}

