/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.ui.collector;

import com.e1c.langtool.generatestring.FillUpType;
import com.e1c.langtool.generatestring.TranslationStringsGenerator;
import com.e1c.langtool.platform.ITranslatedProject;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.ui.generatestring.FilterSettingSection;
import com.e1c.langtool.v8.dt.internal.ui.collector.Messages;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.Section;

public class ComputedStringCollectingFilterSettingSection
implements FilterSettingSection {
    private static final String ID = "ComputedStringsProvider";
    private @NonNull TranslationStringsGenerator generator;
    private @NonNull WizardPage page;
    private ITranslatedProject selectedProject;

    public @NonNull String getTitle() {
        return Messages.ComputedStringCollectingFilterSettingSection_title;
    }

    public String getDescription() {
        return Messages.ComputedStringCollectingFilterSettingSection_description;
    }

    public void createContent(@NonNull TranslationStringsGenerator generator, @NonNull WizardPage page, @NonNull Composite parent, @NonNull Section section) {
        this.generator = generator;
        this.page = page;
        section.setExpanded(false);
        Font font = parent.getFont();
        Composite topLevel = new Composite(parent, 0);
        topLevel.setLayout((Layout)new GridLayout(2, false));
        topLevel.setLayoutData((Object)new GridData(4, 4, true, true));
        topLevel.setFont(font);
        ITranslatingProject translatingProject = generator.getTranslatingProject();
        List translatedProjects = translatingProject.getTranslatedProjects();
        this.addCombo(parent, Messages.ComputedStringCollectingFilterSettingSection_translated_project, translatedProjects);
    }

    private void addCombo(Composite parent, String label, List<ITranslatedProject> projects) {
        if (projects.isEmpty()) {
            return;
        }
        Group group = new Group(parent, 0);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        Label computeLabel = new Label((Composite)group, 0);
        computeLabel.setText(label);
        final ComboViewer editor = new ComboViewer((Composite)group, 8);
        editor.setLabelProvider((IBaseLabelProvider)new ProjectLabelProvider());
        editor.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        editor.setInput((Object)projects.toArray());
        Combo combo = editor.getCombo();
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ComputedStringCollectingFilterSettingSection.this.selectedProject = (ITranslatedProject)editor.getStructuredSelection().getFirstElement();
                ComputedStringCollectingFilterSettingSection.this.page.setPageComplete(ComputedStringCollectingFilterSettingSection.this.isSectionComplete());
            }
        });
        if (projects.size() == 1) {
            this.selectedProject = projects.get(0);
            editor.setSelection((ISelection)new StructuredSelection((Object)this.selectedProject));
        }
    }

    public void dispose() {
    }

    public boolean isSectionComplete() {
        if (this.isComputedStringsProvider()) {
            return this.selectedProject != null;
        }
        return true;
    }

    private boolean isComputedStringsProvider() {
        return this.generator.getFillUpType() == FillUpType.FROM_PROVIDER && ID.equals(this.generator.getTranslationProviderId());
    }

    public @Nullable String getErrorMessage() {
        return null;
    }

    public void updateFilterParameters(@NonNull Map<String, Object> parameters) {
        if (this.isComputedStringsProvider()) {
            parameters.put("fill-collected-string-by-translated-project", this.selectedProject);
            this.generator.disableCache();
        } else {
            parameters.remove("fill-collected-string-by-translated-project");
        }
    }

    private static class ProjectLabelProvider
    extends BaseLabelProvider
    implements ILabelProvider {
        private ProjectLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof ITranslatedProject) {
                return ((ITranslatedProject)element).getProjectName();
            }
            return null;
        }
    }
}

