/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.ui.commands;

import com._1c.g5.v8.dt.core.platform.IConfigurationProvider;
import com._1c.g5.v8.dt.core.platform.IResourceLookup;
import com._1c.g5.v8.dt.md.ui.navigator.adapters.LanguageNavigatorAdapter;
import com._1c.g5.v8.dt.metadata.mdclass.Configuration;
import com._1c.g5.v8.dt.metadata.mdclass.Language;
import com._1c.g5.v8.dt.navigator.adapters.IndexedTopObjectCollectionNavigatorAdapterBase;
import com.e1c.langtool.v8.dt.lang.model.V8TranslateLanguage;
import com.google.inject.Inject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

public abstract class AbstractLanguageHandler
extends AbstractHandler {
    @Inject
    private IResourceLookup resourceLookup;
    @Inject
    private IConfigurationProvider configurationProvider;

    protected Map<IProject, Set<Language>> getSelectedObjects(ISelection selection) {
        HashMap<IProject, Set<Language>> result = new HashMap<IProject, Set<Language>>();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object item : structuredSelection) {
                IProject project = null;
                if (item instanceof IProject) {
                    project = (IProject)item;
                } else if (item instanceof LanguageNavigatorAdapter.Folder && item instanceof IndexedTopObjectCollectionNavigatorAdapterBase) {
                    project = ((IndexedTopObjectCollectionNavigatorAdapterBase)item).getProject();
                } else if (item instanceof Language && !(item instanceof V8TranslateLanguage)) {
                    project = this.resourceLookup.getProject((EObject)((Language)item));
                }
                if (project == null) continue;
                Set languageSet = result.computeIfAbsent(project, projectReference -> new HashSet());
                if (item instanceof Language) {
                    Language language = (Language)item;
                    Configuration configuration = this.configurationProvider.getConfiguration((EObject)language);
                    if (configuration == null || language.equals(configuration.getDefaultLanguage())) continue;
                    languageSet.add(language);
                    continue;
                }
                Configuration configuration = this.configurationProvider.getConfiguration(project);
                if (configuration == null) continue;
                Language defaultLanguage = configuration.getDefaultLanguage();
                EList languages = configuration.getLanguages();
                if (languages == null) continue;
                for (Language language : languages) {
                    if (language instanceof V8TranslateLanguage || language.equals(defaultLanguage)) continue;
                    languageSet.add(language);
                }
            }
        }
        return result;
    }
}

