/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.ui.commands;

import com._1c.g5.v8.dt.core.filesystem.IProjectFileSystemSupport;
import com._1c.g5.v8.dt.core.filesystem.IProjectFileSystemSupportProvider;
import com._1c.g5.v8.dt.metadata.mdclass.MdObject;
import com._1c.g5.v8.dt.metadata.mdclass.StandardAttribute;
import com._1c.g5.v8.dt.metadata.mdclass.StandardTabularSectionDescription;
import com.e1c.langtool.TranslationSource;
import com.e1c.langtool.TranslationUtils;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.emf.naming.ITranslationFeatureKeyProvider;
import com.e1c.langtool.ignore.IgnoreTranslationCheckingService;
import com.e1c.langtool.ignore.TransIgnoreFile;
import com.e1c.langtool.ignore.TransIgnoreFileUtil;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.v8.dt.internal.ui.V8UiPlugin;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class IgnoreMdObjectTranslationHandler
extends AbstractHandler {
    @Inject
    private ITranslatingProjectManager projectManager;
    @Inject
    private IProjectFileSystemSupportProvider projectFileSystemSupportProvider;
    @Inject
    private ITranslationFeatureKeyProvider featureKeyProvider;
    @Inject
    private IgnoreTranslationCheckingService ignoreService;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        HashMap resources = Maps.newHashMap();
        for (EObject eObject : this.getResources(event)) {
            TranslationSource source = TranslationUtils.getTranslationSource((Object)eObject);
            if (source == null || !this.projectManager.getProject(source.getProject()).isTranslating() || this.ignoreService.ignoreTranslation(source.getProject(), source, (IProgressMonitor)new NullProgressMonitor())) continue;
            IProjectFileSystemSupport pfss = this.projectFileSystemSupportProvider.getProjectFileSystemSupport(source.getProject());
            IFile file = pfss.getFile(eObject);
            FeatureKey key = this.featureKeyProvider.getKey(eObject);
            resources.computeIfAbsent(file, f -> Sets.newHashSet()).add(key);
        }
        for (Map.Entry entry : resources.entrySet()) {
            this.addIgnoreFile((IFile)entry.getKey(), (Collection)entry.getValue());
        }
        return null;
    }

    private Collection<EObject> getResources(ExecutionEvent event) {
        ArrayList items = Lists.newArrayList();
        ISelection selection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)selection;
            for (Object item : sel) {
                if (item instanceof MdObject) {
                    items.add((MdObject)item);
                    continue;
                }
                if (item instanceof StandardAttribute) {
                    items.add((StandardAttribute)item);
                    continue;
                }
                if (!(item instanceof StandardTabularSectionDescription)) continue;
                items.add((StandardTabularSectionDescription)item);
            }
        }
        return items;
    }

    private void addIgnoreFile(final IFile source, final Collection<FeatureKey> values) {
        final IPath path = source.getProjectRelativePath().removeLastSegments(1);
        final IFile file = source.getProject().getFile(path.append(".transignore"));
        Job job = new Job("Saving ignore file"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                TransIgnoreFile ignoreFile = TransIgnoreFileUtil.createNew((IPath)path);
                if (file.exists()) {
                    try {
                        TransIgnoreFileUtil.load((TransIgnoreFile)ignoreFile, (IFile)file);
                    }
                    catch (IOException | CoreException e) {
                        String message = MessageFormat.format("Cannot read trans ignore file: {0}", file.getFullPath());
                        IStatus status = V8UiPlugin.createErrorStatus(message, e);
                        V8UiPlugin.log(status);
                        return status;
                    }
                }
                IPath pathToIgnore = source.getProjectRelativePath().removeFirstSegments(path.segmentCount());
                for (TransIgnoreFile key : values) {
                    if (ignoreFile.ignore(source.getProjectRelativePath(), (FeatureKey)key)) continue;
                    String featureKey = key.isEmpty() ? "*" : key.toString() + ".*";
                    ignoreFile.addLine((TransIgnoreFile.Line)new TransIgnoreFile.Rule(pathToIgnore.toString(), featureKey));
                }
                try {
                    TransIgnoreFile key;
                    key = ignoreFile;
                    synchronized (key) {
                        TransIgnoreFileUtil.save((TransIgnoreFile)ignoreFile, (IFile)file, (IProgressMonitor)monitor);
                    }
                }
                catch (IOException | CoreException e) {
                    return V8UiPlugin.createErrorStatus(MessageFormat.format("Error while saving file: {0}", file.getFullPath()), e);
                }
                return Status.OK_STATUS;
            }
        };
        if (file.isAccessible()) {
            job.setRule((ISchedulingRule)file);
        }
        job.schedule();
    }
}

