/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.ui.commands;

import com._1c.g5.v8.dt.core.filesystem.IProjectFileSystemSupport;
import com._1c.g5.v8.dt.core.filesystem.IProjectFileSystemSupportProvider;
import com._1c.g5.v8.dt.metadata.mdclass.Subsystem;
import com.e1c.langtool.TranslationUtils;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.collector.SegmentFeatureKey;
import com.e1c.langtool.ignore.TransIgnoreFile;
import com.e1c.langtool.ignore.TransIgnoreFileUtil;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.v8.dt.internal.ui.V8UiPlugin;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class IgnoreSubsystemContentTranslationHandler
extends AbstractHandler {
    private static final FeatureKey CONTENT_FEATURE_KEY = SegmentFeatureKey.create((String)"content");
    @Inject
    private ITranslatingProjectManager projectManager;
    @Inject
    private IProjectFileSystemSupportProvider projectFileSystemSupportProvider;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        List resources = this.getSubsystems(event).stream().map(TranslationUtils::getTranslationSource).filter(s -> s != null && this.projectManager.getProject(s.getProject()).isTranslating()).map(s -> {
            IProjectFileSystemSupport pfss = this.projectFileSystemSupportProvider.getProjectFileSystemSupport(s.getProject());
            return pfss.getFile((EObject)s.getSourceObject());
        }).collect(Collectors.toList());
        for (IFile file : resources) {
            this.addIgnoreFile(file);
        }
        return null;
    }

    private Collection<Subsystem> getSubsystems(ExecutionEvent event) {
        ArrayList items = Lists.newArrayList();
        ISelection selection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)selection;
            for (Object item : sel) {
                if (!(item instanceof Subsystem)) continue;
                items.add((Subsystem)item);
            }
        }
        return items;
    }

    private void addIgnoreFile(IFile source) {
        IPath path = source.getProjectRelativePath().removeLastSegments(1);
        final IFile file = source.getProject().getFile(path.append(".transignore"));
        final TransIgnoreFile ignoreFile = TransIgnoreFileUtil.createNew((IPath)path);
        if (file.exists()) {
            try {
                TransIgnoreFileUtil.load((TransIgnoreFile)ignoreFile, (IFile)file);
            }
            catch (IOException | CoreException e) {
                V8UiPlugin.logError(e);
                return;
            }
        }
        if (!ignoreFile.getRules().stream().anyMatch(r -> "*".equals(r.getResource()) && CONTENT_FEATURE_KEY.toString().equals(r.getFeatureKey()))) {
            ignoreFile.addLine((TransIgnoreFile.Line)new TransIgnoreFile.Rule("*", CONTENT_FEATURE_KEY.toString()));
        }
        Job job = new Job("Saving ignore file"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                try {
                    TransIgnoreFile transIgnoreFile = ignoreFile;
                    synchronized (transIgnoreFile) {
                        TransIgnoreFileUtil.save((TransIgnoreFile)ignoreFile, (IFile)file, (IProgressMonitor)monitor);
                    }
                }
                catch (IOException | CoreException e) {
                    return V8UiPlugin.createErrorStatus(MessageFormat.format("Error while saving file: {0}", file.getFullPath()), e);
                }
                return Status.OK_STATUS;
            }
        };
        if (file.isAccessible()) {
            job.setRule((ISchedulingRule)file);
        }
        job.schedule();
    }
}

