/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.ui.languagecleaner.wizard;

import com._1c.g5.v8.dt.metadata.mdclass.Language;
import com.e1c.langtool.v8.dt.internal.ui.V8UiPlugin;
import com.e1c.langtool.v8.dt.internal.ui.languagecleaner.wizard.LanguageCleanerWizardPage;
import com.e1c.langtool.v8.dt.internal.ui.languagecleaner.wizard.Messages;
import com.e1c.langtool.v8.dt.languagecleaner.LanguageCleaner;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class LanguageCleanerWizard
extends Wizard {
    @Inject
    private Provider<LanguageCleanerWizardPage> mainPageProvider;
    @Inject
    private LanguageCleaner languageCleaner;
    private IProject project;
    private Set<Language> languages;
    private LanguageCleanerWizardPage mainPage;

    public LanguageCleanerWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        super.addPages();
        this.mainPage = (LanguageCleanerWizardPage)((Object)this.mainPageProvider.get());
        this.mainPage.init(this.project, this.languages);
        this.addPage((IWizardPage)this.mainPage);
    }

    public boolean canFinish() {
        return this.mainPage.isPageComplete();
    }

    public boolean performFinish() {
        try {
            this.getContainer().run(true, true, monitor -> this.languageCleaner.cleanUpLanguages(this.project, this.languages, this.mainPage.isKeepLanguages(), monitor));
        }
        catch (InvocationTargetException e) {
            V8UiPlugin.logError(e);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return true;
    }

    public void init(IProject project, Set<Language> languages) {
        this.project = project;
        this.languages = languages;
        Assert.isNotNull((Object)project, (String)"Project shall not be NULL");
        Assert.isNotNull(languages, (String)"Languages set shall not be null");
        this.setWindowTitle(Messages.LanguageCleanerWizard_Window_title);
    }
}

