/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.ui.languagecleaner.wizard;

import com._1c.g5.v8.dt.core.platform.IConfigurationProvider;
import com._1c.g5.v8.dt.metadata.mdclass.Configuration;
import com._1c.g5.v8.dt.metadata.mdclass.Language;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.v8.dt.internal.ui.V8UiPlugin;
import com.e1c.langtool.v8.dt.internal.ui.languagecleaner.wizard.Messages;
import com.e1c.langtool.v8.dt.lang.model.util.LanguageUtil;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class LanguageCleanerWizardPage
extends WizardPage {
    @Inject
    private IConfigurationProvider configurationProvider;
    @Inject
    private ITranslatingProjectManager translatingProjectManager;
    private IProject project;
    private Set<Language> selectedLanguages;
    private CheckboxTableViewer languagesViewer;
    private final ILabelProvider languageLabelProvider = new LanguageLabelProvider();
    private boolean keepLanguages = false;

    public LanguageCleanerWizardPage() {
        super("LanguageCleanerSettingsPage", Messages.LanguageCleanerWizard_Page_title, V8UiPlugin.getImageDescriptor("com.e1c.langtool.v8.dt.ui/wizban/language_cleaner_wizard.png"));
        this.setDescription(Messages.LanguageCleanerWizard_Page_description);
    }

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite topLevel = new Composite(parent, 0);
        topLevel.setLayout((Layout)new GridLayout());
        topLevel.setLayoutData((Object)new GridData(272));
        topLevel.setFont(font);
        Group group = new Group(topLevel, 0);
        group.setText(Messages.LanguageCleanerWizard_Languages_group_title);
        group.setLayout((Layout)new GridLayout(1, false));
        group.setLayoutData((Object)new GridData(768));
        final Button toCleanRadio = new Button((Composite)group, 16);
        toCleanRadio.setText(Messages.LanguageCleanerWizard_Languages_to_clean_title);
        toCleanRadio.setSelection(true);
        final Button toKeepRadio = new Button((Composite)group, 16);
        toKeepRadio.setText(Messages.LanguageCleanerWizard_Languages_to_keep_title);
        toKeepRadio.setSelection(false);
        this.languagesViewer = CheckboxTableViewer.newCheckList((Composite)topLevel, (int)68354);
        this.languagesViewer.setLabelProvider((IBaseLabelProvider)this.languageLabelProvider);
        this.languagesViewer.addCheckStateListener(event -> {
            Object element = event.getElement();
            boolean checked = event.getChecked();
            Object object = element;
            if (object instanceof Language) {
                Language language = (Language)object;
                Language cfr_ignored_0 = (Language)object;
                if (checked) {
                    this.selectedLanguages.add((Language)langauge);
                } else {
                    this.selectedLanguages.remove(langauge);
                }
                this.setPageComplete(this.isPageComplete());
            }
        });
        SelectionAdapter buttonSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.getSource().equals(toCleanRadio)) {
                    LanguageCleanerWizardPage.this.keepLanguages = false;
                } else if (e.getSource().equals(toKeepRadio)) {
                    LanguageCleanerWizardPage.this.keepLanguages = true;
                }
                LanguageCleanerWizardPage.this.setPageComplete(LanguageCleanerWizardPage.this.isPageComplete());
            }
        };
        toCleanRadio.addSelectionListener((SelectionListener)buttonSelectionListener);
        toKeepRadio.addSelectionListener((SelectionListener)buttonSelectionListener);
        this.languagesViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        Table storageTable = this.languagesViewer.getTable();
        storageTable.setLayoutData((Object)new GridData(1808));
        storageTable.setFont(font);
        this.fillLanguagesList();
        this.setControl((Control)topLevel);
        Dialog.applyDialogFont((Control)topLevel);
    }

    public boolean isPageComplete() {
        return this.keepLanguages || !this.selectedLanguages.isEmpty();
    }

    public void init(IProject project, Set<Language> selectedLanguages) {
        this.project = project;
        this.selectedLanguages = selectedLanguages;
    }

    public boolean isKeepLanguages() {
        return this.keepLanguages;
    }

    private void fillLanguagesList() {
        Configuration configuration = this.configurationProvider.getConfiguration(this.project);
        if (configuration != null) {
            Language defaultLanguage = configuration.getDefaultLanguage();
            ITranslatingProject translating = this.translatingProjectManager.getProject(this.project);
            List<Language> languagesList = new ArrayList(configuration.getLanguages()).stream().filter(language2 -> !language2.equals(defaultLanguage) && LanguageUtil.getTranslateLanguage((ITranslatingProject)translating, (Language)language2).isEmpty()).toList();
            this.languagesViewer.setInput(languagesList);
            for (Language language : languagesList) {
                this.languagesViewer.setChecked((Object)language, this.selectedLanguages.contains(language));
            }
        }
    }

    private static class LanguageLabelProvider
    extends BaseLabelProvider
    implements ILabelProvider {
        private LanguageLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        /*
         * WARNING - void declaration
         */
        public String getText(Object element) {
            Object object = element;
            if (object instanceof Language) {
                void language;
                Language language2 = (Language)object;
                Language cfr_ignored_0 = (Language)object;
                return language.getName();
            }
            return null;
        }
    }
}

