/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.ui.refactoring;

import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.v8.dt.internal.ui.V8UiPlugin;
import java.util.Map;
import java.util.stream.Collectors;

public class DebugUtil {
    private DebugUtil() {
    }

    public static void debugDumpKeyMapping(Map<FeatureValue, FeatureValue> mapping) {
        int firstMaxLen = mapping.keySet().stream().map(k -> k.getContextKey().getFeatureKey()).map(Object::toString).mapToInt(String::length).max().orElse(0);
        int secondMaxLen = mapping.values().stream().map(k -> k.getContextKey().getFeatureKey()).map(Object::toString).mapToInt(String::length).max().orElse(0);
        Object firstFormat = firstMaxLen == 0 ? "%s" : "%-" + firstMaxLen + "s";
        Object secondFormat = secondMaxLen == 0 ? "%s" : "%-" + secondMaxLen + "s";
        String format = "%03d. MAPPING " + (String)firstFormat + "\t=>\t" + (String)secondFormat + "%n";
        StringBuilder message = new StringBuilder("FEATURE VALUE MAPPING:").append(System.lineSeparator()).append(System.lineSeparator());
        int index = 1;
        for (Map.Entry<FeatureValue, FeatureValue> entry : mapping.entrySet()) {
            message.append(String.format(format, index++, entry.getKey().getContextKey().getFeatureKey(), entry.getValue().getContextKey().getFeatureKey()));
        }
        message.append("---------------").append(System.lineSeparator()).append("TOTAL: ").append(mapping.size()).append(System.lineSeparator());
        V8UiPlugin.logInfo(message.toString());
    }

    public static void debugDumpResourceIdAndKeyMapping(Map<FeatureValue, FeatureValue> mapping) {
        Map<String, String> stringifiedMapping = mapping.entrySet().stream().collect(Collectors.toMap(entry -> {
            FeatureValue featureValue = (FeatureValue)entry.getKey();
            return String.valueOf(featureValue.getContextKey().getResourceId()) + " ! " + String.valueOf(featureValue.getContextKey().getFeatureKey());
        }, entry -> {
            FeatureValue featureValue = (FeatureValue)entry.getValue();
            return String.valueOf(featureValue.getContextKey().getResourceId()) + " ! " + String.valueOf(featureValue.getContextKey().getFeatureKey());
        }));
        int firstMaxLen = stringifiedMapping.keySet().stream().mapToInt(String::length).max().orElse(0);
        int secondMaxLen = stringifiedMapping.values().stream().mapToInt(String::length).max().orElse(0);
        Object firstFormat = firstMaxLen == 0 ? "%s" : "%-" + firstMaxLen + "s";
        Object secondFormat = secondMaxLen == 0 ? "%s" : "%-" + secondMaxLen + "s";
        String format = "%03d. MAPPING " + (String)firstFormat + "\t=>\t" + (String)secondFormat + "%n";
        StringBuilder message = new StringBuilder("FEATURE VALUE MAPPING:").append(System.lineSeparator()).append(System.lineSeparator());
        int index = 1;
        for (Map.Entry<String, String> entry2 : stringifiedMapping.entrySet()) {
            message.append(String.format(format, index++, entry2.getKey(), entry2.getValue()));
        }
        message.append("---------------").append(System.lineSeparator()).append("TOTAL: ").append(stringifiedMapping.size()).append(System.lineSeparator());
        V8UiPlugin.logInfo(message.toString());
    }
}

