/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.ui.refactoring;

import com.e1c.langtool.collector.CollectingParameters;
import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.collector.ICollectingParameters;
import com.e1c.langtool.collector.IFeatureValueCollectingService;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.v8.dt.internal.ui.refactoring.ObjectChangeSharedState;
import com.e1c.langtool.v8.dt.internal.ui.refactoring.Util;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;

public abstract class ObjectChangeBase
extends Change {
    protected final ObjectChangeSharedState sharedState;

    public ObjectChangeBase(ObjectChangeSharedState sharedState) {
        this.sharedState = sharedState;
    }

    protected Set<FeatureValue> collectFeatureValues(IProgressMonitor monitor) {
        Object sourceObject = this.getSourceObject();
        if (sourceObject != null) {
            Set<FeatureValue> result = Util.collectFeatureValues(sourceObject, this.getCollectingService(), this.getCollectingParameters(), monitor);
            return result;
        }
        return Collections.emptySet();
    }

    protected abstract Object getSourceObject();

    public IFeatureValueCollectingService getCollectingService() {
        return this.sharedState.getCollectingService();
    }

    private ICollectingParameters getCollectingParameters() {
        return CollectingParameters.builder().collectChildObjects().collectModel().collectInterface().collectSubResources().collectComputedStrings().setLanguages(new HashSet<TranslateLanguage>(this.sharedState.getLanguages())).continueAfterFirstError().enableCache().build();
    }
}

