/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.ui.refactoring;

import com._1c.g5.v8.bm.core.IBmObject;
import com._1c.g5.v8.dt.core.filesystem.IProjectFileSystemSupport;
import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.v8.dt.internal.ui.V8UiPlugin;
import com.e1c.langtool.v8.dt.internal.ui.refactoring.DebugUtil;
import com.e1c.langtool.v8.dt.internal.ui.refactoring.FeatureValuePairMatcher;
import com.e1c.langtool.v8.dt.internal.ui.refactoring.Messages;
import com.e1c.langtool.v8.dt.internal.ui.refactoring.ObjectChangeBase;
import com.e1c.langtool.v8.dt.internal.ui.refactoring.ObjectChangeSharedState;
import com.e1c.langtool.v8.dt.internal.ui.refactoring.ObjectPreChange;
import com.e1c.langtool.v8.dt.internal.ui.refactoring.Util;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class ObjectPostChange
extends ObjectChangeBase {
    public ObjectPostChange(ObjectChangeSharedState sharedState) {
        super(sharedState);
    }

    public String getName() {
        return Messages.ObjectPostChange_Name;
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return null;
    }

    public Change perform(IProgressMonitor monitor) throws CoreException {
        if (this.isEnabled()) {
            Set<FeatureValue> originalFeatures = this.sharedState.getFeatureValues();
            if (originalFeatures != null && !originalFeatures.isEmpty()) {
                Set<FeatureValue> newFeatures = this.collectFeatureValues(monitor);
                Map<FeatureValue, FeatureValue> matches = this.sharedState.isTopObject() ? FeatureValuePairMatcher.matchRenamedTopObjectFeatureValues(originalFeatures, newFeatures) : FeatureValuePairMatcher.matchRenamedChildObjectFeatureValues(originalFeatures, newFeatures);
                Util.performBatchMoveTranslation(matches, this.sharedState.getStorages(), this.sharedState.getLanguages());
                if (V8UiPlugin.getDefault().isDebugging()) {
                    DebugUtil.debugDumpResourceIdAndKeyMapping(matches);
                }
            }
            return new ObjectPreChange(this.sharedState);
        }
        if (V8UiPlugin.getDefault().isDebugging()) {
            V8UiPlugin.logInfo("Invocation of the ObjectPostChange is disabled by user.");
        }
        return null;
    }

    public Object getModifiedElement() {
        return null;
    }

    @Override
    protected Object getSourceObject() {
        IBmObject owner = this.sharedState.getOwner();
        if (owner != null) {
            IProjectFileSystemSupport fileSystemSupport = this.sharedState.getFileSystemSupport();
            IFile objectFile = fileSystemSupport.getFile((EObject)owner, this.sharedState.getReference());
            return this.sharedState.getEmfObjectProvider().getObjectByFile(objectFile);
        }
        return this.sharedState.getObject();
    }
}

