/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.ui.refactoring;

import com._1c.g5.v8.dt.refactoring.core.IRefactoringOperation;
import com._1c.g5.v8.dt.refactoring.core.IRefactoringPostProcessor;
import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.v8.dt.internal.ui.V8UiPlugin;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class RemoveEObjectTranslationsOperation
implements IRefactoringOperation,
IRefactoringPostProcessor {
    private final Set<FeatureValue> objectFeatures;
    private final List<TranslateLanguage> interfaceLanguages;
    private final Collection<ITranslationStorageProvider.Storage> storages;

    public RemoveEObjectTranslationsOperation(Set<FeatureValue> objectFeatures, List<TranslateLanguage> interfaceLanguages, Collection<ITranslationStorageProvider.Storage> storages) {
        this.objectFeatures = objectFeatures;
        this.interfaceLanguages = interfaceLanguages;
        this.storages = storages;
    }

    public void perform() {
    }

    public void postProcess() {
        if (!this.storages.isEmpty() && this.interfaceLanguages != null && !this.objectFeatures.isEmpty()) {
            for (ITranslationStorageProvider.Storage storage : this.storages) {
                for (FeatureValue feature : this.objectFeatures) {
                    if (V8UiPlugin.getDefault().isDebugging()) {
                        V8UiPlugin.logInfo("Clearing feature " + String.valueOf(feature));
                    }
                    for (TranslateLanguage language : this.interfaceLanguages) {
                        storage.removeTranslation(feature, language, true);
                    }
                }
            }
        }
    }
}

