/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.ui.refactoring;

import com.e1c.langtool.TranslationSource;
import com.e1c.langtool.TranslationUtils;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.collector.ICollectingParameters;
import com.e1c.langtool.collector.IFeatureValueCollectingService;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.storage.IStorageSettingsManager;
import com.e1c.langtool.storage.ITranslationStorageManager;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.storage.StorageID;
import com.e1c.langtool.v8.dt.internal.ui.V8UiPlugin;
import com.e1c.langtool.v8.dt.internal.ui.refactoring.Messages;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.xtext.ui.editor.XtextEditor;

public final class Util {
    private static final String COM_G5_V8_DT_INTERNAL_COMPARE_COMPARISON_MANAGER = "com._1c.g5.v8.dt.internal.compare.ComparisonManager";

    private Util() {
    }

    public static XtextEditor getXtextEditor(IEditorPart part) {
        if (part == null) {
            return null;
        }
        if (part instanceof XtextEditor) {
            return (XtextEditor)part;
        }
        return (XtextEditor)part.getAdapter(XtextEditor.class);
    }

    public static FeatureKey replaceFeatureKey(FeatureKey featureKey, FeatureKey oldPrefix, FeatureKey newPrefix) {
        if (featureKey.startsWith(oldPrefix)) {
            return newPrefix.append(featureKey.skipFirst(oldPrefix.getSegmentCount()));
        }
        return featureKey;
    }

    public static List<ITranslationStorageProvider.Storage> getProjectStorages(IProject project, IStorageSettingsManager storageSettingsManager, ITranslationStorageManager storageManager) {
        LinkedList<ITranslationStorageProvider.Storage> result = new LinkedList<ITranslationStorageProvider.Storage>();
        List availableStorageIds = storageSettingsManager.getReadStorageIds(project);
        for (StorageID storageId : availableStorageIds) {
            ITranslationStorageProvider.Storage storage = storageManager.getStorage(project, storageId);
            if (storage.getType() != ITranslationStorageProvider.Storage.Type.CONTEXT) continue;
            result.add(storage);
        }
        return result;
    }

    public static Set<FeatureValue> collectFeatureValues(Object object, IFeatureValueCollectingService collectingService, ICollectingParameters collectingParameters, IProgressMonitor monitor) {
        Set result = Sets.newConcurrentHashSet();
        TranslationSource source = TranslationUtils.getTranslationSource((Object)object);
        collectingService.forEachCollected(source, collectingParameters, monitor, (collectedObject, feature) -> result.add(feature));
        return result;
    }

    public static void performBatchMoveTranslation(Map<FeatureValue, FeatureValue> matches, Collection<ITranslationStorageProvider.Storage> storages, Collection<TranslateLanguage> languages) {
        if (!matches.isEmpty()) {
            for (ITranslationStorageProvider.Storage storage : storages) {
                for (Map.Entry<FeatureValue, FeatureValue> match : matches.entrySet()) {
                    for (TranslateLanguage language : languages) {
                        try {
                            String translation = storage.getTranslation(match.getKey(), language);
                            if (!StringUtils.isNotEmpty((String)translation)) continue;
                            storage.moveTranslation(match.getKey(), match.getValue(), language, true);
                        }
                        catch (Exception e) {
                            if (!V8UiPlugin.getDefault().isDebugging()) continue;
                            V8UiPlugin.logError(String.format(Messages.XtextPostChange_Translation_move_error, match.getKey(), match.getValue(), language.getName()), e);
                        }
                    }
                }
            }
        }
    }

    public static boolean isCalledFromComparisonManager() {
        return StackWalker.getInstance().walk(stream -> stream.anyMatch(frame -> COM_G5_V8_DT_INTERNAL_COMPARE_COMPARISON_MANAGER.equals(frame.getClassName())));
    }

    public static boolean isTranslationRefactoringEnabled(IProject project) {
        return V8UiPlugin.getDefault().getPreferenceStore(project).getBoolean("com.e1c.langtool.v8.dt.ui.enableTranslationRefactoring");
    }
}

