/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.ui.languageconverter.wizard;

import com._1c.g5.v8.dt.core.platform.IConfigurationProvider;
import com._1c.g5.v8.dt.metadata.mdclass.Configuration;
import com._1c.g5.v8.dt.metadata.mdclass.Language;
import com.e1c.langtool.storage.IStorageSettingsManager;
import com.e1c.langtool.storage.ITranslationStorageManager;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.storage.StorageID;
import com.e1c.langtool.v8.dt.internal.ui.V8UiPlugin;
import com.e1c.langtool.v8.dt.lang.model.V8TranslateLanguage;
import com.e1c.langtool.v8.dt.ui.languageconverter.wizard.Messages;
import com.google.inject.Inject;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.util.BidiUtils;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.ide.dialogs.ProjectContentsLocationArea;

public class LanguageConversionSettingsWizardPage
extends WizardPage {
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;
    @Inject
    private IConfigurationProvider configurationProvider;
    @Inject
    private ITranslationStorageManager storageManager;
    @Inject
    private IStorageSettingsManager storageSettingsManager;
    private IProject project;
    private IProject targetProject;
    private Set<Language> selectedLanguages;
    private AtomicBoolean exportTranslationsToStorage;
    private AtomicReference<StorageID> targetStorageId;
    private CheckboxTableViewer languagesViewer;
    private ComboViewer storageCombobox;
    private Button exportTranslationsCheckbox;
    private ILabelProvider languageLabelProvider = new LanguageLabelProvider();
    private ILabelProvider storageLabelProvider = new StorageLabelProvider();
    private ILabelProvider projectLabelProvider = new ProjectLabelProvider();
    private ComboViewer projectCombobox;
    private Text projectNameField;
    private Listener nameModifyListener = e -> {
        this.setLocationForSelection();
        boolean valid = this.validatePage();
        this.setPageComplete(valid);
    };
    private String initialProjectFieldValue;
    private ProjectContentsLocationArea locationArea;
    private boolean createNewProject;

    public LanguageConversionSettingsWizardPage() {
        super("LanguageConversionSettingsPage", Messages.LanguageConversionWizard_SettingsTitle, V8UiPlugin.getImageDescriptor("com.e1c.langtool.v8.dt.ui/wizban/language_converter_wizard.png"));
        this.setDescription(Messages.LanguageConversionWizard_SettingsDescription);
    }

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite topLevel = new Composite(parent, 0);
        topLevel.setLayout((Layout)new GridLayout());
        topLevel.setLayoutData((Object)new GridData(272));
        topLevel.setFont(font);
        this.languagesViewer = CheckboxTableViewer.newCheckList((Composite)topLevel, (int)68354);
        this.languagesViewer.setLabelProvider((IBaseLabelProvider)this.languageLabelProvider);
        this.languagesViewer.addCheckStateListener(event -> {
            Object element = event.getElement();
            boolean checked = event.getChecked();
            if (element instanceof Language) {
                Language langauge = (Language)element;
                if (checked) {
                    this.selectedLanguages.add(langauge);
                } else {
                    this.selectedLanguages.remove(langauge);
                }
            }
            this.setPageComplete(this.validatePage());
        });
        this.languagesViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        Table storageTable = this.languagesViewer.getTable();
        storageTable.setLayoutData((Object)new GridData(1808));
        storageTable.setFont(font);
        this.fillLanguagesList();
        Composite storageGroup = new Composite(topLevel, 0);
        storageGroup.setLayout((Layout)new GridLayout(2, false));
        storageGroup.setLayoutData((Object)new GridData(768));
        storageGroup.setFont(font);
        this.exportTranslationsCheckbox = new Button(storageGroup, 32);
        this.exportTranslationsCheckbox.setText(Messages.LanguageConversionWizard_Store_translation_to);
        this.exportTranslationsCheckbox.setSelection(this.exportTranslationsToStorage.get());
        this.exportTranslationsCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Object source = e.getSource();
                if (LanguageConversionSettingsWizardPage.this.exportTranslationsCheckbox.equals(source)) {
                    LanguageConversionSettingsWizardPage.this.exportTranslationsToStorage.set(LanguageConversionSettingsWizardPage.this.exportTranslationsCheckbox.getSelection());
                    LanguageConversionSettingsWizardPage.this.storageCombobox.getControl().setEnabled(LanguageConversionSettingsWizardPage.this.exportTranslationsCheckbox.getSelection());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.exportTranslationsCheckbox.setFont(font);
        this.storageCombobox = new ComboViewer(storageGroup, 2056);
        this.storageCombobox.setLabelProvider((IBaseLabelProvider)this.storageLabelProvider);
        this.storageCombobox.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        Combo combo = this.storageCombobox.getCombo();
        combo.setLayoutData((Object)new GridData(768));
        combo.setFont(font);
        this.storageCombobox.addSelectionChangedListener(event -> {
            Object element = ((IStructuredSelection)event.getSelection()).getFirstElement();
            if (element instanceof StorageID) {
                this.targetStorageId.set((StorageID)element);
            }
        });
        ArrayList<StorageID> input = new ArrayList<StorageID>(this.storageSettingsManager.getReadStorageIds(this.project));
        StorageID editig = this.storageSettingsManager.getSettingsOrDefault(this.project).getEdit().getStorageId();
        if (!input.contains(editig)) {
            input.add(0, editig);
        }
        this.storageCombobox.setInput(input);
        this.createProjectGroup(topLevel);
        StorageID defaultStorageId = null;
        StorageID currentTargetStorageId = this.targetStorageId.get();
        if (currentTargetStorageId != null && this.storageSettingsManager.isStorageAvailable(this.project, currentTargetStorageId)) {
            defaultStorageId = currentTargetStorageId;
        } else {
            List availableStorageIds = this.storageSettingsManager.getReadStorageIds(this.project);
            for (StorageID storageId : availableStorageIds) {
                ITranslationStorageProvider.Storage storage = this.storageManager.getStorage(this.project, storageId);
                if (storage.getType() != ITranslationStorageProvider.Storage.Type.CONTEXT) continue;
                defaultStorageId = storageId;
                break;
            }
        }
        if (defaultStorageId != null) {
            this.storageCombobox.setSelection((ISelection)new StructuredSelection((Object)defaultStorageId));
        } else {
            this.storageCombobox.setSelection((ISelection)new StructuredSelection());
        }
        this.setControl((Control)topLevel);
        Dialog.applyDialogFont((Control)topLevel);
        this.setPageComplete(this.validatePage());
    }

    protected void createProjectGroup(Composite parent) {
        Font font = parent.getFont();
        Group group = new Group(parent, 0);
        group.setText(Messages.LanguageConversionSettingsWizardPage_Project_for_interface);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(768));
        final Button inProjectRadio = new Button((Composite)group, 16);
        inProjectRadio.setText(Messages.LanguageConversionSettingsWizardPage_Existing_project);
        inProjectRadio.setSelection(!this.createNewProject);
        this.projectCombobox = new ComboViewer((Composite)group, 2056);
        this.projectCombobox.setLabelProvider((IBaseLabelProvider)this.projectLabelProvider);
        this.projectCombobox.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.projectCombobox.setInput((Object)ResourcesPlugin.getWorkspace().getRoot().getProjects());
        if (this.targetProject.isAccessible()) {
            this.projectCombobox.setSelection((ISelection)new StructuredSelection((Object)this.targetProject), true);
        } else {
            this.projectCombobox.setSelection((ISelection)new StructuredSelection((Object)this.project), true);
        }
        Combo combo = this.projectCombobox.getCombo();
        combo.setLayoutData((Object)new GridData(768));
        combo.setFont(font);
        final Button createProjectRadio = new Button((Composite)group, 16);
        createProjectRadio.setText(Messages.LanguageConversionSettingsWizardPage_Create_project);
        createProjectRadio.setSelection(this.createNewProject);
        this.projectNameField = new Text((Composite)group, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.projectNameField.setLayoutData((Object)data);
        this.projectNameField.setFont(parent.getFont());
        if (this.initialProjectFieldValue != null) {
            this.projectNameField.setText(this.initialProjectFieldValue);
        }
        this.projectNameField.addListener(24, this.nameModifyListener);
        BidiUtils.applyBidiProcessing((Text)this.projectNameField, (String)"default");
        this.locationArea = new ProjectContentsLocationArea(this.getErrorReporter(), parent);
        if (this.initialProjectFieldValue != null) {
            this.locationArea.updateProjectName(this.initialProjectFieldValue);
        }
        this.setButtonLayoutData(this.locationArea.getBrowseButton());
        SelectionAdapter buttonSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.getSource().equals(inProjectRadio)) {
                    LanguageConversionSettingsWizardPage.this.createNewProject = false;
                } else if (e.getSource().equals(createProjectRadio)) {
                    LanguageConversionSettingsWizardPage.this.createNewProject = true;
                    LanguageConversionSettingsWizardPage.this.projectNameField.setFocus();
                }
                LanguageConversionSettingsWizardPage.this.projectCombobox.getControl().setEnabled(!LanguageConversionSettingsWizardPage.this.createNewProject);
                LanguageConversionSettingsWizardPage.this.projectNameField.setEnabled(LanguageConversionSettingsWizardPage.this.createNewProject);
                LanguageConversionSettingsWizardPage.this.setPageComplete(LanguageConversionSettingsWizardPage.this.validatePage());
            }
        };
        inProjectRadio.addSelectionListener((SelectionListener)buttonSelectionListener);
        createProjectRadio.addSelectionListener((SelectionListener)buttonSelectionListener);
        createProjectRadio.setSelection(this.createNewProject);
        this.projectCombobox.getControl().setEnabled(!this.createNewProject);
        this.projectNameField.setEnabled(this.createNewProject);
    }

    private void fillLanguagesList() {
        Configuration configuration = this.configurationProvider.getConfiguration(this.project);
        if (configuration != null) {
            Language defaultLanguage = configuration.getDefaultLanguage();
            List languagesList = new ArrayList(configuration.getLanguages()).stream().filter(language2 -> !language2.equals(defaultLanguage) && !(language2 instanceof V8TranslateLanguage)).collect(Collectors.toList());
            this.languagesViewer.setInput(languagesList);
            for (Language language : languagesList) {
                this.languagesViewer.setChecked((Object)language, this.selectedLanguages.contains(language));
            }
        }
    }

    public void init(IProject project, Set<Language> selectedLanguages, AtomicBoolean exportTranslationsToStorage, AtomicReference<StorageID> targetStorageId) {
        this.project = project;
        this.selectedLanguages = selectedLanguages;
        this.exportTranslationsToStorage = exportTranslationsToStorage;
        this.targetStorageId = targetStorageId;
        if (selectedLanguages.size() == 1) {
            Language lang = selectedLanguages.iterator().next();
            this.initialProjectFieldValue = project.getName() + "." + lang.getName();
        } else {
            this.initialProjectFieldValue = project.getName() + Messages.LanguageConversionSettingsWizardPage_dot_Interface;
        }
        this.targetProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.initialProjectFieldValue);
        if (!this.targetProject.exists()) {
            this.targetProject = project;
        }
    }

    public IProject getTargetProject() {
        if (this.createNewProject) {
            return this.getProjectHandle();
        }
        return (IProject)this.projectCombobox.getStructuredSelection().getFirstElement();
    }

    public boolean useDefaults() {
        return this.locationArea.isDefault();
    }

    public URI getLocationURI() {
        return this.locationArea.getProjectLocationURI();
    }

    public boolean validatePage() {
        if (this.createNewProject) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            String projectFieldContents = this.getProjectNameFieldValue();
            if (projectFieldContents.isEmpty()) {
                this.setErrorMessage(null);
                this.setMessage(Messages.LanguageConversionSettingsWizardPage_Project_name_is_empty);
                return false;
            }
            IStatus nameStatus = workspace.validateName(projectFieldContents, 4);
            if (!nameStatus.isOK()) {
                this.setErrorMessage(nameStatus.getMessage());
                return false;
            }
            IProject handle = this.getProjectHandle();
            if (handle.exists()) {
                this.setErrorMessage(Messages.LanguageConversionSettingsWizardPage_Project_exists);
                return false;
            }
            IProject projectHandl = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectNameFieldValue());
            this.locationArea.setExistingProject(projectHandl);
            String validLocationMessage = this.locationArea.checkValidLocation();
            if (validLocationMessage != null) {
                this.setErrorMessage(validLocationMessage);
                return false;
            }
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        return !this.selectedLanguages.isEmpty();
    }

    private String getProjectNameFieldValue() {
        if (this.projectNameField == null) {
            return "";
        }
        return this.projectNameField.getText().trim();
    }

    private IProject getProjectHandle() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectNameFieldValue());
    }

    private void setLocationForSelection() {
        this.locationArea.updateProjectName(this.getProjectNameFieldValue());
    }

    private ProjectContentsLocationArea.IErrorMessageReporter getErrorReporter() {
        return (errorMessage, infoOnly) -> {
            boolean valid;
            if (infoOnly) {
                this.setMessage(errorMessage, 1);
                this.setErrorMessage(null);
            } else {
                this.setErrorMessage(errorMessage);
            }
            boolean bl = valid = errorMessage == null;
            if (valid) {
                valid = this.validatePage();
            }
            this.setPageComplete(valid);
        };
    }

    private static class LanguageLabelProvider
    extends BaseLabelProvider
    implements ILabelProvider {
        private LanguageLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof Language) {
                Language language = (Language)element;
                return language.getName();
            }
            return null;
        }
    }

    private static class ProjectLabelProvider
    extends BaseLabelProvider
    implements ILabelProvider {
        private ProjectLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof IProject) {
                IProject project = (IProject)element;
                return project.getName();
            }
            return null;
        }
    }

    private class StorageLabelProvider
    extends BaseLabelProvider
    implements ILabelProvider {
        private StorageLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof StorageID) {
                StorageID id = (StorageID)element;
                return LanguageConversionSettingsWizardPage.this.storageManager.getStorageProvider(id).getStorageDescription(LanguageConversionSettingsWizardPage.this.project, id.getSegment());
            }
            return null;
        }
    }
}

