/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.ui.navigator;

import com.e1c.langtool.TranslationSource;
import com.e1c.langtool.TranslationUtils;
import com.e1c.langtool.collector.FeatureCollectorFactory;
import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.collector.FeatureValueCollector;
import com.e1c.langtool.collector.ICollectingParameters;
import com.e1c.langtool.collector.IFeatureValueCollectingService;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Set;
import java.util.function.BiConsumer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ui.IFileEditorInput;

public class FileEditorInputFeatureCollectorFactory
implements FeatureCollectorFactory {
    @Inject
    private IFeatureValueCollectingService collectingService;

    public boolean isSupport(Object object) {
        if (!(object instanceof IFileEditorInput)) {
            return false;
        }
        IFile file = ((IFileEditorInput)object).getFile();
        return this.collectingService.hasCollector((Object)file);
    }

    public Set<FeatureValueCollector> createCollectors(Object object, ICollectingParameters parameters, BiConsumer<Object, FeatureValue> addAction) {
        Assert.isLegal((boolean)(object instanceof IFileEditorInput), (String)"Object must be IFileEditorInput");
        IFile file = ((IFileEditorInput)object).getFile();
        TranslationSource source = TranslationUtils.getTranslationSource((Object)file);
        return Sets.newHashSet((Iterable)this.collectingService.createCollectors(source, parameters, addAction));
    }
}

