/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.ui.navigator.actions;

import com._1c.g5.v8.dt.navigator.adapters.CollectionNavigatorAdapterBase;
import com._1c.g5.v8.dt.ui.util.OpenHelper;
import com.e1c.langtool.v8.dt.internal.ui.V8UiPlugin;
import com.e1c.langtool.v8.dt.ui.navigator.actions.Messages;
import com.google.common.base.Preconditions;
import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class OpenAction
extends BaseSelectionListenerAction {
    private final OpenHelper helper;
    private IWorkbenchPage workbenchPage;

    public OpenAction(IWorkbenchPage workbenchPage) {
        super(Messages.OpenAction_Open_translation);
        this.helper = new OpenHelper((IWorkbenchPage)Preconditions.checkNotNull((Object)workbenchPage));
        this.workbenchPage = workbenchPage;
        this.setImageDescriptor(V8UiPlugin.getImageDescriptor("com.e1c.langtool.v8.dt.ui/etool16/open_translation_edit.png"));
    }

    public void run() {
        Object[] objects = this.getStructuredSelection().toArray();
        int total = objects.length;
        int i = 0;
        while (i < total) {
            Object obj = objects[i];
            IEditorInput input = null;
            if (obj instanceof EObject) {
                input = this.helper.getEditorInput((EObject)obj, null, null);
            } else if (obj instanceof IWorkbenchAdapter) {
                input = this.getEditorInput((IWorkbenchAdapter)obj);
            }
            if (input != null) {
                try {
                    this.workbenchPage.openEditor(input, "com.e1c.langtool.ui.editor.TranslationEditor", true);
                }
                catch (PartInitException e) {
                    V8UiPlugin.logError(e);
                }
            }
            ++i;
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        Iterator candidates = selection.iterator();
        boolean result = false;
        while (candidates.hasNext()) {
            Object candidate = candidates.next();
            result |= candidate instanceof EObject;
            if (result |= candidate instanceof IWorkbenchAdapter) break;
        }
        return result && super.updateSelection(selection);
    }

    private IEditorInput getEditorInput(IWorkbenchAdapter workbenchAdapter) {
        if (workbenchAdapter instanceof CollectionNavigatorAdapterBase) {
            CollectionNavigatorAdapterBase collectionNavigatorAdapter = (CollectionNavigatorAdapterBase)workbenchAdapter;
            return this.helper.getEditorInput(collectionNavigatorAdapter.getModel(true), (EStructuralFeature)collectionNavigatorAdapter.getContentFeature(), null);
        }
        return null;
    }
}

