/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.ui.navigator.actions;

import com.e1c.langtool.v8.dt.ui.navigator.actions.Messages;
import com.e1c.langtool.v8.dt.ui.navigator.actions.OpenAction;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.OpenFileAction;
import org.eclipse.ui.actions.OpenSystemEditorAction;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;

public class OpenActionProvider
extends CommonActionProvider {
    private OpenAction openEObjectAction;
    private OpenSystemEditorAction openSystemEditorAction;
    private OpenFileAction openFileAction;
    private ICommonViewerWorkbenchSite viewSite = null;
    private boolean contribute = false;

    public void init(ICommonActionExtensionSite config) {
        if (config.getViewSite() instanceof ICommonViewerWorkbenchSite) {
            this.viewSite = (ICommonViewerWorkbenchSite)config.getViewSite();
            this.openEObjectAction = new OpenAction(this.viewSite.getPage());
            this.openSystemEditorAction = new OpenSystemEditorAction(this.viewSite.getPage());
            this.openSystemEditorAction.setText(Messages.OpenActionProvider_Open);
            this.openFileAction = new OpenFileAction(this.viewSite.getPage());
            this.contribute = true;
        }
    }

    public void fillContextMenu(IMenuManager menu) {
        if (this.contribute && !this.getContext().getSelection().isEmpty()) {
            IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
            this.openEObjectAction.selectionChanged(selection);
            this.openSystemEditorAction.selectionChanged(selection);
            this.openFileAction.selectionChanged(selection);
            if (this.openEObjectAction.isEnabled()) {
                menu.remove("org.eclipse.ui.OpenFileAction");
                menu.insertBefore("group.open", (IAction)this.openEObjectAction);
            } else if (this.openFileAction.isEnabled()) {
                menu.remove("org.eclipse.ui.OpenFileAction");
                menu.insertAfter("group.open", (IAction)this.openFileAction);
            }
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        IStructuredSelection selection;
        if (this.contribute && (selection = (IStructuredSelection)this.getContext().getSelection()).size() == 1) {
            if (selection.getFirstElement() instanceof EObject) {
                this.openEObjectAction.selectionChanged(selection);
                actionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", (IAction)this.openEObjectAction);
            } else if (selection.getFirstElement() instanceof IFile) {
                this.openFileAction.selectionChanged(selection);
                actionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", (IAction)this.openFileAction);
            }
        }
    }
}

