/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.ui.projecteditor;

import com._1c.g5.v8.bm.core.IBmObject;
import com._1c.g5.v8.bm.core.IBmTransaction;
import com._1c.g5.v8.bm.integration.AbstractBmTask;
import com._1c.g5.v8.bm.integration.IBmModel;
import com._1c.g5.v8.bm.integration.IBmTask;
import com._1c.g5.v8.dt.core.platform.IBmModelManager;
import com._1c.g5.v8.dt.core.platform.IExtensionProject;
import com._1c.g5.v8.dt.core.platform.IExternalObjectProject;
import com._1c.g5.v8.dt.core.platform.IV8Project;
import com._1c.g5.v8.dt.core.platform.IV8ProjectManager;
import com._1c.g5.v8.dt.metadata.mdclass.Configuration;
import com._1c.g5.v8.dt.metadata.mdclass.Language;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.platform.TranslationOption;
import com.e1c.langtool.v8.dt.internal.ui.V8UiPlugin;
import com.e1c.langtool.v8.dt.lang.model.TranslateLanguageFactory;
import com.e1c.langtool.v8.dt.lang.model.V8TranslateLanguage;
import com.e1c.langtool.v8.dt.platform.DependentProject;
import com.e1c.langtool.v8.dt.platform.IDependentProject;
import com.e1c.langtool.v8.dt.projectsettings.DependentManifestUtils;
import com.e1c.langtool.v8.dt.projectsettings.ManifestException;
import com.e1c.langtool.v8.dt.projectsettings.TranslateLanguageManifest;
import com.e1c.langtool.v8.dt.projectsettings.TranslatedProjectManifest;
import com.e1c.langtool.v8.dt.settings.model.V8TranslatedProject;
import com.e1c.langtool.v8.dt.ui.projecteditor.ExternalProjectSettings;
import com.e1c.langtool.v8.dt.ui.projecteditor.ExternalProjectUtils;
import com.e1c.langtool.v8.dt.ui.projecteditor.IExternalProjectSettings;
import com.e1c.langtool.v8.dt.ui.projecteditor.ILanguageChangedListener;
import com.e1c.langtool.v8.dt.ui.projecteditor.ISettingsEditingContext;
import com.e1c.langtool.v8.dt.ui.projecteditor.ITranslateLanguageSettings;
import com.e1c.langtool.v8.dt.ui.projecteditor.ITranslatedProjectSettings;
import com.e1c.langtool.v8.dt.ui.projecteditor.Messages;
import com.e1c.langtool.v8.dt.ui.projecteditor.TranslateLanguageSettings;
import com.e1c.langtool.v8.dt.ui.projecteditor.TranslatedProjectSettings;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public abstract class AbstractSettingsEditingContext
implements ISettingsEditingContext {
    @Inject
    private ITranslatingProjectManager projectManager;
    @Inject
    private IV8ProjectManager v8ProjectManager;
    @Inject
    private IBmModelManager modelManager;
    private Settings settings;
    private List<String> projectNameSnapshot = new ArrayList<String>();
    private Map<V8TranslateLanguage, IFile> languageSnapshot = ImmutableMap.of();
    private List<IProject> dependentProjectSnapshot = ImmutableList.of();
    private boolean isDisposed = false;
    protected List<V8TranslateLanguage> configurationLanugages;
    private V8TranslateLanguage defaultProjectLanguage;
    private volatile boolean isDirty = false;
    private List<ILanguageChangedListener> languageChangeListeners = new CopyOnWriteArrayList<ILanguageChangedListener>();

    @Override
    public void addLanguageChangedListener(ILanguageChangedListener languageChangedListener) {
        if (!this.languageChangeListeners.contains(languageChangedListener)) {
            this.languageChangeListeners.add(languageChangedListener);
        }
    }

    @Override
    public void removeLanguageChangedListener(ILanguageChangedListener languageChangedListener) {
        this.languageChangeListeners.remove(languageChangedListener);
    }

    @Override
    public IExternalProjectSettings getExternalProjectSettings() {
        return this.getSettings().getExternalProjectSettings();
    }

    @Override
    public ITranslatedProjectSettings getTranslatedProjectSettings() {
        return this.getSettings().getTranslatedProjectSettings();
    }

    @Override
    public ITranslateLanguageSettings getTranslateLanguageSettings() {
        return this.getSettings().getTranslateLanguageSettings();
    }

    @Override
    public boolean isDirty() {
        return this.isDirty;
    }

    @Override
    public void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
    }

    @Override
    public void markDirty() {
        this.isDirty = true;
    }

    @Override
    public void doSave(IProgressMonitor monitor) {
        if (!this.isDirty()) {
            return;
        }
        boolean isTranslatable = false;
        if (!this.settings.getTranslateLanguageSettings().getAllLanguages().isEmpty()) {
            isTranslatable = true;
        }
        try {
            this.performUpdateExternalProjects(monitor);
            this.deleteTranslatedProjectConfigs(this.getProject());
            this.saveTranslatedProjectConfigs(this.getProject(), monitor);
        }
        catch (ManifestException e) {
            V8UiPlugin.logError(e);
            return;
        }
        this.isDirty = false;
        try {
            IProject project = this.getProject();
            if (this.settings.getTranslatedProjectSettings().getAllProjects().isEmpty()) {
                this.removeBuilderIfExist(project, "com.e1c.langtool.sync.SynchronizationBuilder");
            } else {
                this.addBuilderIfNotExist(project, "com.e1c.langtool.sync.SynchronizationBuilder");
            }
            if (isTranslatable) {
                List<V8TranslateLanguage> coreLangs = this.getSettings().getTranslateLanguageSettings().getAllLanguages();
                this.projectManager.register(project, (List)ImmutableList.copyOf(coreLangs));
                for (IDependentProject dependent : this.getSettings().getExternalProjectSettings().getAll()) {
                    this.projectManager.register(dependent.getParent(), dependent.getSourceProject(), dependent.getLanguages());
                }
                this.addBuilderIfNotExist(project, "com.e1c.langtool.builder.translationBuilder");
                this.invokeTranslationBuilder(project, 6);
            } else {
                this.projectManager.deregister(project);
                this.removeBuilderIfExist(project, "com.e1c.langtool.builder.translationBuilder");
                this.invokeTranslationBuilder(project, 15);
            }
        }
        catch (CoreException e) {
            V8UiPlugin.logError(e);
            return;
        }
        this.createSettingsSnapshot();
    }

    @Override
    public List<V8TranslateLanguage> getLanguages() {
        if (this.getProject() == null) {
            return Lists.newArrayList();
        }
        HashSet languages = Sets.newHashSet(this.getProjectLanguages());
        languages.addAll(this.getSettings().getTranslateLanguageSettings().getAllLanguages());
        return Lists.newArrayList((Iterable)languages);
    }

    @Override
    public boolean isDisposed() {
        return this.isDisposed;
    }

    @Override
    public void dispose() {
        this.isDisposed = true;
        this.settings = null;
    }

    @Override
    public synchronized List<V8TranslateLanguage> getProjectLanguages() {
        if (this.getProject() == null) {
            return Lists.newArrayList();
        }
        if (this.configurationLanugages == null) {
            ArrayList languages = Lists.newArrayList();
            IV8Project v8project = this.v8ProjectManager.getProject(this.getProject());
            if (v8project != null) {
                Language defaultLang = v8project.getDefaultLanguage();
                if (v8project instanceof IExternalObjectProject && !((IExternalObjectProject)v8project).getLanguages().isEmpty() && !((IExternalObjectProject)v8project).getLanguages().contains(defaultLang)) {
                    defaultLang = (Language)((IExternalObjectProject)v8project).getLanguages().iterator().next();
                } else if (defaultLang == null && v8project instanceof IExtensionProject && ((IExtensionProject)v8project).getParent() != null) {
                    defaultLang = ((IExtensionProject)v8project).getParent().getDefaultLanguage();
                }
                for (Language lang : v8project.getLanguages()) {
                    V8TranslateLanguage newLang = null;
                    for (V8TranslateLanguage translateLanguage : this.getSettings().getTranslateLanguageSettings().getAllLanguages()) {
                        if (Strings.isNullOrEmpty((String)lang.getLanguageCode()) || !lang.getLanguageCode().equals(translateLanguage.getLanguageCode())) continue;
                        newLang = translateLanguage;
                        break;
                    }
                    if (newLang == null) {
                        newLang = TranslateLanguageFactory.eINSTANCE.createV8TranslateLanguage();
                        if (lang.getName().equals(defaultLang.getName())) {
                            newLang.setOption(TranslationOption.MODEL_AND_INTERFACE);
                        } else {
                            newLang.setOption(TranslationOption.INTERFACE_ONLY);
                        }
                        newLang.setName(lang.getName());
                        if (lang.getSynonym() != null && !lang.getSynonym().isEmpty()) {
                            for (Map.Entry entry : lang.getSynonym()) {
                                newLang.getSynonym().put((Object)((String)entry.getKey()), (Object)((String)entry.getValue()));
                            }
                        }
                        newLang.setComment(lang.getComment());
                        newLang.setLanguageCode(lang.getLanguageCode());
                        newLang.setUuid(lang.getUuid());
                    }
                    if (lang.getName().equals(defaultLang.getName())) {
                        this.defaultProjectLanguage = newLang;
                    }
                    languages.add(newLang);
                }
            }
            this.configurationLanugages = ImmutableList.copyOf((Collection)languages);
        }
        return this.configurationLanugages;
    }

    @Override
    public synchronized V8TranslateLanguage getDefaulProjectLanguage() {
        if (this.defaultProjectLanguage == null) {
            this.getProjectLanguages();
        }
        return this.defaultProjectLanguage;
    }

    private void saveTranslatedProjectConfigs(IProject project, IProgressMonitor monitor) {
        TranslatedProjectManifest.saveAll((IProject)project, this.settings.getTranslatedProjectSettings().getAllProjects(), (IProgressMonitor)monitor);
    }

    private void addNature(IProject project, String natureId) throws CoreException {
        IProjectDescription desc = project.getDescription();
        String[] prevNatures = desc.getNatureIds();
        boolean isExist = Arrays.stream(prevNatures).anyMatch(natureId::equals);
        if (isExist) {
            return;
        }
        String[] newNatures = new String[prevNatures.length + 1];
        System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
        newNatures[prevNatures.length] = natureId;
        desc.setNatureIds(newNatures);
        project.setDescription(desc, (IProgressMonitor)new NullProgressMonitor());
    }

    private void performUpdateExternalProjects(IProgressMonitor monitor) {
        ArrayList dependentProjectsToRemove = Lists.newArrayList(this.dependentProjectSnapshot);
        final HashMap languagesToRemove = Maps.newHashMap(this.languageSnapshot);
        this.settings.getExternalProjectSettings().getAll().forEach(dependent -> {
            for (TranslateLanguage language : dependent.getLanguages()) {
                IFile file = this.languageSnapshot.get(language);
                IFile newFile = TranslateLanguageManifest.getFile((IProject)dependent.getSourceProject(), (V8TranslateLanguage)((V8TranslateLanguage)language));
                if (file == null || !file.equals((Object)newFile)) continue;
                languagesToRemove.remove(language);
            }
        });
        languagesToRemove.forEach((l, file) -> TranslateLanguageManifest.delete((IFile)file, (IProgressMonitor)monitor));
        this.settings.getExternalProjectSettings().getAll().forEach(dependentProject -> {
            dependentProjectsToRemove.remove(dependentProject.getSourceProject());
            if (!this.dependentProjectSnapshot.contains(dependentProject.getSourceProject()) && !dependentProject.getParent().getProject().equals((Object)dependentProject.getSourceProject())) {
                DependentManifestUtils.writeManifest((IProject)dependentProject.getParent().getProject(), (IProject)dependentProject.getSourceProject(), (IProgressMonitor)monitor);
            }
            Collection v8Langs = dependentProject.getLanguages().stream().map(lang -> (V8TranslateLanguage)lang).collect(Collectors.toList());
            TranslateLanguageManifest.saveAll((IProject)dependentProject.getSourceProject(), (Collection)v8Langs, (IProgressMonitor)monitor);
            this.initExternalTranslationProject(dependentProject.getParent(), dependentProject.getSourceProject(), (Set<TranslateLanguage>)ImmutableSet.copyOf((Collection)v8Langs), monitor);
            v8Langs.forEach(l -> {
                Object v = languagesToRemove.remove(l);
            });
        });
        dependentProjectsToRemove.forEach(p -> {
            try {
                this.removeBuilderIfExist((IProject)p, "com.e1c.langtool.v8.dt.resourcestorage.dependentTranslationBuilder");
                this.removeBuilderIfExist((IProject)p, "com.e1c.langtool.v8.dt.resourcestorage.dependentSynchronizationBuilder");
                this.removeNature((IProject)p, "com.e1c.langtool.v8.dt.resourcestorage.dependentProjectNature");
                this.invokeTranslationBuilder((IProject)p, 15);
            }
            catch (CoreException e) {
                V8UiPlugin.logError(e);
            }
            DependentManifestUtils.removeManifest((IProject)p, (IProgressMonitor)monitor);
        });
        IBmModel model = this.modelManager.getModel(this.getProject());
        if (model != null && !languagesToRemove.isEmpty()) {
            model.getGlobalContext().execute((IBmTask)new AbstractBmTask<Void>("Remove language"){

                public Void execute(IBmTransaction transaction, IProgressMonitor monitor) {
                    IBmObject object = transaction.getTopObjectByFqn("Configuration");
                    if (object instanceof Configuration) {
                        Configuration configuration = (Configuration)object;
                        Iterator iterator = configuration.getLanguages().iterator();
                        while (iterator.hasNext()) {
                            Language lang = (Language)iterator.next();
                            if (!languagesToRemove.entrySet().stream().anyMatch(entry -> ((V8TranslateLanguage)entry.getKey()).getName().equals(lang.getName()))) continue;
                            iterator.remove();
                        }
                    }
                    return null;
                }
            });
        }
    }

    private void removeNature(IProject project, String natureId) throws CoreException {
        IProjectDescription desc = project.getDescription();
        String[] prevNatures = desc.getNatureIds();
        String[] newNatures = new String[prevNatures.length - 1];
        int j = 0;
        boolean isFound = false;
        int i = 0;
        while (i < prevNatures.length && j < newNatures.length) {
            if (!prevNatures[i].equals(natureId)) {
                newNatures[j++] = prevNatures[i];
            } else {
                isFound = true;
            }
            ++i;
        }
        if (!isFound) {
            return;
        }
        desc.setNatureIds(newNatures);
        project.setDescription(desc, (IProgressMonitor)new NullProgressMonitor());
    }

    private void addBuilderIfNotExist(IProject project, String builderId) throws CoreException {
        IProjectDescription desc = project.getDescription();
        ICommand[] commands = desc.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(builderId)) {
                return;
            }
            ++i;
        }
        ICommand command = desc.newCommand();
        command.setBuilderName(builderId);
        ICommand[] nc = new ICommand[commands.length + 1];
        System.arraycopy(commands, 0, nc, 0, commands.length);
        nc[commands.length] = command;
        desc.setBuildSpec(nc);
        project.setDescription(desc, null);
    }

    private void removeBuilderIfExist(IProject project, String builderId) throws CoreException {
        IProjectDescription desc = project.getDescription();
        ICommand[] commands = desc.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(builderId)) {
                ICommand[] newCommands = this.removeCommandAt(commands, i);
                desc.setBuildSpec(newCommands);
                project.setDescription(desc, null);
                return;
            }
            ++i;
        }
    }

    private ICommand[] removeCommandAt(ICommand[] commnads, int index) {
        ICommand[] newCommand = new ICommand[commnads.length - 1];
        int length = commnads.length;
        System.arraycopy(commnads, 0, newCommand, 0, index);
        if (index < length - 1) {
            System.arraycopy(commnads, index + 1, newCommand, index, length - index - 1);
        }
        return newCommand;
    }

    private void invokeTranslationBuilder(IProject project, int kind) {
        String jobMessage = kind == 15 ? Messages.AbstractSettingsEditingContext_CleanBuildJobName + project.getName() : Messages.AbstractSettingsEditingContext_FullBuildJobName + project.getName();
        Job.create((String)jobMessage, monitor -> {
            try {
                project.build(kind, "com.e1c.langtool.builder.translationBuilder", null, monitor);
            }
            catch (CoreException e) {
                V8UiPlugin.logError(e);
            }
            catch (OperationCanceledException e) {
                V8UiPlugin.log((IStatus)new Status(1, "com.e1c.langtool.v8.dt.ui", "Translation builder job has been canceled", (Throwable)e));
            }
            return Status.OK_STATUS;
        }).schedule();
    }

    private Settings loadSettings() {
        ITranslatingProject translatingProject = this.projectManager.getProject(this.getProject());
        Collection dependentProjects = this.projectManager.getAllExternalProjects(translatingProject);
        ArrayList<DependentProject> externalProjects = new ArrayList<DependentProject>();
        TranslateLanguage defaultLang = translatingProject.getInterfaceLanguages().contains(translatingProject.getDefaultLanguage()) ? null : translatingProject.getDefaultLanguage();
        ArrayList languages = Lists.newArrayList();
        for (IProject project : dependentProjects) {
            ArrayList v8Langs = new ArrayList();
            this.projectManager.getLanguagesForExternalProject(project).forEach(lang -> {
                if (!(!(lang instanceof V8TranslateLanguage) || defaultLang != null && (lang.equals(defaultLang) || lang.getName().equals(defaultLang.getName()) && lang.getLanguageCode().equals(defaultLang.getLanguageCode())))) {
                    v8Langs.add((V8TranslateLanguage)lang);
                }
            });
            languages.addAll(v8Langs);
            DependentProject dependentProject = new DependentProject(translatingProject, project, v8Langs);
            externalProjects.add(dependentProject);
        }
        List projects = TranslatedProjectManifest.loadAllIfAccessible((IProject)this.getProject());
        TranslatedProjectSettings projectSettings = new TranslatedProjectSettings(this, projects);
        TranslateLanguageSettings languageSettings = new TranslateLanguageSettings(this.languageChangeListeners, this, languages);
        ExternalProjectSettings externalProjectSettings = new ExternalProjectSettings(this, translatingProject, externalProjects);
        return new Settings(projectSettings, languageSettings, externalProjectSettings);
    }

    private void initExternalTranslationProject(ITranslatingProject translatingProject, IProject externalProject, Set<TranslateLanguage> langs, IProgressMonitor monitor) {
        try {
            if (!externalProject.exists()) {
                externalProject.create(monitor);
            }
            if (!externalProject.isOpen()) {
                externalProject.open(monitor);
            }
        }
        catch (CoreException e) {
            V8UiPlugin.logError(e);
        }
        if (!translatingProject.getProject().equals((Object)externalProject)) {
            try {
                this.addNature(externalProject, "com.e1c.langtool.v8.dt.resourcestorage.dependentProjectNature");
                this.addBuilderIfNotExist(externalProject, "com.e1c.langtool.v8.dt.resourcestorage.dependentTranslationBuilder");
                if (!this.settings.getTranslatedProjectSettings().getAllProjects().isEmpty()) {
                    this.addBuilderIfNotExist(externalProject, "com.e1c.langtool.v8.dt.resourcestorage.dependentSynchronizationBuilder");
                } else {
                    this.removeBuilderIfExist(externalProject, "com.e1c.langtool.v8.dt.resourcestorage.dependentSynchronizationBuilder");
                }
                this.invokeTranslationBuilder(externalProject, 6);
            }
            catch (CoreException e) {
                V8UiPlugin.logError(e);
            }
        }
        this.projectManager.register(translatingProject, externalProject, langs);
    }

    private void deleteTranslatedProjectConfigs(IProject project) {
        Set projectNames = this.settings.getTranslatedProjectSettings().getAllProjects().stream().map(V8TranslatedProject::getName).collect(Collectors.toSet());
        for (String projectName : this.projectNameSnapshot) {
            if (projectNames.contains(projectName)) continue;
            TranslatedProjectManifest.delete((IProject)project, (String)projectName, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    private synchronized Settings getSettings() {
        if (this.settings == null) {
            this.settings = this.loadSettings();
            ExternalProjectUtils.regroupProjects(this);
            this.isDirty = false;
            this.createSettingsSnapshot();
        }
        return this.settings;
    }

    private void createSettingsSnapshot() {
        this.projectNameSnapshot = this.settings.getTranslatedProjectSettings().getAllProjects().stream().map(V8TranslatedProject::getName).collect(Collectors.toList());
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this.settings.getExternalProjectSettings().getAll().forEach(dependent -> {
            for (TranslateLanguage language : dependent.getLanguages()) {
                if (!(language instanceof V8TranslateLanguage)) continue;
                IFile file = TranslateLanguageManifest.getFile((IProject)dependent.getSourceProject(), (V8TranslateLanguage)((V8TranslateLanguage)language));
                builder.put((Object)((V8TranslateLanguage)language), (Object)file);
            }
        });
        this.languageSnapshot = builder.build();
        this.dependentProjectSnapshot = this.settings.getExternalProjectSettings().getAll().stream().filter(p -> !p.getSourceProject().equals((Object)p.getParent().getProject())).map(IDependentProject::getSourceProject).collect(Collectors.toList());
    }

    private static final class Settings {
        private final ITranslateLanguageSettings translateLanguageSettings;
        private final ITranslatedProjectSettings translatedProjectSettings;
        private final IExternalProjectSettings externalProjectSettings;

        public Settings(ITranslatedProjectSettings translatedProjectSettings, ITranslateLanguageSettings translateLanguageSettings, IExternalProjectSettings externalProjectSettings) {
            this.translatedProjectSettings = translatedProjectSettings;
            this.translateLanguageSettings = translateLanguageSettings;
            this.externalProjectSettings = externalProjectSettings;
        }

        public ITranslatedProjectSettings getTranslatedProjectSettings() {
            return this.translatedProjectSettings;
        }

        public ITranslateLanguageSettings getTranslateLanguageSettings() {
            return this.translateLanguageSettings;
        }

        public IExternalProjectSettings getExternalProjectSettings() {
            return this.externalProjectSettings;
        }
    }
}

