/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.ui.projecteditor;

import com._1c.g5.v8.dt.ui.V8UiSharedImages;
import com._1c.g5.v8.dt.ui.editor.IProjectEditor;
import com._1c.g5.v8.dt.ui.editor.IProjectEditorSection;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.ui.TransSharedImages;
import com.e1c.langtool.v8.dt.lang.model.V8TranslateLanguage;
import com.e1c.langtool.v8.dt.platform.DependentProject;
import com.e1c.langtool.v8.dt.platform.IDependentProject;
import com.e1c.langtool.v8.dt.ui.projecteditor.ExternalProjectUtils;
import com.e1c.langtool.v8.dt.ui.projecteditor.ExternalProjectWizard;
import com.e1c.langtool.v8.dt.ui.projecteditor.IExternalProjectSettings;
import com.e1c.langtool.v8.dt.ui.projecteditor.ILanguageChangedListener;
import com.e1c.langtool.v8.dt.ui.projecteditor.ISettingsEditingContext;
import com.e1c.langtool.v8.dt.ui.projecteditor.ISettingsEditingContextProvider;
import com.e1c.langtool.v8.dt.ui.projecteditor.Messages;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class ExternalProjectSection
implements IProjectEditorSection {
    private IProjectEditor editor;
    private TableViewer projectsViewer;
    private IAction editProjectAction;
    @Inject
    @Named(value="com.e1c.langtool.v8.dt.ui.ProjectEditorContextProvider")
    private ISettingsEditingContextProvider contextProvider;
    private ISettingsEditingContext context;
    private ILanguageChangedListener languageChangeListener;

    public void createContent(IProjectEditor projectEditor, IFormPage formPage, FormToolkit toolkit, Composite parent, Section section) {
        if (this.context == null) {
            this.context = this.contextProvider.getContext(projectEditor);
        }
        this.editor = projectEditor;
        GridDataFactory.fillDefaults().grab(true, false).hint(300, 180).applyTo((Control)section);
        Composite topLevel = toolkit.createComposite(parent);
        GridLayoutFactory.swtDefaults().applyTo(topLevel);
        GridDataFactory.fillDefaults().grab(true, true).hint(-1, 150).applyTo((Control)topLevel);
        this.projectsViewer = new TableViewer(topLevel, 68354);
        this.projectsViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.createViewerColumns(this.projectsViewer);
        Table projectTable = this.projectsViewer.getTable();
        projectTable.setHeaderVisible(true);
        projectTable.setLinesVisible(true);
        GridDataFactory.fillDefaults().grab(true, true).hint(-1, 100).applyTo((Control)projectTable);
        this.projectsViewer.addDoubleClickListener(event -> {
            if (this.projectsViewer == event.getViewer() && !event.getSelection().isEmpty() && event.getSelection() instanceof IStructuredSelection) {
                this.editProjectAction.run();
            }
        });
        this.editor.getSite().setSelectionProvider((ISelectionProvider)this.projectsViewer);
        this.\u0441reateToolBar(projectEditor, section);
        this.languageChangeListener = event -> {
            if (event.getAction() == ILanguageChangedListener.Action.ADDED) {
                this.performLanguageAddedAction(event.getLanguage());
                ExternalProjectUtils.regroupProjects(this.context);
            } else if (event.getAction() == ILanguageChangedListener.Action.DELETED) {
                this.performLanguageDeletedAction(event.getLanguage());
            } else {
                this.performLanguageModifiedAction(event.getLanguage());
            }
            this.refreshTableViewer();
        };
        this.context.addLanguageChangedListener(this.languageChangeListener);
    }

    private void performLanguageModifiedAction(V8TranslateLanguage language) {
        ArrayList modifiedProjects = new ArrayList();
        this.context.getExternalProjectSettings().getAll().forEach(dependentProject -> {
            Optional<TranslateLanguage> modifiedLang = dependentProject.getLanguages().stream().filter(lang -> lang.getName().equals(language.getName())).findFirst();
            if (modifiedLang.isPresent()) {
                List newLanguages = dependentProject.getLanguages().stream().map(lang -> {
                    if (lang.getName().equals(language.getName())) {
                        return language;
                    }
                    return lang;
                }).collect(Collectors.toList());
                DependentProject newDependentProject = new DependentProject(dependentProject.getParent(), dependentProject.getSourceProject(), newLanguages);
                modifiedProjects.add(newDependentProject);
            } else {
                modifiedProjects.add(dependentProject);
            }
        });
        IExternalProjectSettings settings = this.context.getExternalProjectSettings();
        ImmutableList oldProjects = ImmutableList.copyOf(settings.getAll());
        oldProjects.forEach(settings::remove);
        modifiedProjects.forEach(settings::add);
    }

    private void performLanguageDeletedAction(V8TranslateLanguage language) {
        ArrayList deletedProjects = new ArrayList();
        ArrayList addedProjects = new ArrayList();
        this.context.getExternalProjectSettings().getAll().forEach(dependentProject -> {
            Optional<TranslateLanguage> deletedLang = dependentProject.getLanguages().stream().filter(lang -> lang.getName().equals(language.getName())).findFirst();
            deletedLang.ifPresent(lang -> {
                deletedProjects.add(dependentProject);
                if (dependentProject.getLanguages().size() > 1) {
                    ArrayList newLangs = Lists.newArrayList((Iterable)dependentProject.getLanguages());
                    newLangs.remove(lang);
                    DependentProject newDependentProject = new DependentProject(dependentProject.getParent(), dependentProject.getSourceProject(), (Collection)newLangs);
                    addedProjects.add(newDependentProject);
                }
            });
            IExternalProjectSettings projectSettings = this.context.getExternalProjectSettings();
            deletedProjects.forEach(projectSettings::remove);
            addedProjects.forEach(projectSettings::add);
        });
    }

    private void performLanguageAddedAction(V8TranslateLanguage language) {
        ITranslatingProject translatingProject = this.context.getExternalProjectSettings().getTranslatingProject();
        DependentProject dependentProject = new DependentProject(translatingProject, translatingProject.getProject(), (Collection)ImmutableSet.of((Object)language));
        this.context.getExternalProjectSettings().add((IDependentProject)dependentProject);
    }

    private void createViewerColumns(TableViewer viewer) {
        TableViewerColumn targetProjectColumnViewer = new TableViewerColumn(viewer, 0);
        TableColumn targetProjectColumn = targetProjectColumnViewer.getColumn();
        targetProjectColumn.setText(Messages.ExternalProjectSection_ExternalProjectColumnName);
        targetProjectColumn.setWidth(100);
        targetProjectColumn.setResizable(true);
        targetProjectColumnViewer.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                IDependentProject trans = (IDependentProject)element;
                return trans.getSourceProject().getName();
            }
        });
        TableViewerColumn languagesColumnViewer = new TableViewerColumn(viewer, 0);
        TableColumn languagesColumn = languagesColumnViewer.getColumn();
        languagesColumn.setText(Messages.ExternalProjectSection_LanguagesColumnName);
        languagesColumn.setWidth(100);
        languagesColumn.setResizable(true);
        languagesColumnViewer.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                IDependentProject trans = (IDependentProject)element;
                return trans.getLanguages().stream().map(TranslateLanguage::getName).collect(Collectors.joining(", "));
            }
        });
    }

    public void dispose() {
        if (this.context != null && !this.context.isDisposed()) {
            this.context.dispose();
            this.context.removeLanguageChangedListener(this.languageChangeListener);
        }
    }

    public void doSave(IProgressMonitor monitor) throws CoreException {
        this.context.doSave(monitor);
    }

    public void inputChanged(IProjectEditor projectEditor) {
        this.editor = projectEditor;
        this.context = this.contextProvider.getContext(this.editor);
        this.projectsViewer.setInput(this.context.getExternalProjectSettings().getAll());
        this.context.setDirty(false);
    }

    public boolean isDirty() {
        return this.context.isDirty();
    }

    public IStatus validate() {
        return Status.OK_STATUS;
    }

    private void refreshTableViewer() {
        this.projectsViewer.setInput(this.context.getExternalProjectSettings().getAll());
        this.projectsViewer.refresh();
    }

    private void \u0441reateToolBar(IProjectEditor editor, Section section) {
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        ToolBar toolbar = toolBarManager.createControl((Composite)section);
        toolbar.setCursor(Display.getDefault().getSystemCursor(21));
        AddProject add = new AddProject((ISelectionProvider)this.projectsViewer);
        toolBarManager.add((IAction)add);
        this.editProjectAction = new EditProject((ISelectionProvider)this.projectsViewer);
        toolBarManager.add(this.editProjectAction);
        DeleteProject delete = new DeleteProject((ISelectionProvider)this.projectsViewer);
        toolBarManager.add((IAction)delete);
        IActionBars actionBars = ((IEditorSite)editor.getSite()).getActionBars();
        actionBars.setGlobalActionHandler("org.eclipse.ui.edit.delete", (IAction)delete);
        actionBars.setGlobalActionHandler("com._1c.g5.v8.dt.ui.commands.create", (IAction)add);
        actionBars.setGlobalActionHandler("com._1c.g5.v8.dt.ui.commands.openEditor", this.editProjectAction);
        toolBarManager.update(true);
        section.setTextClient((Control)toolbar);
    }

    private class AddProject
    extends SelectionProviderAction {
        protected AddProject(ISelectionProvider provider) {
            super(provider, Messages.TranslatedProjectSection_Add_Translated_Project);
            this.setImageDescriptor(TransSharedImages.getImageDescriptor((String)"com.e1c.langtool.ui/elcl16/add_translated_project.png"));
            this.setActionDefinitionId("com._1c.g5.v8.dt.ui.commands.create");
        }

        public void run() {
            ExternalProjectWizard wizard = new ExternalProjectWizard();
            wizard.init(ExternalProjectSection.this.context);
            WizardDialog dialog = new WizardDialog(ExternalProjectSection.this.editor.getSite().getShell(), (IWizard)wizard);
            dialog.open();
            ExternalProjectSection.this.refreshTableViewer();
        }
    }

    private class DeleteProject
    extends SelectionProviderAction {
        protected DeleteProject(ISelectionProvider provider) {
            super(provider, Messages.TranslatedProjectSection_Delete_Translated_Project);
            this.setImageDescriptor(V8UiSharedImages.getImageDescriptor((String)"/icons/obj16/delete_element.png"));
            this.setActionDefinitionId("org.eclipse.ui.edit.delete");
            this.setEnabled(false);
        }

        public void run() {
            IStructuredSelection selection = this.getStructuredSelection();
            if (selection != null && !selection.isEmpty()) {
                IDependentProject dependentProject = (IDependentProject)this.getStructuredSelection().getFirstElement();
                ExternalProjectSection.this.context.getExternalProjectSettings().remove(dependentProject);
                ExternalProjectUtils.regroupProjects(ExternalProjectSection.this.context);
                ExternalProjectSection.this.refreshTableViewer();
                ExternalProjectSection.this.context.markDirty();
            }
        }

        public void selectionChanged(IStructuredSelection selection) {
            if (selection.isEmpty()) {
                this.setEnabled(false);
            } else {
                IDependentProject dependentProject;
                if (selection.getFirstElement() instanceof IDependentProject && (dependentProject = (IDependentProject)selection.getFirstElement()).getParent().getProject().equals((Object)dependentProject.getSourceProject())) {
                    this.setEnabled(false);
                    return;
                }
                this.setEnabled(true);
            }
        }
    }

    private class EditProject
    extends SelectionProviderAction {
        protected EditProject(ISelectionProvider provider) {
            super(provider, Messages.TranslatedProjectSection_Edit_Translated_Project);
            this.setImageDescriptor(V8UiSharedImages.getImageDescriptor((String)"/icons/obj16/edit_element.png"));
            this.setActionDefinitionId("com._1c.g5.v8.dt.ui.commands.openEditor");
            this.setEnabled(false);
        }

        public void run() {
            if (this.getStructuredSelection().isEmpty()) {
                return;
            }
            ExternalProjectWizard wizard = new ExternalProjectWizard();
            wizard.init(ExternalProjectSection.this.context, (IDependentProject)this.getStructuredSelection().getFirstElement());
            WizardDialog dialog = new WizardDialog(ExternalProjectSection.this.editor.getSite().getShell(), (IWizard)wizard);
            dialog.open();
            ExternalProjectSection.this.refreshTableViewer();
        }

        public void selectionChanged(IStructuredSelection selection) {
            if (selection.isEmpty()) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }
    }
}

