/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.ui.projecteditor;

import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.v8.dt.platform.DependentProject;
import com.e1c.langtool.v8.dt.ui.projecteditor.IExternalProjectSettings;
import com.e1c.langtool.v8.dt.ui.projecteditor.ISettingsEditingContext;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;

public final class ExternalProjectUtils {
    public static void regroupProjects(ISettingsEditingContext context) {
        IExternalProjectSettings settings = context.getExternalProjectSettings();
        HashMap<LanguageKey, IProject> groupedByLanguage = new HashMap<LanguageKey, IProject>();
        context.getTranslateLanguageSettings().getAllLanguages().forEach(lang -> {
            LanguageKey languageKey = new LanguageKey((TranslateLanguage)lang);
            groupedByLanguage.put(languageKey, settings.getTranslatingProject().getProject());
        });
        settings.getAll().forEach(project -> project.getLanguages().forEach(lang -> {
            LanguageKey languageKey = new LanguageKey((TranslateLanguage)lang);
            groupedByLanguage.put(languageKey, project.getSourceProject());
        }));
        HashMultimap groupedProjects = HashMultimap.create();
        groupedByLanguage.forEach((arg_0, arg_1) -> ExternalProjectUtils.lambda$3((Multimap)groupedProjects, arg_0, arg_1));
        ArrayList<DependentProject> newProjects = new ArrayList<DependentProject>();
        for (IProject key : groupedProjects.keySet()) {
            if (groupedProjects.get((Object)key).isEmpty()) continue;
            DependentProject newProject = new DependentProject(settings.getTranslatingProject(), key, groupedProjects.get((Object)key));
            newProjects.add(newProject);
        }
        ArrayList projectsToDelete = Lists.newArrayList(settings.getAll());
        projectsToDelete.forEach(settings::remove);
        newProjects.forEach(settings::add);
    }

    private ExternalProjectUtils() {
        throw new IllegalStateException("Utility class");
    }

    private static /* synthetic */ void lambda$3(Multimap multimap, LanguageKey langKey, IProject projKey) {
        boolean bl = multimap.put((Object)projKey, (Object)langKey.getLanguage());
    }

    private static final class LanguageKey {
        private final TranslateLanguage language;

        public LanguageKey(TranslateLanguage language) {
            this.language = language;
        }

        public TranslateLanguage getLanguage() {
            return this.language;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.language == null ? 0 : this.language.getName().hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LanguageKey other = (LanguageKey)obj;
            return !(this.language == null ? other.language != null : !this.language.getName().equals(other.language.getName()));
        }
    }
}

