/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.ui.projecteditor;

import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.ui.TransSharedImages;
import com.e1c.langtool.v8.dt.lang.model.V8TranslateLanguage;
import com.e1c.langtool.v8.dt.platform.DependentProject;
import com.e1c.langtool.v8.dt.platform.IDependentProject;
import com.e1c.langtool.v8.dt.ui.projecteditor.ISettingsEditingContext;
import com.e1c.langtool.v8.dt.ui.projecteditor.Messages;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class ExternalProjectWizardPage
extends WizardPage
implements IWizardPage {
    private IDependentProject dependentProject;
    private ISettingsEditingContext context;
    private CheckboxTableViewer languagesTableViewer;
    private ComboViewer existingProjectCombobox;
    private final Map<String, String> languageToProjectCache = new HashMap<String, String>();
    private final boolean isNew;
    private PageValidationListener pageValidationListener = new PageValidationListener();

    public ExternalProjectWizardPage(ISettingsEditingContext context) {
        this(context, true);
        ITranslatingProject translatingProject = context.getExternalProjectSettings().getTranslatingProject();
        this.dependentProject = new DependentProject(translatingProject, translatingProject.getProject(), (Collection)ImmutableSet.of());
    }

    public ExternalProjectWizardPage(ISettingsEditingContext context, IDependentProject dependentProject) {
        this(context, false);
        this.dependentProject = Objects.requireNonNull(dependentProject);
    }

    private ExternalProjectWizardPage(ISettingsEditingContext context, boolean isNew) {
        super("Main", Messages.ExternalProjectWizardPage_Title, TransSharedImages.getImageDescriptor((String)"com.e1c.langtool.ui/wizban/translated_project.png"));
        this.setDescription(Messages.ExternalProjectWizardPage_Description);
        this.isNew = isNew;
        this.context = context;
        context.getExternalProjectSettings().getAll().forEach(project -> project.getLanguages().forEach(lang -> {
            String string = this.languageToProjectCache.put(lang.getName(), project.getSourceProject().getName());
        }));
    }

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite topLevel = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().numColumns(1).applyTo(topLevel);
        GridDataFactory.fillDefaults().grab(true, false).hint(-1, 150).applyTo((Control)topLevel);
        topLevel.setFont(font);
        this.createExternalProjectGroup(topLevel);
        this.createLanguagesTable(topLevel);
        this.pageValidationListener.checkPage();
        this.setMessage(null);
        this.setControl((Control)topLevel);
    }

    public IDependentProject getData() {
        ITranslatingProject translatingProject = this.context.getExternalProjectSettings().getTranslatingProject();
        IProject project = (IProject)this.existingProjectCombobox.getStructuredSelection().getFirstElement();
        Set languages = Arrays.stream(this.languagesTableViewer.getCheckedElements()).map(obj -> (V8TranslateLanguage)obj).collect(Collectors.toSet());
        return new DependentProject(translatingProject, project, languages);
    }

    private void createExternalProjectGroup(Composite topLevel) {
        int ix;
        IProject[] projects;
        Font font = topLevel.getFont();
        Composite composite = new Composite(topLevel, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(768));
        Label existingProjectLabel = new Label(composite, 0);
        existingProjectLabel.setText(Messages.ExternalProjectWizardPage_ExternalProjectComboLabel);
        this.existingProjectCombobox = new ComboViewer(composite, 2056);
        this.existingProjectCombobox.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IProject) {
                    return ((IProject)element).getName();
                }
                return super.getText(element);
            }
        });
        this.existingProjectCombobox.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.existingProjectCombobox.addPostSelectionChangedListener((ISelectionChangedListener)this.pageValidationListener);
        Combo existingProjectCombo = this.existingProjectCombobox.getCombo();
        GridData gridData = new GridData(768);
        existingProjectCombo.setLayoutData((Object)gridData);
        existingProjectCombo.setFont(font);
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isAccessible()) {
                this.existingProjectCombobox.add((Object)project);
            }
            ++n2;
        }
        if (!this.isNew && (ix = existingProjectCombo.indexOf(this.dependentProject.getSourceProject().getName())) >= 0) {
            existingProjectCombo.select(ix);
        }
    }

    private void createLanguagesTable(Composite topLevel) {
        Label languagesLabel = new Label(topLevel, 0);
        languagesLabel.setText(Messages.ExternalProjectWizardPage_LanguagesLabel);
        this.languagesTableViewer = CheckboxTableViewer.newCheckList((Composite)topLevel, (int)68354);
        this.languagesTableViewer.addCheckStateListener((ICheckStateListener)this.pageValidationListener);
        this.languagesTableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof TranslateLanguage) {
                    String languageName = ((TranslateLanguage)element).getName();
                    Object text = languageName;
                    String projectName = ExternalProjectWizardPage.this.languageToProjectCache.get(languageName);
                    if (projectName != null) {
                        text = languageName + " (Stored in: " + projectName + ")";
                    }
                    return text;
                }
                return super.getText(element);
            }
        });
        this.languagesTableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.languagesTableViewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                return false;
            }

            public boolean isChecked(Object element) {
                if (element instanceof TranslateLanguage) {
                    return ExternalProjectWizardPage.this.dependentProject.getLanguages().contains(element);
                }
                return false;
            }
        });
        this.context.getTranslateLanguageSettings().getAllLanguages().forEach(arg_0 -> ((CheckboxTableViewer)this.languagesTableViewer).add(arg_0));
        Table interfaceLanguagesTable = this.languagesTableViewer.getTable();
        GridDataFactory.fillDefaults().grab(true, false).hint(-1, 150).applyTo((Control)interfaceLanguagesTable);
        interfaceLanguagesTable.setLayoutData((Object)new GridData(1808));
        interfaceLanguagesTable.setFont(topLevel.getFont());
    }

    private class PageValidationListener
    implements SelectionListener,
    ISelectionChangedListener,
    ICheckStateListener {
        private PageValidationListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            this.checkPage();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.checkPage();
        }

        private void checkPage() {
            boolean isValid = false;
            if (ExternalProjectWizardPage.this.existingProjectCombobox.getCombo().getSelectionIndex() == -1) {
                ExternalProjectWizardPage.this.setErrorMessage(Messages.ExternalProjectWizardPage_NoSuchProjectChosenErrorMsg);
            } else if (ExternalProjectWizardPage.this.languagesTableViewer.getCheckedElements().length == 0) {
                ExternalProjectWizardPage.this.setErrorMessage(Messages.ExternalProjectWizardPage_NoAnyLanguageChosenErrorMsg);
            } else {
                ExternalProjectWizardPage.this.setErrorMessage(null);
                isValid = true;
            }
            ExternalProjectWizardPage.this.setPageComplete(isValid);
        }

        public void selectionChanged(SelectionChangedEvent event) {
            this.checkPage();
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            this.checkPage();
        }
    }
}

