/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.ui.projecteditor;

import com.e1c.langtool.v8.dt.lang.model.V8TranslateLanguage;
import com.e1c.langtool.v8.dt.ui.projecteditor.ISettingsEditingContext;
import com.e1c.langtool.v8.dt.ui.projecteditor.Messages;
import com.google.common.base.Strings;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class LanguageCodeValidator
implements IValidator<String> {
    private final ISettingsEditingContext context;
    private final V8TranslateLanguage language;

    public LanguageCodeValidator(ISettingsEditingContext context, V8TranslateLanguage language) {
        this.context = context;
        this.language = language;
    }

    public IStatus validate(String value) {
        StringBuilder results = new StringBuilder();
        if (Strings.isNullOrEmpty((String)value)) {
            results.append(Messages.LanguageCodeValidator_Language_code_cannot_be_empty);
        }
        if (this.context != null && this.language != null) {
            for (V8TranslateLanguage lang : this.context.getTranslateLanguageSettings().getAllLanguages()) {
                if (this.language.equals(lang) || lang == null || this.language.getUuid().equals(lang.getUuid()) || !lang.getLanguageCode().equals(value)) continue;
                results.append(Messages.LanguageCodeValidator_Language_code_is_not_Unique);
                break;
            }
        }
        if (results.length() > 0) {
            return ValidationStatus.error((String)results.toString());
        }
        return Status.OK_STATUS;
    }
}

