/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.ui.projecteditor;

import com.e1c.langtool.v8.dt.lang.model.V8TranslateLanguage;
import com.e1c.langtool.v8.dt.ui.projecteditor.ISettingsEditingContext;
import com.e1c.langtool.v8.dt.ui.projecteditor.Messages;
import com.google.common.base.Strings;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class LanguageNameValidator
implements IValidator<String> {
    private final ISettingsEditingContext context;
    private final V8TranslateLanguage language;

    public LanguageNameValidator(ISettingsEditingContext context, V8TranslateLanguage language) {
        this.context = context;
        this.language = language;
    }

    public IStatus validate(String value) {
        StringBuilder results = new StringBuilder();
        if (Strings.isNullOrEmpty((String)value)) {
            results.append(Messages.LanguageNameValidator_Name_cannot_be_empty);
        }
        if (this.context != null && this.language != null) {
            for (V8TranslateLanguage lang : this.context.getLanguages()) {
                if (this.language.equals(lang) || lang == null || this.language.getUuid().equals(lang.getUuid()) || !lang.getName().equals(value)) continue;
                results.append(Messages.LanguageNameValidator_Name_is_not_Unique);
                break;
            }
        }
        if (results.length() > 0) {
            return ValidationStatus.error((String)results.toString());
        }
        return Status.OK_STATUS;
    }
}

