/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.ui.projecteditor;

import com.e1c.langtool.v8.dt.internal.ui.V8UiPlugin;
import com.e1c.langtool.v8.dt.lang.model.V8TranslateLanguage;
import com.e1c.langtool.v8.dt.ui.projecteditor.ILanguageChangedListener;
import com.e1c.langtool.v8.dt.ui.projecteditor.ISettingsEditingContext;
import com.e1c.langtool.v8.dt.ui.projecteditor.ITranslateLanguageSettings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.runtime.SafeRunner;

public class TranslateLanguageSettings
implements ITranslateLanguageSettings {
    private final ISettingsEditingContext context;
    private final List<V8TranslateLanguage> languages;
    private final List<ILanguageChangedListener> languageChangedListeners;

    public TranslateLanguageSettings(List<ILanguageChangedListener> languageChangedListeners, ISettingsEditingContext context, List<V8TranslateLanguage> languages) {
        this.languageChangedListeners = Objects.requireNonNull(languageChangedListeners);
        this.context = context;
        this.languages = new ArrayList<V8TranslateLanguage>(languages);
    }

    @Override
    public void add(V8TranslateLanguage language) {
        this.languages.add(language);
        this.context.markDirty();
        this.fireListeners(new ILanguageChangedListener.Event(language, ILanguageChangedListener.Action.ADDED));
    }

    @Override
    public void remove(V8TranslateLanguage language) {
        this.languages.remove(language);
        this.context.markDirty();
        this.fireListeners(new ILanguageChangedListener.Event(language, ILanguageChangedListener.Action.DELETED));
    }

    @Override
    public void update(V8TranslateLanguage language) {
        V8TranslateLanguage oldLanugage = this.languages.stream().filter(lang -> lang.getLanguageCode().equals(language.getLanguageCode())).findFirst().orElseThrow(() -> new IllegalArgumentException("The language to update was not found"));
        int ix = this.languages.indexOf(oldLanugage);
        this.languages.set(ix, language);
        this.context.markDirty();
        this.fireListeners(new ILanguageChangedListener.Event(language, ILanguageChangedListener.Action.MODIFIED));
    }

    @Override
    public List<V8TranslateLanguage> getAllLanguages() {
        return Collections.unmodifiableList(this.languages);
    }

    private void fireListeners(ILanguageChangedListener.Event event) {
        for (ILanguageChangedListener listener : this.languageChangedListeners) {
            try {
                SafeRunner.run(() -> listener.change(event));
            }
            catch (Throwable e) {
                V8UiPlugin.logError(e);
            }
        }
    }
}

