/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.ui.projecteditor;

import com._1c.g5.v8.dt.common.Functions;
import com._1c.g5.v8.dt.common.ui.CommonUI;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.platform.TranslationOption;
import com.e1c.langtool.ui.TransSharedImages;
import com.e1c.langtool.v8.dt.lang.model.V8TranslateLanguage;
import com.e1c.langtool.v8.dt.ui.projecteditor.ISettingsEditingContext;
import com.e1c.langtool.v8.dt.ui.projecteditor.LangObserver;
import com.e1c.langtool.v8.dt.ui.projecteditor.LanguageCodeValidator;
import com.e1c.langtool.v8.dt.ui.projecteditor.LanguageLiterals;
import com.e1c.langtool.v8.dt.ui.projecteditor.LanguageNameValidator;
import com.e1c.langtool.v8.dt.ui.projecteditor.Messages;
import com.e1c.langtool.v8.dt.ui.projecteditor.ProjectLableProvider;
import com.e1c.langtool.v8.dt.ui.projecteditor.TranslateLanguageWizard;
import com.e1c.langtool.v8.dt.ui.projecteditor.TranslateStringDialog;
import com.e1c.langtool.v8.dt.ui.projecteditor.TranslationOptionLableProvider;
import com.e1c.langtool.v8.dt.ui.projecteditor.V8ProjectValidator;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class TranslateLanguageWizardPage
extends WizardPage
implements IWizardPage {
    private static final String ATTR_CONTEXT_PROJECT = "contectProject";
    private final IObservableMap<Object, Object> attributesMap;
    private DataBindingContext dbc;
    private TranslationOptionLableProvider translationOptionLableProvider = new TranslationOptionLableProvider();
    private Binding synonymBind;

    protected TranslateLanguageWizardPage(IObservableMap<Object, Object> attributesMap) {
        super("Main", Messages.TranslateLanguageWizardPage_Title, TransSharedImages.getImageDescriptor((String)"com.e1c.langtool.ui/wizban/translate_language.png"));
        this.attributesMap = attributesMap;
        this.setDescription(Messages.TranslateLanguageWizardPage_Description);
    }

    public void createControl(Composite parent) {
        this.dbc = new EMFDataBindingContext();
        WizardPageSupport.create((WizardPage)this, (DataBindingContext)this.dbc);
        Font font = parent.getFont();
        Composite topLevel = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(topLevel);
        GridDataFactory.fillDefaults().grab(true, false).hint(-1, 150).applyTo((Control)topLevel);
        topLevel.setFont(font);
        Label projectLabel = new Label(topLevel, 0);
        projectLabel.setText(Messages.TranslateLanguageWizardPage_Project);
        ComboViewer projectViewer = new ComboViewer(topLevel, 2060);
        projectViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        projectViewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot().getProjects());
        projectViewer.setLabelProvider((IBaseLabelProvider)new ProjectLableProvider());
        Combo projectCombo = projectViewer.getCombo();
        projectCombo.setLayoutData((Object)new GridData(768));
        projectViewer.addSelectionChangedListener(event -> this.getWizard0().setProject((IProject)event.getStructuredSelection().getFirstElement()));
        Label nameLabel = new Label(topLevel, 0);
        nameLabel.setText((String)Functions.featureToLabel().apply((Object)LanguageLiterals.NAME));
        Text nameText = new Text(topLevel, 2052);
        nameText.setLayoutData((Object)new GridData(768));
        Label synonymLabel = new Label(topLevel, 0);
        synonymLabel.setText((String)Functions.featureToLabel().apply((Object)LanguageLiterals.SYNONYM));
        Composite synonymComposite = new Composite(topLevel, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        synonymComposite.setLayout((Layout)layout);
        synonymComposite.setLayoutData((Object)new GridData(768));
        Text synonymText = new Text(synonymComposite, 2048);
        synonymText.setLayoutData((Object)new GridData(768));
        Button synonymButtom = new Button(synonymComposite, 0x800000);
        synonymButtom.setImage(CommonUI.getImage((String)"icons/3dots.png"));
        synonymButtom.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        synonymButtom.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TranslateStringDialog dialog;
                LinkedHashMap inputData = Maps.newLinkedHashMap();
                LangObserver langObserver = new LangObserver(TranslateLanguageWizardPage.this.getContext());
                for (V8TranslateLanguage lang : langObserver.getLanguages()) {
                    inputData.put(lang.getLanguageCode(), (String)TranslateLanguageWizardPage.this.attributesMap.get((Object)lang.getLanguageCode()));
                }
                Object key = TranslateLanguageWizardPage.this.attributesMap.get((Object)LanguageLiterals.CODE);
                if (key != null && key instanceof String) {
                    inputData.put((String)key, (String)TranslateLanguageWizardPage.this.attributesMap.get(key));
                    langObserver.setCurrentLanguageCode((String)key);
                }
                if ((dialog = new TranslateStringDialog(TranslateLanguageWizardPage.this.getShell(), langObserver, false, inputData)).open() == 0) {
                    for (Map.Entry<String, String> entry : dialog.getValues().entrySet()) {
                        TranslateLanguageWizardPage.this.attributesMap.put((Object)entry.getKey(), (Object)entry.getValue());
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label commentLabel = new Label(topLevel, 0);
        commentLabel.setText((String)Functions.featureToLabel().apply((Object)LanguageLiterals.COMMENT));
        Text commentText = new Text(topLevel, 2048);
        commentText.setLayoutData((Object)new GridData(768));
        Label languageCodeLabel = new Label(topLevel, 0);
        languageCodeLabel.setText((String)Functions.featureToLabel().apply((Object)LanguageLiterals.CODE));
        Text languageCodeText = new Text(topLevel, 2048);
        languageCodeText.setLayoutData((Object)new GridData(768));
        Label optionLabel = new Label(topLevel, 0);
        optionLabel.setText((String)Functions.featureToLabel().apply((Object)LanguageLiterals.OPTION));
        ComboViewer optionViewer = new ComboViewer(topLevel, 2048);
        optionViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        optionViewer.setInput((Object)new Object[]{TranslationOption.INTERFACE_ONLY, TranslationOption.MODEL_AND_INTERFACE});
        optionViewer.setLabelProvider((IBaseLabelProvider)this.translationOptionLableProvider);
        Combo optionCombo = optionViewer.getCombo();
        optionCombo.setLayoutData((Object)new GridData(768));
        UpdateValueStrategy projectStrategy = new UpdateValueStrategy();
        projectStrategy.setAfterConvertValidator((IValidator)new V8ProjectValidator());
        boolean enabled = this.getContext().getProject() == null || !projectStrategy.validateAfterConvert((Object)this.getContext().getProject()).equals(Status.OK_STATUS);
        projectCombo.setEnabled(enabled);
        this.dbc.bindValue((IObservableValue)ViewerProperties.singleSelection(IProject.class).observe((Viewer)projectViewer), Observables.observeMapEntry(this.attributesMap, (Object)ATTR_CONTEXT_PROJECT), projectStrategy, null);
        UpdateValueStrategy strategy = new UpdateValueStrategy();
        strategy.setAfterConvertValidator((IValidator)new LanguageNameValidator(this.getContext(), this.getLanguage()));
        this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)nameText), Observables.observeMapEntry(this.attributesMap, (Object)LanguageLiterals.NAME), strategy, null);
        this.synonymBind = this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)synonymText), Observables.observeMapEntry(this.attributesMap, (Object)this.attributesMap.get((Object)LanguageLiterals.CODE)));
        this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)commentText), Observables.observeMapEntry(this.attributesMap, (Object)LanguageLiterals.COMMENT));
        UpdateValueStrategy languageCodeStrategy = new UpdateValueStrategy();
        languageCodeStrategy.setAfterConvertValidator((IValidator)new LanguageCodeValidator(this.getContext(), this.getLanguage()));
        languageCodeStrategy.setConverter(IConverter.create(fromObject -> {
            this.dbc.removeBinding(this.synonymBind);
            this.synonymBind.dispose();
            this.synonymBind = this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)synonymText), Observables.observeMapEntry(this.attributesMap, (Object)fromObject));
            return fromObject;
        }));
        this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)languageCodeText), Observables.observeMapEntry(this.attributesMap, (Object)LanguageLiterals.CODE), languageCodeStrategy, null);
        this.dbc.bindValue((IObservableValue)ViewerProperties.singleSelection().observe((Viewer)optionViewer), Observables.observeMapEntry(this.attributesMap, (Object)LanguageLiterals.OPTION));
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)topLevel);
    }

    public void dispose() {
        this.dbc.dispose();
        super.dispose();
    }

    protected boolean validatePage() {
        return StringUtils.isNullOrEmpty((String)this.getErrorMessage());
    }

    private TranslateLanguageWizard getWizard0() {
        return (TranslateLanguageWizard)this.getWizard();
    }

    private V8TranslateLanguage getLanguage() {
        return this.getWizard0().getLanguage();
    }

    private ISettingsEditingContext getContext() {
        return this.getWizard0().getEditingContext();
    }
}

