/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.ui.projecteditor;

import com.e1c.langtool.v8.dt.settings.model.V8TranslatedProject;
import com.e1c.langtool.v8.dt.ui.projecteditor.ISettingsEditingContext;
import com.e1c.langtool.v8.dt.ui.projecteditor.ITranslatedProjectSettings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TranslatedProjectSettings
implements ITranslatedProjectSettings {
    private final ISettingsEditingContext context;
    private final List<V8TranslatedProject> v8TranslatedProjects;

    public TranslatedProjectSettings(ISettingsEditingContext context, List<V8TranslatedProject> v8TranslatedProjects) {
        this.context = context;
        this.v8TranslatedProjects = new ArrayList<V8TranslatedProject>(v8TranslatedProjects);
    }

    @Override
    public void add(V8TranslatedProject v8TranslatedProject) {
        this.v8TranslatedProjects.add(v8TranslatedProject);
        this.context.markDirty();
    }

    @Override
    public void remove(V8TranslatedProject v8TranslatedProject) {
        this.v8TranslatedProjects.remove(v8TranslatedProject);
        this.context.markDirty();
    }

    @Override
    public void update(V8TranslatedProject v8TranslatedProject) {
        int ix = this.v8TranslatedProjects.indexOf(v8TranslatedProject);
        if (ix < 0) {
            throw new IllegalArgumentException("The project to update is not found");
        }
        this.v8TranslatedProjects.set(ix, v8TranslatedProject);
        this.context.markDirty();
    }

    @Override
    public List<V8TranslatedProject> getAllProjects() {
        return Collections.unmodifiableList(this.v8TranslatedProjects);
    }
}

