/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.ui.projecteditor;

import com._1c.g5.v8.dt.core.platform.IResourceLookup;
import com._1c.g5.v8.dt.md.ui.navigator.adapters.CommonNavigatorAdapter;
import com._1c.g5.v8.dt.navigator.adapters.IndexedTopObjectCollectionNavigatorAdapterBase;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.ui.ExecutionErrorDialog;
import com.e1c.langtool.v8.dt.internal.ui.V8UiPlugin;
import com.e1c.langtool.v8.dt.settings.model.V8TranslatedProject;
import com.e1c.langtool.v8.dt.settings.model.V8TranslatedProjectFactory;
import com.e1c.langtool.v8.dt.settings.model.V8TranslatedProjectPackage;
import com.e1c.langtool.v8.dt.ui.projecteditor.AbstractSettingsWizard;
import com.e1c.langtool.v8.dt.ui.projecteditor.ISettingsEditingContext;
import com.e1c.langtool.v8.dt.ui.projecteditor.Messages;
import com.e1c.langtool.v8.dt.ui.projecteditor.NewWizardEditingContext;
import com.e1c.langtool.v8.dt.ui.projecteditor.TranslatedProjectWizardPage;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class TranslatedProjectWizard
extends AbstractSettingsWizard
implements INewWizard {
    public static final String INTERFACE_LANGUAGES = "interface_languages";
    private IResourceLookup resourceLookup;
    private V8TranslatedProject project;
    private static final EStructuralFeature[] FEATURES = new EStructuralFeature[]{V8TranslatedProjectPackage.Literals.V8_TRANSLATED_PROJECT__NAME, V8TranslatedProjectPackage.Literals.V8_TRANSLATED_PROJECT__DEFAULT_LANGUAGE_NAME, V8TranslatedProjectPackage.Literals.V8_TRANSLATED_PROJECT__SCRIPT_VARIANT};
    protected boolean isNew;
    private boolean saveContextOnFinish = false;

    @Inject
    public TranslatedProjectWizard(IResourceLookup resourceLookup) {
        this(FEATURES, resourceLookup);
    }

    public TranslatedProjectWizard(EStructuralFeature[] features, IResourceLookup resourceLookup) {
        super(features);
        this.resourceLookup = (IResourceLookup)Preconditions.checkNotNull((Object)resourceLookup);
    }

    public void init(ISettingsEditingContext editingContext, V8TranslatedProject project) {
        this.setEditingContext(editingContext);
        this.isNew = false;
        this.setProject(project);
        this.updateAttributeMap(project);
    }

    public void init(ISettingsEditingContext editingContext) {
        this.setEditingContext(editingContext);
        this.isNew = true;
        this.setProject(V8TranslatedProjectFactory.eINSTANCE.createV8TranslatedProject());
        this.updateAttributeMap(this.getProject());
    }

    public void addPages() {
        TranslatedProjectWizardPage page = this.createTranslatedProjectWizardPage((IObservableMap<Object, Object>)this.attributesMap);
        this.addPage(page);
    }

    protected TranslatedProjectWizardPage createTranslatedProjectWizardPage(IObservableMap<Object, Object> attributesMap) {
        return new TranslatedProjectWizardPage(attributesMap);
    }

    public boolean performFinish() {
        this.updateObject((EObject)this.project);
        Set languages = (Set)this.attributesMap.get((Object)INTERFACE_LANGUAGES);
        this.project.getInterfaceLanguageNames().clear();
        languages.forEach(lang -> {
            if (lang instanceof String) {
                this.project.getInterfaceLanguageNames().add((Object)((String)lang));
            } else if (lang instanceof TranslateLanguage) {
                TranslateLanguage language = (TranslateLanguage)lang;
                this.project.getInterfaceLanguageNames().add((Object)language.getName());
            }
        });
        if (this.isNew) {
            this.getEditingContext().getTranslatedProjectSettings().add(this.project);
        } else {
            this.getEditingContext().getTranslatedProjectSettings().update(this.project);
        }
        if (this.saveContextOnFinish) {
            try {
                this.getContainer().run(true, true, monitor -> {
                    monitor.beginTask(Messages.TranslateLanguageWizard_Saving_Translate_language, -1);
                    this.getEditingContext().doSave(monitor);
                });
            }
            catch (InvocationTargetException e) {
                V8UiPlugin.logError(e);
                ExecutionErrorDialog.openError((Shell)this.getShell(), (String)"Saving the Translated Project was failed", (Throwable)e);
                return true;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
        }
        return true;
    }

    public V8TranslatedProject getProject() {
        return this.project;
    }

    public void setProject(V8TranslatedProject project) {
        this.project = project;
    }

    protected void updateAttributeMap(V8TranslatedProject object) {
        super.updateAttributeMap((EObject)object);
        this.attributesMap.put((Object)INTERFACE_LANGUAGES, (Object)Sets.newHashSet((Iterable)object.getInterfaceLanguageNames()));
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.saveContextOnFinish = true;
        this.setNeedsProgressMonitor(true);
        Object object = selection.getFirstElement();
        if (object instanceof IResource) {
            NewWizardEditingContext editingContext = NewWizardEditingContext.create(((IResource)object).getProject());
            this.init(editingContext);
        } else {
            IProject project = null;
            ISelection sel = workbench.getActiveWorkbenchWindow().getSelectionService().getSelection();
            if (sel instanceof IStructuredSelection) {
                Object first = ((IStructuredSelection)sel).getFirstElement();
                if (first instanceof EObject) {
                    project = this.resourceLookup.getProject((EObject)((IStructuredSelection)sel).getFirstElement());
                } else if (first instanceof IndexedTopObjectCollectionNavigatorAdapterBase) {
                    project = ((IndexedTopObjectCollectionNavigatorAdapterBase)first).getProject();
                } else if (first instanceof CommonNavigatorAdapter) {
                    project = (IProject)((CommonNavigatorAdapter)first).getParent(null);
                }
            }
            NewWizardEditingContext editingContext = NewWizardEditingContext.create(project);
            this.init(editingContext);
        }
    }
}

