/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.ui.projecteditor;

import com.e1c.langtool.v8.dt.internal.ui.V8UiPlugin;
import com.e1c.langtool.v8.dt.ui.projecteditor.Messages;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class V8ProjectValidator
implements IValidator<IProject> {
    private static final String[] natures = new String[]{"com._1c.g5.v8.dt.core.V8ConfigurationNature", "com._1c.g5.v8.dt.core.V8ExtensionNature", "com._1c.g5.v8.dt.core.V8ExternalObjectsNature"};

    public IStatus validate(IProject value) {
        StringBuilder results = new StringBuilder();
        if (value instanceof IProject) {
            IProject project = value;
            boolean hasNature = false;
            int i = 0;
            while (i < natures.length) {
                String natureId = natures[i];
                try {
                    if (project.hasNature(natureId)) {
                        hasNature = true;
                        break;
                    }
                }
                catch (CoreException e) {
                    V8UiPlugin.logError(e);
                }
                ++i;
            }
            if (!hasNature) {
                results.append(Messages.V8ProjectValidator_Select_valid_1C_Enterprise_Project);
            }
        } else {
            results.append(Messages.V8ProjectValidator_Select_1C_Enterprise_Porject);
        }
        if (results.length() > 0) {
            return ValidationStatus.error((String)results.toString());
        }
        return Status.OK_STATUS;
    }
}

