/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.ui.storage;

import com._1c.g5.v8.dt.ui.V8UiSharedImages;
import com._1c.g5.v8.dt.ui.editor.IProjectEditor;
import com._1c.g5.v8.dt.ui.editor.IProjectEditorSection;
import com.e1c.langtool.storage.IStorageSettingsChangeListener;
import com.e1c.langtool.storage.IStorageSettingsManager;
import com.e1c.langtool.storage.StorageID;
import com.e1c.langtool.storage.model.ProjectStorageSettings;
import com.e1c.langtool.storage.model.StorageSettings;
import com.e1c.langtool.v8.dt.ui.storage.Messages;
import com.e1c.langtool.v8.dt.ui.storage.StorageTableLableProvider;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class ProjectEditorStorageSection
implements IProjectEditorSection,
ICheckStateListener {
    @Inject
    private IStorageSettingsManager storageSettingsManager;
    private final IStorageSettingsChangeListener settingsChangeListener = (project, projectClosed) -> {
        if (this.viewer.getControl().isDisposed() || this.viewer.getControl().getDisplay().isDisposed()) {
            this.storageSettingsManager.removeChangeListener(this.settingsChangeListener);
        } else if (this.editor != null && project.equals((Object)this.editor.getProject())) {
            this.viewer.getControl().getDisplay().asyncExec(this::addStoragesToTable);
        }
    };
    private IProjectEditor editor;
    private StorageID defaultEditingStorageId;
    private CheckboxTableViewer viewer;
    private ITableLabelProvider labelProvider = new StorageTableLableProvider(() -> this.defaultEditingStorageId);
    private IAction moveUp;
    private IAction moveDown;
    private IAction setDefault;
    private Set<StorageID> storagesIds = new HashSet<StorageID>();

    public void inputChanged(IProjectEditor editor) {
        this.editor = editor;
        this.addStoragesToTable();
        this.storageSettingsManager.addChangeListener(this.settingsChangeListener);
    }

    public boolean isDirty() {
        boolean isDirty = false;
        IProject project = this.editor.getProject();
        if (project == null) {
            return isDirty;
        }
        ProjectStorageSettings projectSettings = this.storageSettingsManager.getSettingsOrDefault(project);
        if (isDirty |= this.defaultEditingStorageId != null && !this.defaultEditingStorageId.equals((Object)projectSettings.getEdit().getStorageId()) && (projectSettings.getEdit().getStorageIDs().size() != 1 || !((StorageID)projectSettings.getEdit().getStorageIDs().get(0)).equals((Object)this.defaultEditingStorageId))) {
            return isDirty;
        }
        List newOrder = this.getInput().stream().filter(e -> this.storagesIds.contains(e.getStorageId())).map(StorageSettings::getStorageId).collect(Collectors.toList());
        isDirty = !projectSettings.getReadStorageIds().equals(newOrder);
        return isDirty;
    }

    public void doSave(IProgressMonitor monitor) {
        IProject project = this.editor.getProject();
        List<StorageSettings> input = this.getInput();
        List storageSettings = input.stream().filter(e -> this.storagesIds.contains(e.getStorageId())).collect(Collectors.toList());
        if (project != null && !input.isEmpty()) {
            this.storageSettingsManager.saveReadSettings(project, storageSettings);
        }
        if (!(project == null || this.defaultEditingStorageId == null || this.storagesIds.contains(this.defaultEditingStorageId) || storageSettings.isEmpty() || this.storageSettingsManager.getSettingsOrDefault(project).getEdit().getStorageId().equals((Object)this.defaultEditingStorageId))) {
            this.defaultEditingStorageId = ((StorageSettings)storageSettings.get(0)).getStorageId();
        }
        this.storageSettingsManager.saveDefaultEditingStorageId(project, this.defaultEditingStorageId);
    }

    public void dispose() {
        this.storageSettingsManager.removeChangeListener(this.settingsChangeListener);
    }

    public void createContent(IProjectEditor projectEditor, IFormPage formPage, FormToolkit toolkit, Composite parent, Section section) {
        this.editor = projectEditor;
        GridDataFactory.fillDefaults().grab(true, false).hint(300, 250).applyTo((Control)section);
        Font font = parent.getFont();
        Composite topLevel = toolkit.createComposite(parent);
        GridLayoutFactory.swtDefaults().applyTo(topLevel);
        GridDataFactory.fillDefaults().grab(true, false).hint(-1, 150).applyTo((Control)topLevel);
        this.viewer = CheckboxTableViewer.newCheckList((Composite)topLevel, (int)68354);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.addCheckStateListener((ICheckStateListener)this);
        this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        formPage.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        Table storageTable = this.viewer.getTable();
        storageTable.setLayoutData((Object)new GridData(1808));
        storageTable.setFont(font);
        this.\u0441reateTooBar(projectEditor, section);
    }

    public IStatus validate() {
        return Status.OK_STATUS;
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        Object element = event.getElement();
        boolean checked = event.getChecked();
        if (element instanceof StorageSettings) {
            if (checked) {
                this.storagesIds.add(((StorageSettings)element).getStorageId());
            } else {
                this.storagesIds.remove(((StorageSettings)element).getStorageId());
            }
        }
        this.editor.refreshDirty();
    }

    private void \u0441reateTooBar(IProjectEditor editor, Section section) {
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        ToolBar toolbar = toolBarManager.createControl((Composite)section);
        toolbar.setCursor(Display.getDefault().getSystemCursor(21));
        this.setDefault = new SetDefaultAction((ISelectionProvider)this.viewer);
        toolBarManager.add(this.setDefault);
        this.moveUp = new MoveUpAction((ISelectionProvider)this.viewer);
        toolBarManager.add(this.moveUp);
        this.moveDown = new MoveDownAction((ISelectionProvider)this.viewer);
        toolBarManager.add(this.moveDown);
        IActionBars actionBars = ((IEditorSite)editor.getSite()).getActionBars();
        actionBars.setGlobalActionHandler("com._1c.g5.v8.dt.ui.commands.openEditor", this.setDefault);
        actionBars.setGlobalActionHandler("com._1c.g5.v8.dt.ui.commands.moveUp", this.moveUp);
        actionBars.setGlobalActionHandler("com._1c.g5.v8.dt.ui.commands.moveDown", this.moveDown);
        toolBarManager.update(true);
        section.setTextClient((Control)toolbar);
    }

    private void addStoragesToTable() {
        IProject project = this.editor.getProject();
        if (project == null) {
            return;
        }
        ProjectStorageSettings settings = this.storageSettingsManager.getSettingsOrDefault(project);
        this.storagesIds = new HashSet<StorageID>(settings.getReadStorageIds());
        ArrayList<StorageSettings> allStorages = new ArrayList<StorageSettings>(settings.getReadStorageSettings());
        for (Map.Entry entry : settings.allStorageSettings().entrySet()) {
            if (this.storagesIds.contains(entry.getKey())) continue;
            allStorages.add((StorageSettings)entry.getValue());
        }
        this.defaultEditingStorageId = settings.getEdit().getRules().isEmpty() && settings.getEdit().getStorageIDs().size() == 1 ? (StorageID)settings.getEdit().getStorageIDs().get(0) : settings.getEdit().getStorageId();
        this.viewer.setInput(allStorages);
        for (StorageSettings storageSetting : allStorages) {
            this.viewer.setChecked((Object)storageSetting, this.storagesIds.contains(storageSetting.getStorageId()));
        }
    }

    protected List<StorageSettings> getInput() {
        Table storageTable = this.viewer.getTable();
        ArrayList settings = Lists.newArrayList();
        int i = 0;
        while (i < storageTable.getItemCount()) {
            TableItem item = storageTable.getItem(i);
            StorageSettings storage = (StorageSettings)item.getData();
            settings.add(storage);
            ++i;
        }
        return settings;
    }

    private boolean isEnabled(Object element) {
        if (element instanceof StorageSettings) {
            return this.storagesIds.contains(((StorageSettings)element).getStorageId());
        }
        return false;
    }

    private void move(TableItem item, int index) {
        Object data = item.getData();
        item.dispose();
        this.viewer.insert(data, index);
        this.viewer.setChecked(data, this.isEnabled(data));
        this.editor.refreshDirty();
    }

    private void moveSelectionDown() {
        Table storageTable = this.viewer.getTable();
        int[] indices = storageTable.getSelectionIndices();
        if (indices.length < 1) {
            return;
        }
        int[] newSelection = new int[indices.length];
        int max = storageTable.getItemCount() - 1;
        int i = indices.length - 1;
        while (i >= 0) {
            int index = indices[i];
            if (index < max) {
                this.move(storageTable.getItem(index), index + 1);
                newSelection[i] = index + 1;
            }
            --i;
        }
        storageTable.setSelection(newSelection);
        this.viewer.setSelection(this.viewer.getSelection());
    }

    private void moveSelectionUp() {
        Table storageTable = this.viewer.getTable();
        int[] indices = storageTable.getSelectionIndices();
        int[] newSelection = new int[indices.length];
        int i = 0;
        while (i < indices.length) {
            int index = indices[i];
            if (index > 0) {
                this.move(storageTable.getItem(index), index - 1);
                newSelection[i] = index - 1;
            }
            ++i;
        }
        storageTable.setSelection(newSelection);
        this.viewer.setSelection(this.viewer.getSelection());
    }

    private class MoveDownAction
    extends SelectionProviderAction {
        protected MoveDownAction(ISelectionProvider provider) {
            super(provider, Messages.ProjectEditorStorageSection_Move_down);
            this.setImageDescriptor(V8UiSharedImages.getImageDescriptor((String)"/icons/obj16/move_down.png"));
            this.setActionDefinitionId("com._1c.g5.v8.dt.ui.commands.moveDown");
        }

        public void run() {
            ProjectEditorStorageSection.this.moveSelectionDown();
            ProjectEditorStorageSection.this.editor.refreshDirty();
        }

        public void selectionChanged(IStructuredSelection selection) {
            boolean enable = false;
            if (selection != null) {
                boolean bl = enable = !selection.isEmpty();
                if (enable) {
                    Table storageTable = ProjectEditorStorageSection.this.viewer.getTable();
                    int[] indices = storageTable.getSelectionIndices();
                    int max = storageTable.getItemCount();
                    if (indices.length > 0) {
                        enable = indices[indices.length - 1] < max - 1;
                    }
                }
            }
            this.setEnabled(enable);
        }
    }

    private class MoveUpAction
    extends SelectionProviderAction {
        protected MoveUpAction(ISelectionProvider provider) {
            super(provider, Messages.ProjectEditorStorageSection_Move_up);
            this.setImageDescriptor(V8UiSharedImages.getImageDescriptor((String)"/icons/obj16/move_up.png"));
            this.setActionDefinitionId("com._1c.g5.v8.dt.ui.commands.moveUp");
        }

        public void run() {
            ProjectEditorStorageSection.this.moveSelectionUp();
            ProjectEditorStorageSection.this.editor.refreshDirty();
        }

        public void selectionChanged(IStructuredSelection selection) {
            boolean enable = false;
            if (selection != null) {
                Table storageTable;
                int[] indices;
                boolean bl = enable = !selection.isEmpty();
                if (enable && (indices = (storageTable = ProjectEditorStorageSection.this.viewer.getTable()).getSelectionIndices()).length > 0) {
                    enable = indices[0] != 0;
                }
            }
            this.setEnabled(enable);
        }
    }

    private class SetDefaultAction
    extends SelectionProviderAction {
        protected SetDefaultAction(ISelectionProvider provider) {
            super(provider, Messages.ProjectEditorStorageSection_Set_default_editable_storage);
            this.setImageDescriptor(V8UiSharedImages.getImageDescriptor((String)"/icons/obj16/edit_element.png"));
            this.setActionDefinitionId("com._1c.g5.v8.dt.ui.commands.openEditor");
        }

        public void run() {
            if (!ProjectEditorStorageSection.this.viewer.getStructuredSelection().isEmpty() && ProjectEditorStorageSection.this.viewer.getStructuredSelection().getFirstElement() instanceof StorageSettings) {
                StorageSettings settings = (StorageSettings)ProjectEditorStorageSection.this.viewer.getStructuredSelection().getFirstElement();
                ProjectEditorStorageSection.this.defaultEditingStorageId = settings.getStorageId();
                ProjectEditorStorageSection.this.storagesIds.add(ProjectEditorStorageSection.this.defaultEditingStorageId);
                ProjectEditorStorageSection.this.viewer.setChecked((Object)settings, true);
                ProjectEditorStorageSection.this.viewer.refresh();
                ProjectEditorStorageSection.this.editor.refreshDirty();
                this.setEnabled(false);
            }
        }

        public void selectionChanged(IStructuredSelection selection) {
            boolean enable = false;
            if (selection != null) {
                boolean bl = enable = !selection.isEmpty();
                if (enable && ProjectEditorStorageSection.this.defaultEditingStorageId != null) {
                    for (StorageSettings settings : selection) {
                        if (!settings.isReadOnly() && !settings.getStorageId().equals((Object)ProjectEditorStorageSection.this.defaultEditingStorageId)) continue;
                        enable = false;
                    }
                }
            }
            this.setEnabled(enable);
        }
    }
}

