/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.right.ql;

import com._1c.g5.v8.dt.bm.xtext.IDependentModelProvider;
import com._1c.g5.v8.dt.right.ql.model.PreprocessorConditional;
import com._1c.g5.v8.dt.right.ql.model.PreprocessorRestriction;
import com._1c.g5.v8.dt.right.ql.model.Restriction;
import com._1c.g5.v8.dt.rights.model.RoleDescription;
import com.e1c.langtool.v8.dt.internal.right.ql.RightQlPlugin;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.service.OperationCanceledError;
import org.eclipse.xtext.util.CancelIndicator;

public final class RightQlUtil {
    public static final String QLRIGHTS_FILE_EXT = "qlrights";

    public static Restriction getRestriction(IDependentModelProvider dependentModelProvider, EObject source, EStructuralFeature feature, IPath basePath, CancelIndicator monitor) {
        Restriction restriction = (Restriction)dependentModelProvider.getDependentModel(source, feature, basePath, monitor);
        RightQlUtil.setOwner(restriction, source);
        if (monitor == null) {
            monitor = CancelIndicator.NullImpl;
        }
        try {
            EcoreUtil2.resolveLazyCrossReferences((Resource)restriction.eResource(), (CancelIndicator)monitor);
        }
        catch (OperationCanceledError e) {
            return null;
        }
        catch (Throwable e) {
            URI uri = restriction.eResource().getURI();
            ICompositeNode root = NodeModelUtils.getNode((EObject)restriction).getRootNode();
            String text = root.getText();
            String message = MessageFormat.format("Cannot create Restriction for object URI: \"{0}\" with text:\n\n{1}", uri, text);
            RightQlPlugin.log(RightQlPlugin.createErrorStatus(message, e));
            return null;
        }
        return restriction;
    }

    private static void setOwner(Restriction restriction, EObject source) {
        RoleDescription roleDescription = (RoleDescription)EcoreUtil2.getContainerOfType((EObject)source, RoleDescription.class);
        if (roleDescription == null) {
            return;
        }
        restriction.setOwner(roleDescription);
        if (restriction instanceof PreprocessorRestriction) {
            PreprocessorRestriction preprocessorRestriction = (PreprocessorRestriction)restriction;
            if (preprocessorRestriction.getIfPart() != null && preprocessorRestriction.getIfPart().getRestriction() != null) {
                preprocessorRestriction.getIfPart().getRestriction().setOwner(roleDescription);
            }
            for (PreprocessorConditional elsIf : preprocessorRestriction.getElsIfParts()) {
                if (elsIf.getRestriction() == null) continue;
                elsIf.getRestriction().setOwner(roleDescription);
            }
            if (preprocessorRestriction.getElseRestriction() != null) {
                preprocessorRestriction.getElseRestriction().setOwner(roleDescription);
            }
        }
    }

    private RightQlUtil() {
        throw new IllegalAccessError("Utility class");
    }
}

