/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.sync;

import com._1c.g5.v8.bm.core.IBmObject;
import com._1c.g5.v8.bm.core.IBmTransaction;
import com._1c.g5.v8.bm.integration.IBmModel;
import com._1c.g5.v8.dt.bm.index.emf.IBmEmfIndexManager;
import com._1c.g5.v8.dt.bm.index.emf.IBmEmfIndexProvider;
import com._1c.g5.v8.dt.bm.xtext.BmAwareResourceSetProvider;
import com._1c.g5.v8.dt.common.StringUtils;
import com._1c.g5.v8.dt.core.filesystem.IQualifiedNameFilePathConverter;
import com._1c.g5.v8.dt.core.platform.IBmModelManager;
import com._1c.g5.v8.dt.md.IExternalPropertyManagerRegistry;
import com._1c.g5.v8.dt.metadata.IExternalPropertyManager;
import com.e1c.langtool.v8.dt.internal.sync.SyncPlugin;
import com.e1c.langtool.v8.dt.sync.EmfObjectProvider;
import com.google.inject.Inject;
import com.google.inject.Provider;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceServiceProvider;

public class EmfObjectProviderImpl
implements EmfObjectProvider {
    @Inject
    protected IBmModelManager modelManager;
    @Inject
    protected IQualifiedNameFilePathConverter qualifiedNameFilePathConverter;
    @Inject
    protected IQualifiedNameConverter qualifiedNameConverter;
    @Inject
    protected IExternalPropertyManagerRegistry externalPropertyManagerRegistry;
    @Inject
    protected IBmEmfIndexManager bmEmfIndexManager;
    @Inject
    private Provider<ResourceSetImpl> resourceSetProvider;

    @Override
    public EObject getObjectByFile(IFile emfResource) {
        if (!emfResource.isAccessible()) {
            return null;
        }
        IProject project = emfResource.getProject();
        IBmModel model = this.modelManager.getModel(project);
        if (model == null) {
            return null;
        }
        QualifiedName fqn = this.qualifiedNameFilePathConverter.getFqn(emfResource);
        if (fqn == null || fqn.isEmpty()) {
            if (SyncPlugin.getDefault().isDebugging()) {
                System.out.println("FQN is empty. Cannot provide EMF Object from file: " + emfResource.getFullPath().toString());
            }
            return null;
        }
        IBmObject topObject = null;
        IBmObject owner = null;
        IBmTransaction transaction = model.getEngine().getCurrentTransaction();
        boolean isNewTransaction = false;
        if (transaction == null) {
            transaction = model.getEngine().beginReadOnlyTransaction(true);
            isNewTransaction = true;
        }
        try {
            IBmObject object = transaction.getTopObjectByFqn(fqn.toString());
            if (object != null) {
                topObject = object;
            }
            if (topObject == null) {
                owner = transaction.getTopObjectByFqn(fqn.skipLast(1).toString());
            }
        }
        finally {
            if (isNewTransaction) {
                try {
                    transaction.commit();
                }
                catch (Throwable e) {
                    SyncPlugin.logError(e);
                }
            }
        }
        if (topObject != null) {
            return topObject;
        }
        if (owner != null) {
            topObject = this.getObjectByFeatureName((EObject)owner, fqn.getLastSegment());
        }
        if (topObject != null) {
            return topObject;
        }
        URI uri = URI.createPlatformResourceURI((String)emfResource.getFullPath().toString(), (boolean)true);
        ResourceSet resourceSet = this.getResourceSet(emfResource);
        Resource resource = resourceSet.getResource(uri, true);
        if (resource != null && !resource.getContents().isEmpty()) {
            topObject = (EObject)resource.getContents().get(0);
        }
        return topObject;
    }

    @Override
    public EObject getOwnerByFile(IFile emfResource) {
        if (!emfResource.isAccessible()) {
            return null;
        }
        IProject project = emfResource.getProject();
        IBmModel model = this.modelManager.getModel(project);
        if (model == null) {
            return null;
        }
        QualifiedName fqn = this.qualifiedNameFilePathConverter.getFqn(emfResource);
        if (fqn == null || fqn.isEmpty()) {
            if (SyncPlugin.getDefault().isDebugging()) {
                System.out.println("FQN is empty. Cannot provide EMF Object from file: " + emfResource.getFullPath().toString());
            }
            return null;
        }
        IBmTransaction transaction = model.getEngine().getCurrentTransaction();
        boolean isNewTransaction = false;
        if (transaction == null) {
            transaction = model.getEngine().beginReadOnlyTransaction(true);
            isNewTransaction = true;
        }
        try {
            IBmEmfIndexProvider provider;
            Iterable objects;
            IBmObject owner = transaction.getTopObjectByFqn(fqn.skipLast(1).toString());
            if (owner == null && (objects = (provider = this.bmEmfIndexManager.getEmfIndexProvider(model)).getEObjectIndexByType(EcorePackage.Literals.EOBJECT, fqn.skipLast(1), true)).iterator().hasNext()) {
                owner = ((IEObjectDescription)objects.iterator().next()).getEObjectOrProxy();
            }
            if (owner == null) {
                owner = this.getOwnerByExternalProperty(emfResource, model);
            }
            IBmObject iBmObject = owner;
            return iBmObject;
        }
        finally {
            if (isNewTransaction) {
                transaction.commit();
            }
        }
    }

    private EObject getObjectByFeatureName(EObject owner, String featureName) {
        EStructuralFeature feature = owner.eClass().getEStructuralFeature(StringUtils.uncapitalize((String)featureName));
        if (feature != null) {
            return (EObject)owner.eGet(feature);
        }
        return null;
    }

    protected ResourceSet getResourceSet(IFile modelFile) {
        String extension = modelFile.getFileExtension();
        IResourceServiceProvider rsp = IResourceServiceProvider.Registry.INSTANCE.getResourceServiceProvider(URI.createURI((String)("*." + extension)));
        if (rsp == null) {
            return (ResourceSet)this.resourceSetProvider.get();
        }
        BmAwareResourceSetProvider bmResourceSetProvider = (BmAwareResourceSetProvider)rsp.get(BmAwareResourceSetProvider.class);
        return bmResourceSetProvider.get(modelFile.getProject());
    }

    protected EObject getOwnerByExternalProperty(IFile sourceFile, IBmModel model) {
        ResourceSet resourceSet;
        URI uri = URI.createPlatformResourceURI((String)sourceFile.getFullPath().toString(), (boolean)true);
        EObject object = null;
        Resource resource = model.getEngine().getExternalResource(uri);
        if (resource != null && !resource.getContents().isEmpty()) {
            object = (EObject)resource.getContents().get(0);
        } else if (resource == null) {
            object = model.getEngine().resolve(uri.appendFragment("/"), null);
        }
        if (resource == null && object == null && (resource = (resourceSet = this.getResourceSet(sourceFile)).getResource(uri, true)) != null && !resource.getContents().isEmpty()) {
            object = (EObject)resource.getContents().get(0);
        }
        if (object != null) {
            IExternalPropertyManager manager = this.externalPropertyManagerRegistry.getExternalPropertyManager(model);
            return manager.getOwner(object, EObject.class);
        }
        return null;
    }
}

