/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.sync;

import com._1c.g5.v8.bm.core.BmUriUtil;
import com._1c.g5.v8.bm.core.IBmObject;
import com._1c.g5.v8.dt.mcore.StandardCommandGroup;
import com._1c.g5.v8.dt.mcore.TypeItem;
import com._1c.g5.v8.dt.platform.model.PlatformBorder;
import com._1c.g5.v8.dt.platform.model.PlatformColor;
import com._1c.g5.v8.dt.platform.model.PlatformFont;
import com._1c.g5.v8.dt.platform.model.PlatformFontRef;
import com._1c.g5.v8.dt.platform.model.PlatformPicture;
import com._1c.g5.v8.dt.platform.model.SystemColor;
import com._1c.g5.v8.dt.platform.model.SystemFont;
import com._1c.g5.v8.dt.rights.model.Right;
import com.e1c.langtool.v8.dt.internal.sync.SyncPlugin;
import com.e1c.langtool.v8.dt.sync.ITranslatedSymbolicNameService;
import com.e1c.langtool.v8.dt.sync.ITranslatedSymbolicNameServiceDelegate;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EcoreUtil;

public final class SymbolicNameService
implements ITranslatedSymbolicNameService {
    private static final String EXTENSION_POINT_ID = "com.e1c.langtool.v8.dt.sync.TranslatedSymbolicNameServiceDelegates";
    private static final String PLATFORM_BUNDLE = "com._1c.g5.v8.dt.platform";
    private List<ITranslatedSymbolicNameServiceDelegate> delegates = null;
    private Object delegatesLock = new Object();

    @Override
    public String generateSymbolicName(EObject targetObject, EObject contextObject, EReference contextFeature, IProjectTranslationProvider translationProvider) {
        String name;
        if ((targetObject = EcoreUtil.resolve((EObject)targetObject, (EObject)contextObject)).eIsProxy()) {
            return this.convertUriToSymbolicName(EcoreUtil.getURI((EObject)targetObject), contextObject, contextFeature);
        }
        List<ITranslatedSymbolicNameServiceDelegate> delegates = this.getDelegates();
        for (ITranslatedSymbolicNameServiceDelegate delegate : delegates) {
            name = delegate.generateContextSpecificSymbolicName(targetObject, contextObject, contextFeature, translationProvider);
            if (name == null) continue;
            return name;
        }
        if (this.isNonBmObject(targetObject)) {
            return this.generateNonBmObjectSymbolicName(targetObject);
        }
        for (ITranslatedSymbolicNameServiceDelegate delegate : delegates) {
            name = delegate.generateCommonSymbolicName(targetObject, contextObject, translationProvider);
            if (name == null) continue;
            return name;
        }
        return null;
    }

    public String convertUriToCommonSymbolicName(URI targetUri) {
        if ("unresolved".equals(targetUri.scheme())) {
            return targetUri.path().substring(1);
        }
        if (!BmUriUtil.isBmUri((URI)targetUri)) {
            String fragment;
            if (this.isV8Uri(targetUri) && (fragment = targetUri.fragment()).length() > 1) {
                return fragment.substring(1);
            }
            if (this.isPlatformUri(targetUri)) {
                return this.convertPlatformUriToSymbolicName(targetUri);
            }
        }
        for (ITranslatedSymbolicNameServiceDelegate delegate : this.getDelegates()) {
            String name = delegate.convertUriToCommonSymbolicName(targetUri);
            if (name == null) continue;
            return name;
        }
        return null;
    }

    private String convertUriToSymbolicName(URI targetUri, EObject contextObject, EReference contextFeature) {
        String name;
        if ("unresolved".equals(targetUri.scheme())) {
            return targetUri.path().substring(1);
        }
        List<ITranslatedSymbolicNameServiceDelegate> delegates = this.getDelegates();
        for (ITranslatedSymbolicNameServiceDelegate delegate : delegates) {
            name = delegate.convertUriToContextSpecificSymbolicName(targetUri, contextObject, contextFeature);
            if (name == null) continue;
            return name;
        }
        if (!BmUriUtil.isBmUri((URI)targetUri)) {
            if (this.isV8Uri(targetUri)) {
                return this.convertV8UriToSymbolicName(targetUri);
            }
            if (this.isPlatformUri(targetUri)) {
                return this.convertPlatformUriToSymbolicName(targetUri);
            }
        }
        for (ITranslatedSymbolicNameServiceDelegate delegate : delegates) {
            name = delegate.convertUriToCommonSymbolicName(targetUri);
            if (name == null) continue;
            return name;
        }
        return null;
    }

    private boolean isNonBmObject(EObject targetObject) {
        return !(targetObject instanceof IBmObject) || ((IBmObject)targetObject).bmGetId() == -1L;
    }

    private String generateNonBmObjectSymbolicName(EObject targetObject) {
        if (targetObject instanceof PlatformBorder) {
            return ((PlatformBorder)targetObject).getName();
        }
        if (targetObject instanceof PlatformColor) {
            return ((PlatformColor)targetObject).getName();
        }
        if (targetObject instanceof PlatformFont) {
            return ((PlatformFont)targetObject).getName();
        }
        if (targetObject instanceof PlatformFontRef) {
            return ((PlatformFontRef)targetObject).getName();
        }
        if (targetObject instanceof SystemColor) {
            return ((SystemColor)targetObject).getName();
        }
        if (targetObject instanceof SystemFont) {
            return ((SystemFont)targetObject).getName();
        }
        if (targetObject instanceof StandardCommandGroup) {
            return ((StandardCommandGroup)targetObject).getName();
        }
        if (targetObject instanceof PlatformPicture) {
            return "StdPicture." + ((PlatformPicture)targetObject).getName();
        }
        if (targetObject instanceof TypeItem) {
            return ((TypeItem)targetObject).getName();
        }
        if (targetObject instanceof Right) {
            return ((Right)targetObject).getName();
        }
        return null;
    }

    private boolean isV8Uri(URI targetUri) {
        return "v8".equals(targetUri.scheme());
    }

    private String convertV8UriToSymbolicName(URI targetUri) {
        String fragment = targetUri.fragment();
        if (fragment.length() > 1) {
            return fragment.substring(1);
        }
        return null;
    }

    private boolean isPlatformUri(URI targetUri) {
        return targetUri.isPlatformPlugin() && targetUri.path().contains(PLATFORM_BUNDLE);
    }

    private String convertPlatformUriToSymbolicName(URI targetUri) {
        if ("type".equals(targetUri.fileExtension()) && this.isRootPlatformObjectUri(targetUri)) {
            return targetUri.trimFileExtension().lastSegment();
        }
        return null;
    }

    private boolean isRootPlatformObjectUri(URI targetUri) {
        String fragment = targetUri.fragment();
        return fragment != null && (fragment.equals("/") || fragment.equals("/0"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ITranslatedSymbolicNameServiceDelegate> getDelegates() {
        Object object = this.delegatesLock;
        synchronized (object) {
            if (this.delegates == null) {
                IConfigurationElement[] configurationElements;
                this.delegates = new ArrayList<ITranslatedSymbolicNameServiceDelegate>();
                IConfigurationElement[] array = configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
                int length = configurationElements.length;
                int i = 0;
                while (i < length) {
                    IConfigurationElement e = array[i];
                    try {
                        ITranslatedSymbolicNameServiceDelegate provider = (ITranslatedSymbolicNameServiceDelegate)e.createExecutableExtension("class");
                        this.delegates.add(provider);
                    }
                    catch (CoreException ex) {
                        SyncPlugin.log(SyncPlugin.createErrorStatus("Unable to create delegate.", ex));
                    }
                    ++i;
                }
            }
            return this.delegates;
        }
    }
}

