/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.sync;

import com._1c.g5.v8.bm.core.BmObject;
import com._1c.g5.v8.bm.core.IBmNamespace;
import com._1c.g5.v8.bm.core.IBmObject;
import com._1c.g5.v8.bm.core.IBmPlatformTransaction;
import com._1c.g5.v8.bm.integration.IBmPlatformTask;
import com._1c.g5.v8.dt.core.filesystem.IProjectFileSystemSupport;
import com._1c.g5.v8.dt.core.filesystem.IProjectFileSystemSupportProvider;
import com._1c.g5.v8.dt.core.filesystem.IQualifiedNameFilePathConverter;
import com._1c.g5.v8.dt.core.platform.IBmModelManager;
import com._1c.g5.v8.dt.platform.version.IRuntimeVersionSupport;
import com._1c.g5.v8.dt.platform.version.Version;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.converter.IConverterManager;
import com.e1c.langtool.converter.IConverterService;
import com.e1c.langtool.emf.naming.ITranslationFeatureKeyProvider;
import com.e1c.langtool.emf.settings.EFeatureSettings;
import com.e1c.langtool.emf.settings.IFeatureSettingsService;
import com.e1c.langtool.platform.ITranslatedProject;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.settings.FeatureSettings;
import com.e1c.langtool.sync.ResourceSynchronizer;
import com.e1c.langtool.sync.SyncSession;
import com.e1c.langtool.v8.dt.TranslationPreferences;
import com.e1c.langtool.v8.dt.internal.sync.SyncPlugin;
import com.e1c.langtool.v8.dt.sync.BmObjectCopier;
import com.e1c.langtool.v8.dt.sync.BmSyncSession;
import com.e1c.langtool.v8.dt.sync.EmfObjectProvider;
import com.e1c.langtool.v8.dt.sync.naming.TranslatedTopObjectFqnGenerator;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public abstract class AbstractBmObjectSynchronizer
implements ResourceSynchronizer {
    @Inject
    protected IBmModelManager modelManager;
    @Inject
    protected IQualifiedNameFilePathConverter qualifiedNameFilePathConverter;
    @Inject
    protected IRuntimeVersionSupport runtimeVersionSupport;
    @Inject
    private IProjectFileSystemSupportProvider projectFileSystemSupportProvider;
    @Inject
    private transient ITranslationFeatureKeyProvider featureKeyProvider;
    @Inject
    protected EmfObjectProvider emfObjectProvider;
    @Inject
    protected TranslatedTopObjectFqnGenerator fqnGenerator;
    @Inject
    private IConverterService converterService;
    @Inject
    private TranslationPreferences preferences;
    @Inject
    protected IFeatureSettingsService featureSettingsService;

    public Collection<IResource> synchronize(IFile sourceFile, ITranslatingProject sourceProject, ITranslatedProject target, SyncSession syncSession, IProgressMonitor monitor) {
        LinkedHashSet result = Sets.newLinkedHashSet();
        if (!sourceFile.isAccessible() || !(syncSession instanceof BmSyncSession) || monitor.isCanceled()) {
            return result;
        }
        EObject topObject = this.emfObjectProvider.getObjectByFile(sourceFile);
        if (topObject == null) {
            if (SyncPlugin.getDefault().isDebugging()) {
                System.out.println("EMF Object not found. Cannot synchronize file: " + sourceFile.getFullPath().toString());
            }
            return result;
        }
        BmSyncSession bmSyncSesstion = (BmSyncSession)syncSession;
        if (topObject instanceof IBmObject) {
            Object session = bmSyncSesstion.getBatchSessionLock();
            IProjectTranslationProvider translationProvider = bmSyncSesstion.getTranslationProvider();
            IProject project = sourceProject.getProject();
            IFile file = this.synchronize((IBmObject)topObject, target.getProject(), project, sourceFile, session, translationProvider, monitor);
            if (file != null) {
                IConverterManager manager;
                TranslateLanguage language;
                result.add(file);
                if (this.preferences.getTranslationProperties(project).isEnablePersistentKeyMappingCache() && (language = (manager = this.converterService.getManager(project)).getLanguage()).getLanguageCode().equals(target.getDefaultLanguage().getLanguageCode())) {
                    manager.updateConvertedKey(sourceFile.getProjectRelativePath(), file.getProjectRelativePath());
                }
            }
        }
        return result;
    }

    public Collection<IFile> remove(IFile sourceFile, ITranslatingProject sourceProject, ITranslatedProject target, SyncSession session, IProgressMonitor monitor) {
        return Collections.emptyList();
    }

    protected IFile synchronize(IBmObject source, IProject targetProject, IProject sourceProject, IFile sourceFile, Object session, IProjectTranslationProvider translationProvider, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return null;
        }
        if (session == null) {
            return (IFile)this.modelManager.getGlobalEditingContext().execute("Copy translation", null, null, (IBmPlatformTask)new WriteCopyBmTask(source, translationProvider, targetProject, sourceProject, sourceFile));
        }
        return (IFile)this.modelManager.executeInBatchSession(session, (IBmPlatformTask)new WriteCopyBmTask(source, translationProvider, targetProject, sourceProject, sourceFile));
    }

    protected BmObjectCopier createNewCopier(IProject project, IBmPlatformTransaction transaction, IBmObject source, IProjectTranslationProvider translationProvider, IProject targetProject, Version runtimeVersion) {
        IBmNamespace bmTargetNamespace = this.modelManager.getBmNamespace(targetProject);
        BmObjectCopier copier = new BmObjectCopier(project, transaction, (EObject)source, translationProvider, bmTargetNamespace, runtimeVersion);
        SyncPlugin.getDefault().getInjector().injectMembers((Object)copier);
        return copier;
    }

    protected IBmObject copyBmObject(IBmObject source, IProject targetProject, IBmPlatformTransaction transaction, IProjectTranslationProvider translationProvider) {
        IProject project = translationProvider.getProject().getProject();
        Version runtimeVersion = this.runtimeVersionSupport.getRuntimeVersion(project);
        BmObjectCopier copier = this.createNewCopier(project, transaction, source, translationProvider, targetProject, runtimeVersion);
        IBmObject result = (IBmObject)copier.copy((EObject)source);
        copier.copyReferences();
        IProject sourceProject = translationProvider.getProject().getSourceProject().getProject();
        if (this.preferences.getTranslationProperties(sourceProject).isEnablePersistentKeyMappingCache()) {
            this.traverseEObject((EObject)source, (EObject)result, translationProvider);
        }
        if (result.bmIsTop() && result.bmGetFqn() != null && !result.bmGetFqn().equals(copier.getTranslatedTopObjectFqn())) {
            transaction.updateTopObjectFqn(result, copier.getTranslatedTopObjectFqn());
        }
        return result;
    }

    private void traverseEObject(EObject source, EObject result, IProjectTranslationProvider translationProvider) {
        EList containments = result.eClass().getEAllContainments();
        for (EReference containment : containments) {
            if (!(containment instanceof EReference)) continue;
            EReference reference = containment;
            this.handleEReference(source, result, reference, translationProvider);
        }
    }

    private void handleEReference(EObject source, EObject result, EReference reference, IProjectTranslationProvider translationProvider) {
        EFeatureSettings featureSettings;
        if (this.featureSettingsService.isInterfaceFeature((EStructuralFeature)reference, result) && (featureSettings = this.featureSettingsService.getSettings((EStructuralFeature)reference, result)) != null && featureSettings.isInterface()) {
            this.updateKeyMappingCache(source, result, featureSettings, translationProvider);
        }
        Object valueSource = source.eGet((EStructuralFeature)reference);
        Object valueResult = result.eGet((EStructuralFeature)reference);
        if (valueSource instanceof EObject && valueResult instanceof EObject) {
            this.traverseEObject((EObject)valueSource, (EObject)valueResult, translationProvider);
        } else if (valueSource instanceof List && valueResult instanceof List) {
            List listSource = (List)valueSource;
            List listResult = (List)valueResult;
            int size = listSource.size();
            if (size == listResult.size()) {
                int i = 0;
                while (i < size) {
                    Object itemSource = listSource.get(i);
                    Object itemResult = listResult.get(i);
                    if (itemSource instanceof EObject && itemResult instanceof EObject) {
                        this.traverseEObject((EObject)itemSource, (EObject)itemResult, translationProvider);
                    }
                    ++i;
                }
            }
        }
    }

    private void updateKeyMappingCache(EObject sourceEObject, EObject resultEObject, EFeatureSettings featureSettings, IProjectTranslationProvider translationProvider) {
        BmObject bmTopObject;
        String fqn;
        IPath path;
        IProject project = translationProvider.getProject().getSourceProject().getProject();
        IConverterManager manager = this.converterService.getManager(project);
        TranslateLanguage defaultLanguage = translationProvider.getProject().getDefaultLanguage();
        if (manager.getLanguage().getLanguageCode().equals(defaultLanguage.getLanguageCode()) && sourceEObject instanceof BmObject && resultEObject instanceof BmObject && (path = this.qualifiedNameFilePathConverter.getFilePath(fqn = (bmTopObject = ((BmObject)sourceEObject).bmGetTopObject()).bmGetFqn(), bmTopObject.eClass())) != null) {
            FeatureKey sourceFeatureKey = this.featureKeyProvider.getFeatureKey(sourceEObject, (FeatureSettings)featureSettings);
            FeatureKey targetFeatureKey = this.featureKeyProvider.getFeatureKey(resultEObject, (FeatureSettings)featureSettings);
            String[] parts = fqn.split("\\.");
            if (parts.length > 1 && targetFeatureKey.getFirstSegment().startsWith(parts[0])) {
                targetFeatureKey = sourceFeatureKey.skipLast(sourceFeatureKey.getSegmentCount() - 1).append(targetFeatureKey.skipFirst(1));
            }
            manager.updateConvertedValues(path, sourceFeatureKey, targetFeatureKey);
        }
    }

    private final class WriteCopyBmTask
    implements IBmPlatformTask<IFile> {
        private final IBmObject source;
        private final IProjectTranslationProvider translationProvider;
        private final IProject targetProject;
        private final IProject sourceProject;
        private final IFile sourceFile;

        public WriteCopyBmTask(IBmObject source, IProjectTranslationProvider translationProvider, IProject targetProject, IProject sourceProject, IFile sourceFile) {
            this.source = source;
            this.translationProvider = translationProvider;
            this.targetProject = targetProject;
            this.sourceProject = sourceProject;
            this.sourceFile = sourceFile;
        }

        public IFile execute(IBmPlatformTransaction transaction) {
            IBmObject bmObject = AbstractBmObjectSynchronizer.this.copyBmObject((IBmObject)transaction.toTransactionObject((EObject)this.source), this.targetProject, transaction, this.translationProvider);
            IFile file = null;
            if (bmObject.bmIsTop() && bmObject.bmGetFqn() != null) {
                Path path = new Path(AbstractBmObjectSynchronizer.this.qualifiedNameFilePathConverter.getFilePath(bmObject.bmGetFqn()));
                String fileExtension = this.sourceFile.getFileExtension();
                if (fileExtension != null && !fileExtension.equals(path.getFileExtension())) {
                    path = path.removeFileExtension().addFileExtension(this.sourceFile.getFileExtension());
                }
                file = this.targetProject.getFile((IPath)path);
            } else {
                try {
                    IProjectFileSystemSupport fss = AbstractBmObjectSynchronizer.this.projectFileSystemSupportProvider.getProjectFileSystemSupport(this.targetProject);
                    file = fss.getFile((EObject)bmObject);
                }
                catch (Exception e) {
                    String message = MessageFormat.format("Cannot define file path for synchronized object: {0}. class: {1}, source file: {2}", bmObject, bmObject.getClass(), this.sourceFile.getFullPath());
                    throw new RuntimeException(message, e);
                }
            }
            return file;
        }
    }
}

