/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.sync;

import com._1c.g5.v8.bm.integration.IBatchSessionController;
import com._1c.g5.v8.bm.integration.IBmModel;
import com._1c.g5.v8.derived.IDerivedDataManager;
import com._1c.g5.v8.dt.common.FileUtil;
import com._1c.g5.v8.dt.core.operations.ProjectPipelineJob;
import com._1c.g5.v8.dt.core.platform.IBmModelManager;
import com._1c.g5.v8.dt.core.platform.IDerivedDataManagerProvider;
import com._1c.g5.v8.dt.core.platform.IDtProject;
import com._1c.g5.v8.dt.core.platform.IDtProjectManager;
import com._1c.g5.v8.dt.core.platform.IWorkspaceOrchestrator;
import com.e1c.langtool.platform.ITranslatedProject;
import com.e1c.langtool.sync.SyncCache;
import com.e1c.langtool.sync.SyncCacheProvider;
import com.e1c.langtool.v8.dt.internal.sync.SyncPlugin;
import com.e1c.langtool.v8.dt.sync.BmSyncSession;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.time.Duration;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public abstract class AbstractBmSyncSession
implements BmSyncSession {
    private static final String SYNC_PREFFIX = "sync_";
    private static final String MESSAGE_WAS_NOT_START_PROPERLY = "BmSyncSession was not start properly.";
    @Inject
    private IBmModelManager modelManager;
    @Inject
    private IDerivedDataManagerProvider derivedDataManagerProvider;
    @Inject
    private SyncCacheProvider cacheProvider;
    @Inject
    protected IDtProjectManager dtProjectManager;
    @Inject
    protected IWorkspaceOrchestrator workspaceOrchestrator;
    protected final ITranslatedProject translatedProject;
    protected IBmModel target;
    protected volatile Object session;
    private final Set<IPath> skipped = Sets.newConcurrentHashSet();
    private final Map<IFile, File> delayedFiles = Maps.newConcurrentMap();
    private volatile File tempFolder;
    private final Object waitLock = new Object();
    private volatile Object sourceHandle;
    private volatile Object targetHandle;

    public AbstractBmSyncSession(ITranslatedProject translatedProject) {
        this.translatedProject = translatedProject;
    }

    public void beginSyncOperation() {
        this.beginSourceProjectOperation();
        this.beginMainTargetProjectOperation();
    }

    public void endSyncOperation() {
        this.endSourceProjectOperation();
        this.endTargetProjectOperation();
    }

    public IStatus beforeSynchronizing(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        try {
            this.tempFolder = FileUtil.createTempDirectory((String)SYNC_PREFFIX);
        }
        catch (IOException e) {
            return SyncPlugin.createErrorStatus("Cannot create temp directory for synchronizing", e);
        }
        this.target = this.modelManager.getModel(this.translatedProject.getProject());
        BatchSessionController controller = new BatchSessionController();
        this.session = this.target.beginBatchSession((Object)controller);
        return Status.OK_STATUS;
    }

    public IStatus afterSynchronized(IProgressMonitor monitor) {
        Assert.isNotNull((Object)this.target, (String)MESSAGE_WAS_NOT_START_PROPERLY);
        Assert.isNotNull((Object)this.session, (String)MESSAGE_WAS_NOT_START_PROPERLY);
        this.getTranslationProvider().dispose();
        try {
            ResourcesPlugin.getWorkspace().run(m -> this.createAllParentFolders(m), null, 1, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor));
        }
        catch (CoreException e1) {
            SyncPlugin.logError(e1);
        }
        this.endTargetProjectOperation();
        this.target.endBatchSession(this.session);
        this.endMainTargetProjectOperation();
        try {
            try {
                this.copyAllDelayedFilesToProject(monitor);
                FileUtil.deleteRecursively((File)this.tempFolder);
            }
            catch (IOException | CoreException e) {
                IStatus iStatus = SyncPlugin.createErrorStatus("Cannot synchronize all files", e);
                this.beginWaitOnTargetProjectOperation();
                return iStatus;
            }
        }
        finally {
            this.beginWaitOnTargetProjectOperation();
        }
        return Status.OK_STATUS;
    }

    @Override
    public Object getBatchSessionLock() {
        Assert.isNotNull((Object)this.session, (String)MESSAGE_WAS_NOT_START_PROPERLY);
        return this.session;
    }

    public Collection<IPath> getSkipped() {
        return this.skipped;
    }

    @Override
    public void storeDelayedFiles(IFile file, InputStream stream) throws IOException {
        Assert.isNotNull((Object)this.tempFolder, (String)"BmSyncSession was not start properly");
        Path path = Paths.get(this.tempFolder.getAbsolutePath(), file.getProjectRelativePath().toPortableString());
        File tempFile = path.toFile();
        File parent = tempFile.getParentFile();
        if (parent == null) {
            throw new RuntimeException("Cannot store file content to folder");
        }
        parent.mkdirs();
        Files.copy(stream, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        this.delayedFiles.put(file, tempFile);
    }

    private void beginSourceProjectOperation() {
        IProject sourceProject = this.translatedProject.getSourceProject().getProject();
        this.waitUntilStarted(sourceProject, Duration.ofMinutes(5L));
        IDtProject sourceDtProject = this.dtProjectManager.getDtProject(sourceProject);
        this.sourceHandle = this.workspaceOrchestrator.beginExclusiveOperation("synchronize-source-Project", (Collection)Lists.newArrayList((Object[])new IDtProject[]{sourceDtProject}), ProjectPipelineJob.BUILD);
    }

    private void endSourceProjectOperation() {
        Assert.isNotNull((Object)this.sourceHandle);
        try {
            this.workspaceOrchestrator.endOperation(this.sourceHandle);
        }
        catch (Exception e) {
            SyncPlugin.logError(e);
        }
    }

    private void beginMainTargetProjectOperation() {
        IProject targetProject = this.translatedProject.getProject();
        this.waitUntilStarted(targetProject, Duration.ofMinutes(5L));
        IDtProject targetDtProject = this.dtProjectManager.getDtProject(targetProject);
        this.targetHandle = this.workspaceOrchestrator.beginExclusiveOperation("synchronize-Project", (Collection)Lists.newArrayList((Object[])new IDtProject[]{targetDtProject}), ProjectPipelineJob.BUILD);
        IDerivedDataManager derivedDataManager = this.derivedDataManagerProvider.get(targetProject);
        derivedDataManager.disableImplicitWaiting();
    }

    private void endMainTargetProjectOperation() {
        Assert.isNotNull((Object)this.targetHandle);
        try {
            IProject targetProject = this.translatedProject.getProject();
            IDerivedDataManager derivedDataManager = this.derivedDataManagerProvider.get(targetProject);
            derivedDataManager.enableImplicitWaiting();
        }
        catch (Exception e) {
            SyncPlugin.logError(e);
        }
    }

    private void beginWaitOnTargetProjectOperation() {
        IProject targetProject = this.translatedProject.getProject();
        this.waitUntilStarted(targetProject, Duration.ofMinutes(5L));
        IDtProject targetDtProject = this.dtProjectManager.getDtProject(targetProject);
        this.targetHandle = this.workspaceOrchestrator.beginExclusiveOperation("synchronizeProject-wait-on", (Collection)Lists.newArrayList((Object[])new IDtProject[]{targetDtProject}), ProjectPipelineJob.BUILD);
    }

    private void endTargetProjectOperation() {
        Assert.isNotNull((Object)this.targetHandle);
        try {
            this.workspaceOrchestrator.endOperation(this.targetHandle);
        }
        catch (Exception e) {
            SyncPlugin.logError(e);
        }
    }

    private void createAllParentFolders(IProgressMonitor monitor) {
        IProject project = this.translatedProject.getProject();
        if (!project.isAccessible()) {
            return;
        }
        SyncCache cache = this.cacheProvider.getSyncCache(this.translatedProject);
        Set folders = cache.allSynchronizedResources().stream().filter(p -> p.segmentCount() > 1).map(p -> p.removeLastSegments(1)).collect(Collectors.toSet());
        for (IPath path : folders) {
            if (monitor.isCanceled()) {
                return;
            }
            IFolder folder = project.getFolder(path);
            try {
                AbstractBmSyncSession.createParentFolders(folder);
            }
            catch (CoreException e) {
                SyncPlugin.logError(e);
            }
        }
    }

    private static final void createParentFolders(IFolder folder) throws CoreException {
        block4: {
            IContainer parent = folder.getParent();
            if (parent instanceof IFolder) {
                AbstractBmSyncSession.createParentFolders((IFolder)parent);
            }
            if (!folder.exists()) {
                try {
                    folder.create(true, true, null);
                }
                catch (CoreException e) {
                    if (folder.exists()) break block4;
                    throw e;
                }
            }
        }
    }

    private void copyAllDelayedFilesToProject(IProgressMonitor monitor) throws CoreException {
        ResourcesPlugin.getWorkspace().run(m -> {
            Iterator<Map.Entry<IFile, File>> iterator = this.delayedFiles.entrySet().iterator();
            while (iterator.hasNext()) {
                if (m.isCanceled()) {
                    return;
                }
                Map.Entry<IFile, File> entry = iterator.next();
                try {
                    File to = entry.getKey().getLocation().toFile();
                    File parent = to.getParentFile();
                    if (parent != null) {
                        parent.mkdirs();
                    }
                    if (to.exists()) {
                        to.delete();
                    }
                    com.google.common.io.Files.move((File)entry.getValue(), (File)to);
                }
                catch (IOException e) {
                    SyncPlugin.logError(e);
                }
            }
            this.translatedProject.getProject().refreshLocal(2, m);
        }, (ISchedulingRule)this.translatedProject.getProject(), 1, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean waitUntilStarted(IProject project, Duration waitDuration) {
        long deadline = System.currentTimeMillis() + waitDuration.toMillis();
        boolean waitComplete = false;
        while (!(waitComplete = this.workspaceOrchestrator.isStarted(project)) && System.currentTimeMillis() < deadline) {
            Object object = this.waitLock;
            synchronized (object) {
                try {
                    this.waitLock.wait(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return waitComplete;
    }

    protected static final class BatchSessionController
    implements IBatchSessionController {
        protected BatchSessionController() {
        }

        public void onBeforeEventProcessing() {
        }

        public void onAfterSave() {
        }

        public void onAfterEventProcessing() {
        }

        public void onBeforeSave(int taskCount) {
        }

        public boolean isParallelSaveAllowed() {
            return true;
        }

        public boolean isAsyncSaveRequired() {
            return true;
        }
    }
}

