/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.sync;

import com._1c.g5.v8.bm.core.IBmTransaction;
import com._1c.g5.v8.bm.integration.IBmModel;
import com._1c.g5.v8.dt.core.filesystem.IQualifiedNameFilePathConverter;
import com._1c.g5.v8.dt.core.platform.IBmModelManager;
import com.e1c.langtool.converter.IConverterManager;
import com.e1c.langtool.converter.IConverterService;
import com.e1c.langtool.platform.ITranslatedProject;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.sync.ResourceSynchronizer;
import com.e1c.langtool.sync.SyncSession;
import com.e1c.langtool.v8.dt.TranslationPreferences;
import com.e1c.langtool.v8.dt.internal.sync.SyncPlugin;
import com.e1c.langtool.v8.dt.sync.BmSyncSession;
import com.e1c.langtool.v8.dt.sync.EmfObjectProvider;
import com.e1c.langtool.v8.dt.sync.naming.TranslatedTopObjectFqnGenerator;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;

public abstract class AbstractExternalPropertySynchronizer
implements ResourceSynchronizer {
    @Inject
    protected IBmModelManager modelManager;
    @Inject
    protected IQualifiedNameFilePathConverter qualifiedNameFilePathConverter;
    @Inject
    protected IQualifiedNameConverter qualifiedNameConverter;
    @Inject
    protected EmfObjectProvider emfObjectProvider;
    @Inject
    protected TranslatedTopObjectFqnGenerator topObjectFqnGenerator;
    @Inject
    private IConverterService converterService;
    @Inject
    private TranslationPreferences preferences;

    public Collection<IResource> synchronize(IFile sourceFile, ITranslatingProject sourceProject, ITranslatedProject target, SyncSession session, IProgressMonitor monitor) {
        LinkedHashSet result = Sets.newLinkedHashSet();
        if (!sourceFile.isAccessible() || !(session instanceof BmSyncSession) || monitor.isCanceled()) {
            return result;
        }
        IProject project = sourceFile.getProject();
        IBmModel model = this.modelManager.getModel(project);
        IBmTransaction transaction = null;
        if (this.executeInTransaction()) {
            transaction = model.getEngine().beginReadOnlyTransaction(false);
        }
        try {
            IStatus status;
            String fileExtension;
            EObject owner = this.emfObjectProvider.getOwnerByFile(sourceFile);
            if (owner == null) {
                if (SyncPlugin.getDefault().isDebugging()) {
                    System.out.println("Owner not found. Cannot synchronize file: " + sourceFile.getFullPath().toString());
                }
                LinkedHashSet linkedHashSet = result;
                return linkedHashSet;
            }
            BmSyncSession bmSession = (BmSyncSession)session;
            QualifiedName fqn = this.qualifiedNameFilePathConverter.getFqn(sourceFile);
            if (fqn == null || fqn.isEmpty()) {
                if (SyncPlugin.getDefault().isDebugging()) {
                    System.out.println("FQN is empty. Cannot synchronize file: " + sourceFile.getFullPath().toString());
                }
                LinkedHashSet linkedHashSet = result;
                return linkedHashSet;
            }
            IProjectTranslationProvider translationProvider = bmSession.getTranslationProvider();
            String translatedFqn = this.topObjectFqnGenerator.generateFqn(owner, translationProvider);
            QualifiedName newFqn = null;
            String filePath = null;
            if (translatedFqn != null) {
                newFqn = this.qualifiedNameConverter.toQualifiedName(translatedFqn).append(fqn.getLastSegment());
                filePath = this.qualifiedNameFilePathConverter.getFilePath(newFqn);
            }
            if (filePath == null) {
                if (SyncPlugin.getDefault().isDebugging()) {
                    System.out.println("Target file path is empty. Cannot synchronize file: " + sourceFile.getFullPath().toString());
                }
                LinkedHashSet linkedHashSet = result;
                return linkedHashSet;
            }
            IFile targetFile = target.getProject().getFile(filePath);
            QualifiedName backconv = this.qualifiedNameFilePathConverter.getFqn(targetFile);
            if (newFqn != null && !newFqn.equals((Object)backconv)) {
                filePath = this.qualifiedNameFilePathConverter.getFilePath(translatedFqn);
                Path path = new Path(filePath);
                path = path.removeLastSegments(1).append(sourceFile.getFullPath().lastSegment());
                targetFile = target.getProject().getFile((IPath)path);
            }
            if ((fileExtension = sourceFile.getFileExtension()) != null && !fileExtension.equals(targetFile.getFileExtension())) {
                IPath path = targetFile.getProjectRelativePath().removeFileExtension().addFileExtension(sourceFile.getFileExtension());
                targetFile = target.getProject().getFile(path);
            }
            if ((status = this.synchronize(sourceFile, owner, target.getProject(), targetFile, bmSession, translationProvider, monitor)).isOK()) {
                IConverterManager manager;
                TranslateLanguage language;
                result.add(targetFile);
                if (this.preferences.getTranslationProperties(project).isEnablePersistentKeyMappingCache() && (language = (manager = this.converterService.getManager(project)).getLanguage()).getLanguageCode().equals(target.getDefaultLanguage().getLanguageCode())) {
                    manager.updateConvertedKey(sourceFile.getProjectRelativePath(), targetFile.getProjectRelativePath());
                }
            }
            LinkedHashSet linkedHashSet = result;
            return linkedHashSet;
        }
        finally {
            if (transaction != null) {
                transaction.rollback();
            }
        }
    }

    protected abstract IStatus synchronize(IFile var1, EObject var2, IProject var3, IFile var4, BmSyncSession var5, IProjectTranslationProvider var6, IProgressMonitor var7);

    protected static final void createParentFolders(IFile file) throws CoreException {
        IContainer parent = file.getParent();
        if (parent instanceof IFolder && !parent.exists()) {
            AbstractExternalPropertySynchronizer.createParentFolders((IFolder)parent);
        }
    }

    protected boolean executeInTransaction() {
        return true;
    }

    private static final void createParentFolders(IFolder folder) throws CoreException {
        block4: {
            IContainer parent = folder.getParent();
            if (parent instanceof IFolder) {
                AbstractExternalPropertySynchronizer.createParentFolders((IFolder)parent);
            }
            if (!folder.exists()) {
                try {
                    folder.create(true, true, null);
                }
                catch (CoreException e) {
                    if (folder.exists()) break block4;
                    throw e;
                }
            }
        }
    }
}

