/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.sync;

import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.v8.dt.internal.sync.SyncPlugin;
import com.e1c.langtool.v8.dt.sync.AbstractExternalPropertySynchronizer;
import com.e1c.langtool.v8.dt.sync.BmSyncSession;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;

public class ReplacebleExternalPropertySynchronizer
extends AbstractExternalPropertySynchronizer {
    private static final String ID = "com.e1c.langtool.v8.dt.sync.ReplacebleExternalProperty";
    protected static final String FILE_NAME_SEGMENT_SPLITTER = "_";
    private ITranslatingProjectManager translatingProjectManager;

    public String getId() {
        return ID;
    }

    @Override
    protected IStatus synchronize(IFile sourceFile, EObject owner, IProject target, IFile targetFile, BmSyncSession bmSession, IProjectTranslationProvider translationProvider, IProgressMonitor monitor) {
        IFile file = this.getSourceFile(sourceFile, translationProvider);
        if (!file.exists()) {
            return Status.CANCEL_STATUS;
        }
        try {
            Throwable throwable = null;
            Object var10_12 = null;
            try (InputStream inputStream = file.getContents();){
                bmSession.storeDelayedFiles(targetFile, inputStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | CoreException e) {
            SyncPlugin.logError(e);
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    protected IFile getSourceFile(IFile sourceFile, IProjectTranslationProvider translationProvider) {
        if (translationProvider.getProject().isChangeDefaultLanguage()) {
            TranslateLanguage language = translationProvider.getProject().getDefaultLanguage();
            if (sourceFile == null || StringUtils.isNullOrEmpty((String)language.getLanguageCode())) {
                return sourceFile;
            }
            IPath translatedPath = sourceFile.getProjectRelativePath().removeFileExtension();
            String segment = translatedPath.lastSegment() + FILE_NAME_SEGMENT_SPLITTER + language.getLanguageCode();
            translatedPath = translatedPath.removeLastSegments(1).append(segment).addFileExtension(sourceFile.getFileExtension());
            IProject project = this.getTranslatingProjectManager().getLanguageProject(translationProvider.getProject().getSourceProject(), language);
            IFile translatedFile = project.getFile(translatedPath);
            if (translatedFile.exists()) {
                return translatedFile;
            }
        }
        return sourceFile;
    }

    private ITranslatingProjectManager getTranslatingProjectManager() {
        if (this.translatingProjectManager == null) {
            this.translatingProjectManager = (ITranslatingProjectManager)SyncPlugin.getDefault().getInjector().getInstance(ITranslatingProjectManager.class);
        }
        return this.translatingProjectManager;
    }
}

