/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.sync.naming;

import com._1c.g5.v8.bm.core.IBmObject;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.v8.dt.sync.naming.TranslatedTopObjectFqnGenerator;
import com.e1c.langtool.v8.dt.sync.naming.TranslatedTopObjectFqnGeneratorDelegate;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;

public abstract class BaseTranslatedTopObjectFqnGeneratorDelegate
implements TranslatedTopObjectFqnGeneratorDelegate {
    @Inject
    protected TranslatedTopObjectFqnGenerator fqnGenerator;
    @Inject
    protected IQualifiedNameConverter qualifiedNameConverter;
    private Collection<EPackage> supportedPackages;

    public BaseTranslatedTopObjectFqnGeneratorDelegate(EPackage ... supportedPackages) {
        Assert.isLegal((supportedPackages.length > 0 ? 1 : 0) != 0, (String)"At least one package must be specified");
        this.supportedPackages = Arrays.asList(supportedPackages);
    }

    public final Collection<EPackage> getSupportedPackages() {
        return this.supportedPackages;
    }

    public String generateExternalPropertyFqn(EObject owner, EReference ownerFeature, IProjectTranslationProvider translationProvider) {
        String ownerFqn = this.fqnGenerator.generateFqn(owner, translationProvider);
        if (ownerFqn == null) {
            StringBuilder message = new StringBuilder("Failed to generate FQN for external property.\nOwner type: ");
            message.append(owner.eClass().getName());
            message.append("\nowner feature: ");
            message.append(ownerFeature.getName());
            message.append("\nowner instance: ");
            message.append(owner);
            message.append("\nowner container: ");
            message.append(owner.eContainer());
            if (owner instanceof IBmObject) {
                IBmObject bmOwner = (IBmObject)owner;
                message.append("\nowner model: ");
                message.append(bmOwner.bmGetEngine() != null ? bmOwner.bmGetEngine().getId() : "null");
                message.append("\nowner id: ");
                message.append(bmOwner.bmGetId());
                message.append("\nowner FQN: ");
                message.append(bmOwner.bmGetFqn());
            }
            throw new AssertionFailedException(message.toString());
        }
        QualifiedName qn = this.qualifiedNameConverter.toQualifiedName(ownerFqn);
        return this.qualifiedNameConverter.toString(qn.append(StringUtils.capitalize((String)ownerFeature.getName())));
    }
}

