/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.sync.ui;

import com.e1c.langtool.v8.dt.internal.sync.ui.ExternalDependenciesModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class SyncUiPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.e1c.langtool.v8.dt.sync.ui";
    private static SyncUiPlugin plugin;
    private volatile Injector injector;
    private BundleContext bundleContext;

    public static SyncUiPlugin getDefault() {
        return plugin;
    }

    public static void log(IStatus status) {
        plugin.getLog().log(status);
    }

    public static void logError(Throwable throwable) {
        SyncUiPlugin.log(SyncUiPlugin.createErrorStatus(throwable.getMessage(), throwable));
    }

    public static IStatus createErrorStatus(String message, Throwable throwable) {
        return new Status(4, PLUGIN_ID, 0, message, throwable);
    }

    public static IStatus createWarningStatus(String message) {
        return new Status(2, PLUGIN_ID, 0, message, null);
    }

    public static IStatus createWarningStatus(String message, Exception throwable) {
        return new Status(2, PLUGIN_ID, 0, message, (Throwable)throwable);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.bundleContext = context;
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        this.injector = null;
        plugin = null;
        super.stop(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Injector getInjector() {
        Injector localInstance = this.injector;
        if (localInstance != null) return localInstance;
        Class<SyncUiPlugin> clazz = SyncUiPlugin.class;
        synchronized (SyncUiPlugin.class) {
            localInstance = this.injector;
            if (localInstance != null) return localInstance;
            this.injector = localInstance = this.createInjector();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return localInstance;
        }
    }

    protected BundleContext getContext() {
        return this.bundleContext;
    }

    private Injector createInjector() {
        try {
            return Guice.createInjector((Module[])new Module[]{new ExternalDependenciesModule((Plugin)this)});
        }
        catch (Exception e) {
            SyncUiPlugin.log(SyncUiPlugin.createErrorStatus("Failed to create injector for " + this.getBundle().getSymbolicName(), e));
            throw new RuntimeException("Failed to create injector for " + this.getBundle().getSymbolicName(), e);
        }
    }
}

