/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.sync.ui.commands;

import com._1c.g5.v8.dt.core.platform.IResourceLookup;
import com.e1c.langtool.platform.ITranslatedProject;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.sync.SynchronizationService;
import com.e1c.langtool.v8.dt.sync.ui.commands.Messages;
import com.e1c.langtool.v8.dt.sync.ui.commands.TranslatedProjectSelectionDialog;
import com.e1c.langtool.v8.dt.ui.projecteditor.TranslatedProjectWizard;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class SynchronizeProjectHandler
extends AbstractHandler {
    @Inject
    private ITranslatingProjectManager projectManager;
    @Inject
    private SynchronizationService syncService;
    @Inject
    private IResourceLookup resourceLookup;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object element;
        IStructuredSelection structuredSelection;
        final Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        final Display display = shell != null ? shell.getDisplay() : PlatformUI.getWorkbench().getDisplay();
        IProject foundProject = null;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection != null && selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() == 1 && (element = structuredSelection.getFirstElement()) instanceof IProject) {
            foundProject = (IProject)element;
        }
        if (foundProject == null) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!display.isDisposed()) {
                        MessageDialog.openInformation((Shell)shell, (String)Messages.SynchronizeProjectHandler_Translation_faild, (String)Messages.SynchronizeProjectHandler_Please_select_translatable_project);
                    }
                }
            });
            return null;
        }
        ITranslatingProject translatingProject = this.projectManager.getProject(foundProject);
        if (!translatingProject.isTranslating()) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!display.isDisposed()) {
                        MessageDialog.openInformation((Shell)shell, (String)Messages.SynchronizeProjectHandler_Translation_not_avalible, (String)Messages.SynchronizeProjectHandler_Please_select_translatable_project);
                    }
                }
            });
            return null;
        }
        if (translatingProject.getTranslatedProjects().isEmpty()) {
            TranslatedProjectWizard wizard = new TranslatedProjectWizard(this.resourceLookup);
            wizard.init(HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getWorkbench(), (IStructuredSelection)new StructuredSelection((Object)foundProject));
            WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
            if (dialog.open() != 0) {
                return null;
            }
        }
        ArrayList translatedProject = Lists.newArrayList();
        if (translatingProject.getTranslatedProjects().size() == 1) {
            translatedProject.addAll(translatingProject.getTranslatedProjects());
        } else if (translatingProject.getTranslatedProjects().size() > 1) {
            translatedProject.addAll(translatingProject.getTranslatedProjects());
            TranslatedProjectSelectionDialog selectionDialog = new TranslatedProjectSelectionDialog(shell);
            selectionDialog.setProjects(translatedProject);
            if (selectionDialog.open() != 0) {
                return null;
            }
        }
        for (ITranslatedProject project : translatedProject) {
            this.syncService.startSync(project);
        }
        return null;
    }
}

