/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.sync.ui.commands;

import com.e1c.langtool.platform.ITranslatedProject;
import com.e1c.langtool.v8.dt.sync.ui.commands.Messages;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class TranslatedProjectSelectionDialog
extends TitleAreaDialog
implements ICheckStateListener {
    private CheckboxTableViewer viewer;
    private ITableLabelProvider labelProvider = new TranslatedProjectTableLableProvider();
    private Collection<ITranslatedProject> viewerInput = Lists.newArrayList();
    private List<ITranslatedProject> translatedProjects = Lists.newArrayList();
    private Button selectAllCheckBox;

    public TranslatedProjectSelectionDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        Font font = parent.getFont();
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite topLevel = new Composite(composite, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)topLevel);
        topLevel.setLayout((Layout)new GridLayout(1, false));
        topLevel.setLayoutData((Object)new GridData(272));
        topLevel.setFont(font);
        this.selectAllCheckBox = new Button(topLevel, 32);
        this.selectAllCheckBox.setText(Messages.TranslatedProjectSelectionDialog_Translate_all_projects);
        this.selectAllCheckBox.setSelection(true);
        this.viewer = CheckboxTableViewer.newCheckList((Composite)topLevel, (int)68354);
        this.viewer.addCheckStateListener((ICheckStateListener)this);
        this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        Table table = this.viewer.getTable();
        table.setLayoutData((Object)new GridData(1808));
        table.setFont(font);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                return false;
            }

            public boolean isChecked(Object element) {
                return TranslatedProjectSelectionDialog.this.translatedProjects.contains(element);
            }
        });
        this.viewer.setInput((Object)this.viewerInput.toArray());
        this.selectAllCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TranslatedProjectSelectionDialog.this.viewer.getTable().setEnabled(!TranslatedProjectSelectionDialog.this.selectAllCheckBox.getSelection());
                if (TranslatedProjectSelectionDialog.this.selectAllCheckBox.getSelection()) {
                    for (ITranslatedProject translatedProject : TranslatedProjectSelectionDialog.this.viewerInput) {
                        if (TranslatedProjectSelectionDialog.this.translatedProjects.contains(translatedProject)) continue;
                        TranslatedProjectSelectionDialog.this.translatedProjects.add(translatedProject);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.viewer.getTable().setEnabled(!this.selectAllCheckBox.getSelection());
        this.setTitle(Messages.TranslatedProjectSelectionDialog_Translate_project);
        this.setMessage(Messages.TranslatedProjectSelectionDialog_Window_Description, 2);
        return composite;
    }

    public void setProjects(List<ITranslatedProject> translatedProjectModels) {
        this.translatedProjects = translatedProjectModels;
        this.viewerInput.clear();
        this.viewerInput.addAll(translatedProjectModels);
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        Object element = event.getElement();
        boolean checked = event.getChecked();
        if (element instanceof ITranslatedProject) {
            if (checked) {
                if (!this.translatedProjects.contains(element)) {
                    this.translatedProjects.add((ITranslatedProject)element);
                }
            } else {
                this.translatedProjects.remove(element);
            }
        }
    }

    private class TranslatedProjectTableLableProvider
    extends BaseLabelProvider
    implements ITableLabelProvider {
        private TranslatedProjectTableLableProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof ITranslatedProject) {
                ITranslatedProject p = (ITranslatedProject)element;
                return p.getProjectName();
            }
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }
}

