/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.builder;

import com.e1c.langtool.builder.ActionType;
import com.e1c.langtool.builder.BuiltResource;
import com.e1c.langtool.builder.IBuiltResourceQueue;
import com.e1c.langtool.builder.Messages;
import com.e1c.langtool.builder.QueueChangeEvent;
import com.e1c.langtool.internal.builder.plugin.BuilderPlugin;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.google.inject.Inject;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public class TranslationBuilder
extends IncrementalProjectBuilder {
    public static final String BUILDER_ID = "com.e1c.langtool.builder.translationBuilder";
    private static final IProject[] EMPTY_PROJ_ARR = new IProject[0];
    @Inject
    protected ITranslatingProjectManager translatingProjectManager;
    @Inject
    private IBuiltResourceQueue resourceQueue;

    protected ITranslatingProject getTranslatingProject() {
        return this.translatingProjectManager.getProject(this.getProject());
    }

    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        this.initInjected();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        ITranslatingProject project = this.getTranslatingProject();
        if (!project.isTranslating()) {
            return EMPTY_PROJ_ARR;
        }
        if (kind == 6) {
            this.resourceQueue.mute();
            this.fullBuild((IProgressMonitor)subMonitor.newChild(1));
            IProject proj = project.getProject();
            this.resourceQueue.unmute(new QueueChangeEvent(proj.getFullPath().toString(), ActionType.ADDED, proj.getName()));
        } else {
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta == null) {
                this.fullBuild((IProgressMonitor)subMonitor.newChild(1));
            } else {
                this.incrementalBuild(delta, (IProgressMonitor)subMonitor.newChild(1));
            }
        }
        return EMPTY_PROJ_ARR;
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        this.initInjected();
        try {
            this.getProject().accept((IResourceVisitor)new ResourceVisitor(ActionType.CLEANED, monitor));
        }
        catch (CoreException e) {
            BuilderPlugin.logError(e);
        }
    }

    protected void fullBuild(IProgressMonitor monitor) {
        try {
            IProject project = this.getProject();
            project.accept((IResourceVisitor)new ResourceVisitor(monitor));
        }
        catch (CoreException e) {
            BuilderPlugin.logError(e);
        }
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) {
        try {
            delta.accept((IResourceDeltaVisitor)new ResourceVisitor(monitor));
        }
        catch (IllegalArgumentException | CoreException e) {
            BuilderPlugin.logError(e);
        }
    }

    protected boolean processResource(IResource resource, ActionType actionType, IProgressMonitor monitor) {
        if (actionType == ActionType.CLEANED) {
            this.resourceQueue.add(this.getTranslatingProject().getProject(), new BuiltResource(resource.getFullPath().toString(), ActionType.CLEANED));
            return false;
        }
        if (resource.getType() == 1) {
            monitor.setTaskName(Messages.TranslationBuilder_CollectingResourcePath + String.valueOf(resource.getProjectRelativePath()));
            this.resourceQueue.add(this.getTranslatingProject().getProject(), new BuiltResource(resource.getFullPath().toString(), actionType));
            return false;
        }
        return true;
    }

    private void initInjected() {
        if (this.translatingProjectManager == null) {
            this.translatingProjectManager = (ITranslatingProjectManager)BuilderPlugin.getDefault().getInjector().getInstance(ITranslatingProjectManager.class);
            this.resourceQueue = (IBuiltResourceQueue)BuilderPlugin.getDefault().getInjector().getInstance(IBuiltResourceQueue.class);
        }
    }

    private class ResourceVisitor
    implements IResourceDeltaVisitor,
    IResourceVisitor {
        private IProgressMonitor monitor;
        private ActionType type = ActionType.ADDED;

        public ResourceVisitor(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public ResourceVisitor(ActionType type, IProgressMonitor monitor) {
            this.type = type;
            this.monitor = monitor;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            return this.visit(delta.getResource(), ActionType.valueOf(delta.getKind()));
        }

        public boolean visit(IResource resource) throws CoreException {
            return this.visit(resource, this.type);
        }

        protected boolean visit(IResource resource, ActionType actionType) {
            this.checkCancel();
            return TranslationBuilder.this.processResource(resource, actionType, this.monitor);
        }

        protected void checkCancel() {
            if (this.monitor.isCanceled()) {
                BuilderPlugin.logInfo(Messages.TranslationBuilder_CanceledBuilderLogMsg);
                throw new OperationCanceledException();
            }
        }
    }
}

