/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.builder;

import com._1c.g5.v8.bm.core.IBmObject;
import com._1c.g5.v8.bm.integration.IBmModel;
import com._1c.g5.v8.dt.core.filesystem.IQualifiedNameFilePathConverter;
import com._1c.g5.v8.dt.core.platform.IBmModelManager;
import com._1c.g5.v8.dt.core.platform.IDtProject;
import com._1c.g5.v8.dt.core.platform.IDtProjectManager;
import com.e1c.langtool.TranslationSource;
import com.e1c.langtool.TranslationUtils;
import com.e1c.langtool.builder.ActionType;
import com.e1c.langtool.builder.BuiltResource;
import com.e1c.langtool.collector.CollectingException;
import com.e1c.langtool.collector.CollectingParameters;
import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.collector.ICollectingParameters;
import com.e1c.langtool.collector.IFeatureValueCollectingService;
import com.e1c.langtool.internal.builder.BuildContext;
import com.e1c.langtool.internal.builder.BuilderParticipantRegistry;
import com.e1c.langtool.internal.builder.IBuiltResourceStorage;
import com.e1c.langtool.internal.builder.Messages;
import com.e1c.langtool.internal.builder.plugin.BuilderPlugin;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.xtext.naming.QualifiedName;

public class InvokeParticipantService {
    private static final ICollectingParameters COLLECTING_PARAMS = CollectingParameters.builder().collectChildObjects().collectModel().collectInterface().collectSubResources().collectComputedStrings().collectEmptyValue().setLanguages((Set)Sets.newHashSet()).enableCache().build();
    private static final int QUEUE_SIZE = 50;
    private BuilderParticipantRegistry participantRegistry = new BuilderParticipantRegistry();
    @Inject
    private IFeatureValueCollectingService collectingService;
    @Inject
    private IQualifiedNameFilePathConverter qualifiedNameFilePathConverter;
    @Inject
    private IBmModelManager modelManager;
    @Inject
    private IDtProjectManager dtProjectManager;
    private ExecutorService execService = this.createExecutorService();

    public boolean process(IBuiltResourceStorage storage, IProgressMonitor monitor) {
        if (this.collectingService == null) {
            BuilderPlugin.getDefault().getInjector().injectMembers((Object)this);
        }
        if (this.checkAndMakeCleanAction(storage, monitor)) {
            return true;
        }
        int storageSize = storage.size() + 1;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)storageSize);
        long ix = 0L;
        for (BuiltResource res : storage) {
            storage.remove(res);
            SubMonitor localMonitor = subMonitor.split(1);
            subMonitor.setTaskName(Messages.InvokeParticipantService_NumberProcessedResourcesTaskName + String.format("%d/%d", ix++, storageSize));
            if (this.execService.isShutdown() || this.execService.isTerminated()) {
                this.execService = this.createExecutorService();
            }
            this.execService.submit(() -> this.processBuiltResource(res, (IProgressMonitor)localMonitor));
            if (ix >= (long)(storageSize - 1)) break;
        }
        this.shutdownExecutorService(this.execService);
        storage.commit();
        return false;
    }

    public void shutdown() {
        this.execService.shutdown();
    }

    private void shutdownExecutorService(ExecutorService execService) {
        execService.shutdown();
        try {
            execService.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            BuilderPlugin.logError(e);
            Thread.currentThread().interrupt();
        }
    }

    private boolean checkAndMakeCleanAction(IBuiltResourceStorage storage, IProgressMonitor monitor) {
        Optional<BuiltResource> cleanRes = storage.getCleanAction();
        if (cleanRes.isPresent()) {
            this.internalProcessBuiltResource(cleanRes.get(), monitor);
            storage.removeCleanAction();
            if (storage.isEmpty()) {
                return true;
            }
        }
        return false;
    }

    private ExecutorService createExecutorService() {
        int cores = Math.min(8, Runtime.getRuntime().availableProcessors() - 1);
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("participant-invoker-%d").setDaemon(true).build();
        ThreadPoolExecutor executor = new ThreadPoolExecutor(cores, cores, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(50, true), new ThreadPoolExecutor.CallerRunsPolicy());
        executor.setThreadFactory(threadFactory);
        return executor;
    }

    private void internalProcessBuiltResource(BuiltResource res, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        SubMonitor internalMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        TranslationSource translationSource = this.getTranslationSource(res.getPath()).orElse(null);
        if (translationSource == null) {
            return;
        }
        Collection<FeatureValue> featureValues = res.getType() == ActionType.CLEANED ? Collections.emptyList() : this.collectFeatureValues(translationSource, (IProgressMonitor)internalMonitor.split(1));
        this.invokeParticipants(translationSource, featureValues, res.getType(), (IProgressMonitor)internalMonitor.split(1));
    }

    private void processBuiltResource(BuiltResource res, IProgressMonitor monitor) {
        try {
            this.internalProcessBuiltResource(res, monitor);
        }
        catch (OperationCanceledException e) {
            return;
        }
        catch (Exception e) {
            String message = String.format("Invalid translation indexing for resource: %s (%s)", new Object[]{res.getPath(), res.getType()});
            BuilderPlugin.log((IStatus)new Status(4, "com.e1c.langtool.builder", message, (Throwable)e));
        }
    }

    private void invokeParticipants(TranslationSource source, Collection<FeatureValue> content, ActionType type, IProgressMonitor monitor) {
        BuildContext context = new BuildContext(source, type, content);
        Collection<BuilderParticipantRegistry.ParticipantAttrs> attrs = this.participantRegistry.getParticipantAttrs().values();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)attrs.size());
        for (BuilderParticipantRegistry.ParticipantAttrs attr : attrs) {
            attr.getParticipant().build(context, (IProgressMonitor)subMonitor.newChild(1));
        }
    }

    private Collection<FeatureValue> collectFeatureValues(TranslationSource source, IProgressMonitor monitor) {
        Set featureValues = Sets.newConcurrentHashSet();
        try {
            this.collectingService.forEachCollected(source, COLLECTING_PARAMS, monitor, (obj, fv) -> {
                boolean bl = featureValues.add(fv);
            });
        }
        catch (CollectingException e) {
            BuilderPlugin.logError(e);
            return Collections.emptyList();
        }
        catch (IllegalArgumentException exc) {
            return Collections.emptyList();
        }
        return featureValues;
    }

    private Optional<TranslationSource> getTranslationSource(String pathName) {
        Path path = new Path(pathName);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject resource = null;
        if (path.segmentCount() == 1) {
            resource = root.getProject(path.segment(0));
        } else if (path.segmentCount() > 1) {
            resource = root.getFile((IPath)path);
        }
        TranslationSource source = TranslationUtils.getTranslationSource((Object)resource);
        if (source == null && resource != null) {
            source = this.findMdoSource((IPath)path, (IResource)resource);
        }
        if (source == null) {
            BuilderPlugin.logInfo("Following resource can't be adapted to translation source: " + String.valueOf(resource));
        }
        return Optional.ofNullable(source);
    }

    private TranslationSource findMdoSource(IPath path, IResource resource) {
        IProject project = resource.getProject();
        IDtProject dtProject = this.dtProjectManager.getDtProject(project);
        if (dtProject == null) {
            return null;
        }
        IBmModel model = this.modelManager.getModel(project);
        if (model == null) {
            return null;
        }
        return (TranslationSource)this.modelManager.executeReadOnlyTask(project, transaction -> {
            String filename = path.lastSegment();
            int idx = filename.lastIndexOf("_");
            if (idx > 0) {
                String newFile = String.format("%s.mdo", filename.substring(0, idx));
                QualifiedName fqn = this.qualifiedNameFilePathConverter.getFqn(path.removeLastSegments(1).append(newFile));
                if (fqn != null && !fqn.isEmpty()) {
                    IBmObject topObject = transaction.getTopObjectByFqn(fqn.toString());
                    return TranslationUtils.getTranslationSource((Object)topObject);
                }
            }
            return null;
        });
    }
}

