/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.sync;

import com.e1c.langtool.internal.sync.SyncCacheEditor;
import com.e1c.langtool.platform.ITranslatedProject;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MapMaker;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;

public class InMemorySyncCacheEditor
implements SyncCacheEditor {
    private final ITranslatedProject translatedProject;
    private final Map<IPath, Map<String, Collection<IPath>>> cache = new MapMaker().makeMap();

    public InMemorySyncCacheEditor(ITranslatedProject translatedProject) {
        this.translatedProject = translatedProject;
    }

    @Override
    public ITranslatedProject getProject() {
        return this.translatedProject;
    }

    @Override
    public Collection<IPath> getSynchronizedResources(IPath fullSourcePath) {
        if (!this.cache.containsKey(fullSourcePath)) {
            return Collections.emptyList();
        }
        ImmutableSet.Builder builder = new ImmutableSet.Builder();
        this.cache.get(fullSourcePath).forEach((k, v) -> {
            ImmutableSet.Builder builder2 = builder.addAll((Iterable)v);
        });
        return builder.build();
    }

    @Override
    public Collection<IPath> getSynchronizedResources(IPath fullSourcePath, String synchronizerId) {
        if (!this.cache.containsKey(fullSourcePath) || !this.cache.get(fullSourcePath).containsKey(synchronizerId)) {
            return Collections.emptyList();
        }
        Collection<IPath> result = this.cache.get(fullSourcePath).get(synchronizerId);
        if (result == null) {
            result = Collections.emptyList();
        }
        return result;
    }

    @Override
    public Collection<IPath> allSynchronizedResources() {
        return this.cache.values().stream().flatMap(p -> p.values().stream()).flatMap(p -> p.stream()).collect(Collectors.toSet());
    }

    @Override
    public void putSyncronizedResources(IPath fullSourcePath, String syncronizerId, Collection<IPath> syncronizedResources) {
        Assert.isNotNull((Object)syncronizerId);
        Assert.isNotNull((Object)fullSourcePath);
        Assert.isNotNull(syncronizedResources);
        this.cache.computeIfAbsent(fullSourcePath, s -> new MapMaker().makeMap()).put(syncronizerId, ImmutableSet.copyOf(syncronizedResources));
    }

    @Override
    public void clearSyncronizedResources(IPath fullSourcePath, String syncronizerId) {
        if (this.cache.containsKey(fullSourcePath)) {
            this.cache.get(fullSourcePath).remove(syncronizerId);
            if (this.cache.get(fullSourcePath).isEmpty()) {
                this.cache.remove(fullSourcePath);
            }
        }
    }
}

