/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.sync;

import com.e1c.langtool.internal.sync.InMemorySyncCacheEditor;
import com.e1c.langtool.internal.sync.InternalSyncCacheProvider;
import com.e1c.langtool.internal.sync.SyncCacheEditor;
import com.e1c.langtool.platform.ITranslatedProject;
import com.e1c.langtool.platform.ITranslatedProjectManager;
import com.e1c.langtool.sync.SyncCache;
import com.google.common.collect.MapMaker;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Map;
import org.eclipse.core.resources.IProject;

@Singleton
public class InMemorySyncCacheProvider
implements InternalSyncCacheProvider {
    @Inject
    private ITranslatedProjectManager manager;
    private Map<ITranslatedProject, SyncCacheEditor> caches = new MapMaker().makeMap();

    @Override
    public SyncCache getSyncCache(IProject translatedProject) {
        return this.getSyncCache(this.manager.getProject(translatedProject));
    }

    @Override
    public SyncCache getSyncCache(ITranslatedProject translatedProject) {
        return this.caches.computeIfAbsent(translatedProject, k -> new InMemorySyncCacheEditor(translatedProject));
    }

    @Override
    public SyncCacheEditor getSyncCacheEditor(ITranslatedProject translatedProject) {
        return this.caches.computeIfAbsent(translatedProject, k -> new InMemorySyncCacheEditor(translatedProject));
    }
}

