/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.sync;

import com.e1c.langtool.internal.sync.InternalSyncCacheProvider;
import com.e1c.langtool.internal.sync.InternalSynchronizationService;
import com.e1c.langtool.internal.sync.Messages;
import com.e1c.langtool.internal.sync.SyncCacheEditor;
import com.e1c.langtool.internal.sync.SyncPlugin;
import com.e1c.langtool.internal.sync.SyncSessionFactoryRegistry;
import com.e1c.langtool.platform.ITranslatedProject;
import com.e1c.langtool.sync.EqualityState;
import com.e1c.langtool.sync.ResourceSynchronizer;
import com.e1c.langtool.sync.StateChangeEvent;
import com.e1c.langtool.sync.StateChangeListener;
import com.e1c.langtool.sync.SyncSession;
import com.e1c.langtool.sync.SyncStrategy;
import com.e1c.langtool.sync.SynchronizableProject;
import com.e1c.langtool.sync.SynchronizationManager;
import com.e1c.langtool.sync.SynchronizerRegistry;
import com.e1c.langtool.sync.change.ChangeManager;
import com.e1c.langtool.sync.change.PostChangeListener;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;

public class ProjectSynchronization
implements SynchronizationManager {
    private static final long FLAG_POLLING_PERIOD = 100L;
    @Inject
    private SynchronizerRegistry registry;
    @Inject
    private InternalSyncCacheProvider cacheProvider;
    @Inject
    private SyncSessionFactoryRegistry syncSessionFactoryRegistry;
    private final InternalSynchronizationService service;
    private ITranslatedProject translatedProject;
    private volatile EqualityState equalityState = null;
    private ListenerList<StateChangeListener> stateChangeListeners = new ListenerList();
    private volatile SyncStrategy strategy;
    private final PostChangeListener postChangeListener = event -> {
        if (!this.getEqualityState().equals((Object)EqualityState.SYNCHRONIZING)) {
            this.setEqualityState(this.computeEqualityState());
        }
    };

    public ProjectSynchronization(InternalSynchronizationService service) {
        this.service = service;
    }

    @Override
    public synchronized ITranslatedProject getTranslatedProject() {
        return this.translatedProject;
    }

    public synchronized void setTranslatedProject(ITranslatedProject translatedProject) {
        this.translatedProject = translatedProject;
    }

    @Override
    public SyncStrategy getSyncStrategy() {
        if (this.strategy == null) {
            this.strategy = this.service.getSyncSettings(this.translatedProject.getSourceProject().getProject(), this.translatedProject.getProject());
        }
        return this.strategy;
    }

    @Override
    public void setSyncStrategy(SyncStrategy strategy) {
        Assert.isNotNull((Object)((Object)strategy));
        this.strategy = strategy;
        if (this.translatedProject.getSourceProject() != null) {
            this.service.updateSyncSettings(this.translatedProject.getSourceProject().getProject(), this.translatedProject.getProject(), strategy);
        }
    }

    @Override
    public EqualityState getEqualityState() {
        if (this.equalityState == null) {
            this.equalityState = this.computeEqualityState();
        }
        return this.equalityState;
    }

    public void setEqualityState(EqualityState equalityState) {
        Assert.isNotNull((Object)((Object)equalityState));
        if (SyncPlugin.getDefault().isDebugging()) {
            System.out.println(MessageFormat.format("Set equality state: {0} for: {1} ", new Object[]{equalityState, this.getTranslatedProject().getProjectName()}));
        }
        EqualityState oldState = this.equalityState;
        this.equalityState = equalityState;
        if (oldState != equalityState) {
            this.fireStateChanged(new StateChangeEvent(this, this.translatedProject.getProject(), oldState, equalityState));
        }
    }

    @Override
    public void addStateChangeListener(StateChangeListener listener) {
        Assert.isNotNull((Object)listener);
        this.stateChangeListeners.add((Object)listener);
    }

    @Override
    public void removeStateChangeListener(StateChangeListener listener) {
        Assert.isNotNull((Object)listener);
        this.stateChangeListeners.remove((Object)listener);
    }

    @Override
    public IStatus synchronize(IProgressMonitor monitor) {
        if (!(this.translatedProject.getSourceProject() instanceof SynchronizableProject) || !((SynchronizableProject)this.translatedProject.getSourceProject()).isSynchronizing()) {
            return new Status(4, "com.e1c.langtool.sync", MessageFormat.format("Cannot synchronize non synchronizable project {0}", this.translatedProject.getSourceProject().getProject()));
        }
        this.setEqualityState(EqualityState.SYNCHRONIZING);
        SynchronizableProject sourceProject = (SynchronizableProject)this.translatedProject.getSourceProject();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)MessageFormat.format(Messages.ProjectSynchronization_Synchronizing_project, this.translatedProject.getProjectName()), (int)-1);
        IProject project = this.translatedProject.getProject();
        if (project != null && project.exists() && !project.isOpen()) {
            if (SyncPlugin.getDefault().isDebugging()) {
                System.out.println("Opening project: " + project.getName());
            }
            try {
                project.open((IProgressMonitor)SubMonitor.convert((IProgressMonitor)subMonitor, (String)Messages.ProjectSynchronization_Opening_existing_project, (int)-1));
            }
            catch (CoreException e) {
                this.setEqualityState(EqualityState.NOT_CREATED);
                return SyncPlugin.createErrorStatus(MessageFormat.format("Cannot open existing project: {0}", this.translatedProject.getProject().getName()), e);
            }
        }
        SyncSession session = this.syncSessionFactoryRegistry.createSyncSession(sourceProject, this.translatedProject);
        if (project == null || !project.isAccessible()) {
            IStatus result;
            if (SyncPlugin.getDefault().isDebugging()) {
                System.out.println("Creating project: " + String.valueOf(project));
            }
            if (!(result = session.createProject((IProgressMonitor)SubMonitor.convert((IProgressMonitor)subMonitor, (String)Messages.ProjectSynchronization_Creating_project, (int)-1))).isOK()) {
                this.setEqualityState(EqualityState.NOT_CREATED);
                return result;
            }
        }
        if (this.translatedProject.getProject() == null || !this.translatedProject.getProject().isAccessible()) {
            this.setEqualityState(EqualityState.NOT_CREATED);
            return Status.CANCEL_STATUS;
        }
        if (SyncPlugin.getDefault().isDebugging()) {
            System.out.println("Before synchronizing project: " + String.valueOf(project));
        }
        ChangeManager changeManager = this.service.getChangeManager(this.getTranslatedProject());
        changeManager.initialize((IProgressMonitor)SubMonitor.convert((IProgressMonitor)subMonitor, (String)Messages.ProjectSynchronization_Prepare_project_before_synchronizing, (int)-1));
        int total = changeManager.getFilesToUpdate().size() + changeManager.getFilesToRemove().size();
        if (SyncPlugin.getDefault().isDebugging()) {
            System.out.println(MessageFormat.format("Total files: {0} to synchronize project: {1}", total, this.translatedProject.getProjectName()));
        }
        session.beginSyncOperation();
        try {
            MultiStatus status;
            block29: {
                IStatus result = session.beforeSynchronizing((IProgressMonitor)SubMonitor.convert((IProgressMonitor)subMonitor, (String)Messages.ProjectSynchronization_Prepare_project_before_synchronizing, (int)-1));
                if (!result.isOK()) {
                    this.setEqualityState(EqualityState.NEED_UPDATE);
                    IStatus iStatus = result;
                    return iStatus;
                }
                status = new MultiStatus("com.e1c.langtool.sync", 0, Messages.ProjectSynchronization_Synchronization_successful, null);
                try {
                    try {
                        ResourcesPlugin.getWorkspace().run(m -> this.synchronize(session, changeManager, status, SubMonitor.convert((IProgressMonitor)m, (int)total)), null, 1, (IProgressMonitor)subMonitor);
                    }
                    catch (CoreException | OperationCanceledException arg12) {
                        status.merge(Status.CANCEL_STATUS);
                        if (SyncPlugin.getDefault().isDebugging()) {
                            System.out.println("After synchronizing project: " + String.valueOf(project));
                        }
                        status.add(session.afterSynchronized((IProgressMonitor)SubMonitor.convert((IProgressMonitor)subMonitor, (String)Messages.ProjectSynchronization_Finishing_project_synchronization, (int)-1)));
                        break block29;
                    }
                }
                catch (Throwable throwable) {
                    if (SyncPlugin.getDefault().isDebugging()) {
                        System.out.println("After synchronizing project: " + String.valueOf(project));
                    }
                    status.add(session.afterSynchronized((IProgressMonitor)SubMonitor.convert((IProgressMonitor)subMonitor, (String)Messages.ProjectSynchronization_Finishing_project_synchronization, (int)-1)));
                    throw throwable;
                }
                if (SyncPlugin.getDefault().isDebugging()) {
                    System.out.println("After synchronizing project: " + String.valueOf(project));
                }
                status.add(session.afterSynchronized((IProgressMonitor)SubMonitor.convert((IProgressMonitor)subMonitor, (String)Messages.ProjectSynchronization_Finishing_project_synchronization, (int)-1)));
            }
            if (SyncPlugin.getDefault().isDebugging()) {
                System.out.println("Finished sync project: " + String.valueOf(project));
            }
            if (!session.getSkipped().isEmpty()) {
                StringBuilder sb = new StringBuilder("No synchronizer for Files:");
                if (session.getSkipped().size() > 1) {
                    for (IPath path : session.getSkipped()) {
                        sb.append("\n").append(path.toString());
                    }
                } else {
                    sb.append(MessageFormat.format("No synchronizer for File: {0}", session.getSkipped().iterator().next()));
                }
                SyncPlugin.log(SyncPlugin.createWarningStatus(sb.toString()));
            }
            EqualityState state = this.computeEqualityState();
            this.setEqualityState(state);
            MultiStatus multiStatus = new MultiStatus("com.e1c.langtool.sync", status.getCode(), status.getChildren(), this.getMessage((IStatus)status), status.getException());
            return multiStatus;
        }
        finally {
            session.endSyncOperation();
            changeManager.addPostChangeListener(this.postChangeListener);
        }
    }

    private EqualityState computeEqualityState() {
        if (this.getTranslatedProject().getProject() == null || !this.getTranslatedProject().getProject().isAccessible()) {
            return EqualityState.NOT_CREATED;
        }
        ChangeManager changeManager = this.service.getChangeManager(this.getTranslatedProject());
        if (changeManager.isDisposed()) {
            return EqualityState.NEED_UPDATE;
        }
        if (changeManager.isInitialized() && changeManager.getFilesToUpdate().isEmpty() && changeManager.getFilesToRemove().isEmpty()) {
            changeManager.addPostChangeListener(this.postChangeListener);
            return EqualityState.SYNCHRONIZED;
        }
        return EqualityState.NEED_UPDATE;
    }

    protected void fireStateChanged(StateChangeEvent event) {
        for (StateChangeListener l : this.stateChangeListeners) {
            try {
                SafeRunner.run(() -> l.stateChagned(event));
            }
            catch (Throwable e) {
                SyncPlugin.logError(e);
            }
        }
    }

    private void synchronize(SyncSession session, ChangeManager changeManager, MultiStatus status, SubMonitor progress) {
        TaskMonitor taskMonitor = new TaskMonitor();
        ExecutorService syncPool = this.service.getSyncPool();
        if (syncPool.isShutdown()) {
            return;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        LinkedList<Future<IStatus>> taskFutures = new LinkedList<Future<IStatus>>();
        ArrayList toRemove = Lists.newArrayList(changeManager.getFilesToRemove());
        toRemove.sort((o1, o2) -> {
            IFile f1 = root.getFile(o1);
            IFile f2 = root.getFile(o2);
            int compare = this.registry.getSynchronizePriority(f1) - this.registry.getSynchronizePriority(f2);
            if (compare == 0) {
                return o1.toString().compareTo(o2.toString());
            }
            return compare;
        });
        for (IPath path : toRemove) {
            ResourceRemoveTask task = new ResourceRemoveTask(path, session, changeManager, (IProgressMonitor)taskMonitor);
            taskFutures.add(syncPool.submit(task));
        }
        ArrayList toUpdate = Lists.newArrayList(changeManager.getFilesToUpdate());
        toUpdate.sort((o1, o2) -> {
            IFile f1 = root.getFile(o1);
            IFile f2 = root.getFile(o2);
            int compare = this.registry.getSynchronizePriority(f1) - this.registry.getSynchronizePriority(f2);
            if (compare == 0) {
                return o1.toString().compareTo(o2.toString());
            }
            return compare;
        });
        int total = toUpdate.size() + toRemove.size();
        for (IPath path : toUpdate) {
            ResourceSyncTask task = new ResourceSyncTask(path, session, changeManager, (IProgressMonitor)taskMonitor);
            taskFutures.add(syncPool.submit(task));
        }
        while (!this.awaitCompletion(taskFutures, status, progress)) {
            if (Thread.interrupted()) {
                Thread.currentThread().interrupt();
                taskMonitor.setCanceled(true);
                throw new OperationCanceledException();
            }
            if (progress.isCanceled()) {
                taskMonitor.setCanceled(true);
                if (SyncPlugin.getDefault().isDebugging()) {
                    System.out.println("Monitor set canceled");
                }
                throw new OperationCanceledException();
            }
            String taskName = taskMonitor.getTaskName();
            if (taskName != null) {
                progress.setTaskName(taskName);
                continue;
            }
            progress.setTaskName(MessageFormat.format(Messages.ProjectSynchronization_Remaining_resources_N_of_M, taskFutures.size(), total));
        }
    }

    private String getMessage(IStatus status) {
        if (status.getSeverity() == 0 || status.getSeverity() == 1) {
            return Messages.ProjectSynchronization_Synchronization_successful;
        }
        if (status.matches(8)) {
            return Messages.ProjectSynchronization_Synchronization_canceled_by_user;
        }
        if (status.matches(2)) {
            return Messages.ProjectSynchronization_Synchronization_completed_with_warnings;
        }
        if (status.getChildren().length > 1) {
            return Messages.ProjectSynchronization_Synchronization_operation_has_several_errors;
        }
        return Messages.ProjectSynchronization_Synchronization_operation_has_error;
    }

    private boolean awaitCompletion(Deque<Future<IStatus>> taskFutures, MultiStatus status, SubMonitor monitor) {
        long deadline = System.currentTimeMillis() + 100L;
        int current = 0;
        while (true) {
            monitor.setWorkRemaining(taskFutures.size());
            int index = 0;
            Iterator<Future<IStatus>> iterator = taskFutures.iterator();
            while (iterator.hasNext() && index < 1000 && index < current && index < taskFutures.size()) {
                ++index;
                iterator.next();
            }
            current = index;
            Future<IStatus> taskFuture = iterator.hasNext() ? iterator.next() : null;
            if (current >= 1000 || taskFuture == null && current > 0) {
                return false;
            }
            if (taskFuture == null) {
                return true;
            }
            long now = System.currentTimeMillis();
            if (now > deadline) {
                return false;
            }
            try {
                IStatus result = taskFuture.get(1L, TimeUnit.MILLISECONDS);
                if (!result.isOK()) {
                    status.add(result);
                }
                taskFutures.remove(taskFuture);
                current = 0;
                monitor.worked(1);
                continue;
            }
            catch (InterruptedException e2) {
                Thread.currentThread().interrupt();
                return false;
            }
            catch (ExecutionException e) {
                status.add(SyncPlugin.createErrorStatus(e.getMessage(), e));
                taskFutures.remove(taskFuture);
                continue;
            }
            catch (TimeoutException e3) {
                ++current;
                continue;
            }
            break;
        }
    }

    private void removeOldSynchronizeResources(Collection<IPath> synchronizedResources, IProgressMonitor monitor) {
        IProject target = this.getTranslatedProject().getProject();
        Iterator<IPath> iterator = synchronizedResources.iterator();
        while (iterator.hasNext()) {
            if (monitor.isCanceled()) {
                return;
            }
            IPath path = iterator.next();
            IFile file = target.getFile(path);
            if (!file.exists()) continue;
            try {
                file.delete(true, monitor);
            }
            catch (CoreException e) {
                SyncPlugin.log(SyncPlugin.createErrorStatus(MessageFormat.format("Filed to remove old syncronized file {0}", file), e));
            }
        }
    }

    private final class ResourceRemoveTask
    implements Callable<IStatus> {
        private final IPath fullPath;
        private final SyncSession session;
        private final ChangeManager changeManager;
        private final IProgressMonitor monitor;

        public ResourceRemoveTask(IPath fullPath, SyncSession session, ChangeManager changeManager, IProgressMonitor monitor) {
            this.fullPath = fullPath;
            this.session = session;
            this.changeManager = changeManager;
            this.monitor = monitor;
        }

        @Override
        public IStatus call() throws Exception {
            IFile file;
            boolean fileSyncExist;
            if (this.monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            if (SyncPlugin.getDefault().isDebugging()) {
                System.out.println("Start sync remove: " + this.fullPath.toString());
            }
            if (!(fileSyncExist = ProjectSynchronization.this.registry.synchronizerExist(file = ResourcesPlugin.getWorkspace().getRoot().getFile(this.fullPath)))) {
                this.session.getSkipped().add(file.getFullPath());
                this.changeManager.markRemoved(this.fullPath);
                return Status.OK_STATUS;
            }
            SyncCacheEditor cache = ProjectSynchronization.this.cacheProvider.getSyncCacheEditor(ProjectSynchronization.this.getTranslatedProject());
            HashSet synchronizedResources = Sets.newHashSet();
            HashSet newRemovedResources = Sets.newHashSet();
            Collection<ResourceSynchronizer> fileSync = ProjectSynchronization.this.registry.getSynchronizers(file);
            for (ResourceSynchronizer synchronizer : fileSync) {
                if (this.monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                Collection<IFile> result = synchronizer.remove(file, ProjectSynchronization.this.translatedProject.getSourceProject(), ProjectSynchronization.this.translatedProject, this.session, this.monitor);
                if (this.monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                synchronizedResources.addAll(cache.getSynchronizedResources(this.fullPath, synchronizer.getId()));
                Collection resultPaths = result.stream().map(IResource::getProjectRelativePath).collect(Collectors.toList());
                newRemovedResources.addAll(resultPaths);
                cache.clearSyncronizedResources(this.fullPath, synchronizer.getId());
            }
            synchronizedResources.removeAll(newRemovedResources);
            ProjectSynchronization.this.removeOldSynchronizeResources(synchronizedResources, this.monitor);
            this.changeManager.markRemoved(this.fullPath);
            if (SyncPlugin.getDefault().isDebugging()) {
                System.out.println("Finished sync remove: " + this.fullPath.toString());
            }
            return Status.OK_STATUS;
        }
    }

    private final class ResourceSyncTask
    implements Callable<IStatus> {
        private final IPath fullPath;
        private final SyncSession session;
        private final ChangeManager changeManager;
        private final IProgressMonitor monitor;

        public ResourceSyncTask(IPath fullPath, SyncSession session, ChangeManager changeManager, IProgressMonitor monitor) {
            this.fullPath = fullPath;
            this.session = session;
            this.changeManager = changeManager;
            this.monitor = monitor;
        }

        @Override
        public IStatus call() throws Exception {
            IFile file;
            boolean fileSyncExist;
            if (this.monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            if (SyncPlugin.getDefault().isDebugging()) {
                System.out.println("Start sync: " + this.fullPath.toString());
            }
            if (!(fileSyncExist = ProjectSynchronization.this.registry.synchronizerExist(file = ResourcesPlugin.getWorkspace().getRoot().getFile(this.fullPath)))) {
                this.session.getSkipped().add(file.getFullPath());
                this.changeManager.markSynchronized(this.fullPath);
                return Status.OK_STATUS;
            }
            SyncCacheEditor cache = ProjectSynchronization.this.cacheProvider.getSyncCacheEditor(ProjectSynchronization.this.getTranslatedProject());
            HashSet synchronizedResources = Sets.newHashSet();
            HashSet newSynchronizedResources = Sets.newHashSet();
            boolean hasNoActionSynchronizer = false;
            Collection<ResourceSynchronizer> fileSync = ProjectSynchronization.this.registry.getSynchronizers(file);
            for (ResourceSynchronizer synchronizer : fileSync) {
                if (this.monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                if ("com.e1c.langtool.sync.NoAction".equals(synchronizer.getId())) {
                    hasNoActionSynchronizer = true;
                }
                Collection<IResource> result = synchronizer.synchronize(file, ProjectSynchronization.this.translatedProject.getSourceProject(), ProjectSynchronization.this.translatedProject, this.session, this.monitor);
                if (this.monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                synchronizedResources.addAll(cache.getSynchronizedResources(this.fullPath, synchronizer.getId()));
                Collection resultPaths = result.stream().map(IResource::getProjectRelativePath).collect(Collectors.toList());
                newSynchronizedResources.addAll(resultPaths);
                cache.putSyncronizedResources(this.fullPath, synchronizer.getId(), resultPaths);
            }
            synchronizedResources.removeAll(newSynchronizedResources);
            ProjectSynchronization.this.removeOldSynchronizeResources(synchronizedResources, this.monitor);
            this.changeManager.markSynchronized(this.fullPath);
            if (SyncPlugin.getDefault().isDebugging()) {
                System.out.println(MessageFormat.format("Finished sync: {0} to: {1}", this.fullPath, newSynchronizedResources));
            }
            if (SyncPlugin.getDefault().isDebugging() && newSynchronizedResources.isEmpty() && !hasNoActionSynchronizer) {
                System.err.println(MessageFormat.format("Resource: {0} was not synchronized", this.fullPath));
            }
            return Status.OK_STATUS;
        }
    }

    private static class TaskMonitor
    extends NullProgressMonitor {
        private volatile String taskName;

        private TaskMonitor() {
        }

        public void setTaskName(String name) {
            this.taskName = name;
        }

        public String getTaskName() {
            return this.taskName;
        }
    }
}

