/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.sync;

import com._1c.g5.resourcemanagement.ActivityDemandsDefaultAdapter;
import com._1c.g5.resourcemanagement.ActivityResourcePermissions;
import com._1c.g5.resourcemanagement.IActivityDemandsDefinition;
import com._1c.g5.resourcemanagement.IHostResourceManagementHandle;
import com._1c.g5.resourcemanagement.IHostResourceManagerListener;
import com._1c.g5.resourcemanagement.IResourcePlan;
import com._1c.g5.resourcemanagement.SystemLoadState;
import com._1c.g5.v8.dt.core.platform.management.IDtHostResourceManager;
import com.e1c.langtool.internal.sync.InternalSynchronizationService;
import com.e1c.langtool.internal.sync.Messages;
import com.e1c.langtool.internal.sync.ProjectSynchronization;
import com.e1c.langtool.internal.sync.SyncPlugin;
import com.e1c.langtool.internal.sync.change.InMemoryChangeManagerProxy;
import com.e1c.langtool.internal.sync.change.SourceChangeManagerWrapper;
import com.e1c.langtool.platform.ITranslatedProject;
import com.e1c.langtool.platform.ITranslatedProjectManager;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.sync.EqualityState;
import com.e1c.langtool.sync.StateChangeListener;
import com.e1c.langtool.sync.SyncStrategy;
import com.e1c.langtool.sync.SynchronizableProject;
import com.e1c.langtool.sync.SynchronizationManager;
import com.e1c.langtool.sync.change.ChangeManager;
import com.e1c.langtool.sync.change.EditingChangeManager;
import com.e1c.langtool.sync.change.PostChangeListener;
import com.e1c.langtool.sync.change.SourceChangeManager;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;

@Singleton
public class ProjectSynchronizationService
implements InternalSynchronizationService {
    private static final long AUTO_SYNC_JOB_DELAY = 2000L;
    private static final long DEFAULT_SYNC_JOB_DELAY = 500L;
    private static final String SYNC_STRATEGY_KEY = "syncStrategy";
    private static final String SYNC_PROJECT_ACTIVITY = "SYNC_PROJECT";
    private static final Integer EXTERNAL_CORE_LIMIT = Integer.getInteger("coreLimit");
    private static final int MAX_EFFECTIVE_THREADS = 8;
    @Inject
    private ITranslatedProjectManager translatedProjectManager;
    @Inject
    private ITranslatingProjectManager translatingProjectManager;
    @Inject
    private IDtHostResourceManager hostResourceManager;
    private Object lock = new Object();
    private ListenerList<StateChangeListener> stateChangeListeners = new ListenerList();
    private final Map<IProject, SynchronizationManager> syncManagers = new ConcurrentHashMap<IProject, SynchronizationManager>();
    private final Map<IProject, ChangeManager> changeManagers = new ConcurrentHashMap<IProject, ChangeManager>();
    private final Map<IProject, SourceChangeManager> sourceChangeManagers = new ConcurrentHashMap<IProject, SourceChangeManager>();
    private ThreadPoolExecutor syncPool;
    private IResourceChangeListener projectChangeListener = new ProjectChangeListener();
    private IResourceChangeListener contentChangeListener = new ContentChangeListerer();
    private final PostChangeListener syncJobSchedulerListener = event -> {
        if (!event.getType().equals((Object)PostChangeListener.ChangeEventType.Cleared)) {
            this.changeManagers.forEach((project, manager) -> {
                if (manager.equals(event.getManager()) && this.getSynchronizationManager((IProject)project).getSyncStrategy().equals((Object)SyncStrategy.AUTO)) {
                    this.startSync((IProject)project, 2000L);
                }
            });
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate() {
        Object object = this.lock;
        synchronized (object) {
            int availableProcessors = Runtime.getRuntime().availableProcessors();
            availableProcessors = Math.min(availableProcessors, 8);
            if (EXTERNAL_CORE_LIMIT != null) {
                availableProcessors = Math.min(EXTERNAL_CORE_LIMIT, availableProcessors);
            }
            if (availableProcessors <= 0) {
                availableProcessors = 1;
            }
            this.syncPool = new ThreadPoolExecutor(availableProcessors, availableProcessors, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){
                AtomicInteger index = new AtomicInteger(0);

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = new Thread(r);
                    t.setName("LT-Project-synchronizer " + this.index.incrementAndGet());
                    return t;
                }
            });
            IHostResourceManagementHandle hostResourceManagementHandle = this.hostResourceManager.registerResourcePlan((IResourcePlan)new ResourcePlan());
            hostResourceManagementHandle.addListener(new IHostResourceManagerListener(){

                public synchronized void permissionsChanged(String activityName, ActivityResourcePermissions updatedPermissions) {
                    int currentCores;
                    int newCores = updatedPermissions.getCores();
                    if (newCores < (currentCores = ProjectSynchronizationService.this.syncPool.getCorePoolSize())) {
                        ProjectSynchronizationService.this.syncPool.setCorePoolSize(newCores);
                        ProjectSynchronizationService.this.syncPool.setMaximumPoolSize(newCores);
                    } else if (newCores > currentCores) {
                        ProjectSynchronizationService.this.syncPool.setMaximumPoolSize(newCores);
                        ProjectSynchronizationService.this.syncPool.setCorePoolSize(newCores);
                    }
                }
            });
            hostResourceManagementHandle.startActivity(SYNC_PROJECT_ACTIVITY);
            ResourcesPlugin.getWorkspace().addResourceChangeListener(this.projectChangeListener, 6);
            ResourcesPlugin.getWorkspace().addResourceChangeListener(this.contentChangeListener, 1);
        }
    }

    public void deactivate() {
        try {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.projectChangeListener);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (this.syncPool != null) {
            this.syncPool.shutdown();
            try {
                this.syncPool.awaitTermination(100L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                SyncPlugin.logError(interruptedException);
            }
        }
        for (Map.Entry<IProject, SourceChangeManager> entry : this.sourceChangeManagers.entrySet()) {
            entry.getValue().dispose();
        }
        for (Map.Entry<IProject, EditingChangeManager> entry : this.changeManagers.entrySet()) {
            ((ChangeManager)entry.getValue()).dispose();
        }
        this.syncManagers.clear();
        this.changeManagers.clear();
        this.sourceChangeManagers.clear();
    }

    @Override
    public EqualityState getState(IProject project) {
        Assert.isNotNull((Object)project);
        SynchronizationManager manager = this.syncManagers.computeIfAbsent(project, p -> this.createSyncManager((IProject)p));
        return manager.getEqualityState();
    }

    @Override
    public EqualityState getState(ITranslatedProject project) {
        return project == null ? EqualityState.NOT_CREATED : this.getState(project.getProject());
    }

    @Override
    public void addStateChangeListener(StateChangeListener listener) {
        this.stateChangeListeners.add((Object)listener);
        for (Map.Entry<IProject, SynchronizationManager> entry : this.syncManagers.entrySet()) {
            entry.getValue().addStateChangeListener(listener);
        }
    }

    @Override
    public void removeStateChangeListener(StateChangeListener listener) {
        this.stateChangeListeners.remove((Object)listener);
        for (Map.Entry<IProject, SynchronizationManager> entry : this.syncManagers.entrySet()) {
            entry.getValue().removeStateChangeListener(listener);
        }
    }

    @Override
    public void syncAllProjects(IProgressMonitor monitor) {
        Collection<ITranslatedProject> allProjects = this.getAllTranslatedProjects();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)allProjects.size());
        for (ITranslatedProject project : allProjects) {
            SynchronizationManager manager = this.getSynchronizationManager(project);
            try {
                Job.getJobManager().join((Object)manager, monitor);
            }
            catch (OperationCanceledException e) {
                return;
            }
            catch (InterruptedException e) {
                SyncPlugin.logError(e);
                monitor.setCanceled(true);
                Thread.currentThread().interrupt();
                return;
            }
            manager.synchronize((IProgressMonitor)subMonitor.newChild(1));
        }
    }

    @Override
    public void startSyncAllProjects() {
        Collection<ITranslatedProject> allProjects = this.getAllTranslatedProjects();
        for (ITranslatedProject project : allProjects) {
            this.startSync(project);
        }
    }

    @Override
    public Job startSync(ITranslatedProject project) {
        return this.startSync(project.getProject());
    }

    @Override
    public Job startSync(IProject project) {
        return this.startSync(project.getProject(), 500L);
    }

    private Job startSync(IProject project, long delay) {
        Assert.isNotNull((Object)project);
        SynchronizationManager manager = this.getSynchronizationManager(project);
        Job[] jobs = Job.getJobManager().find((Object)manager);
        if (jobs.length > 0) {
            return jobs[0];
        }
        SyncJob syncJob = new SyncJob(this, manager, this.syncJobSchedulerListener);
        syncJob.setUser(true);
        syncJob.schedule(delay);
        return syncJob;
    }

    @Override
    public SynchronizationManager getSynchronizationManager(IProject project) {
        Assert.isNotNull((Object)project);
        SynchronizationManager manager = this.syncManagers.computeIfAbsent(project, p -> this.createSyncManager((IProject)p));
        if (!manager.getTranslatedProject().getSourceProject().getTranslatedProjects().contains(manager.getTranslatedProject())) {
            this.syncManagers.remove(project);
            manager = this.createSyncManager(project);
            this.syncManagers.put(project, manager);
        }
        return manager;
    }

    @Override
    public SynchronizationManager getSynchronizationManager(ITranslatedProject project) {
        Assert.isNotNull((Object)project);
        return this.getSynchronizationManager(project.getProject());
    }

    private SynchronizationManager createSyncManager(IProject project) {
        ITranslatedProject translatedProject = this.translatedProjectManager.getProject(project);
        if (!(translatedProject.getSourceProject() instanceof SynchronizableProject)) {
            ITranslatingProject sourceProject = translatedProject.getSourceProject();
            String sourceProjectName = "";
            if (sourceProject != null) {
                sourceProjectName = sourceProject.getProject().toString();
            }
            throw new IllegalArgumentException(MessageFormat.format("Source project {0} of translated project {1} is Not Synchronizable project", sourceProjectName, translatedProject.getProjectName()));
        }
        ProjectSynchronization manager = new ProjectSynchronization(this);
        SyncPlugin.getDefault().getInjector().injectMembers((Object)manager);
        manager.setTranslatedProject(translatedProject);
        for (StateChangeListener listener : this.stateChangeListeners) {
            manager.addStateChangeListener(listener);
        }
        return manager;
    }

    @Override
    public ChangeManager getChangeManager(ITranslatedProject translatedProject) {
        Assert.isNotNull((Object)translatedProject);
        Assert.isNotNull((Object)translatedProject.getProject());
        return this.changeManagers.computeIfAbsent(translatedProject.getProject(), p -> this.createChangeManager(translatedProject));
    }

    @Override
    public SourceChangeManager getSourceChangeManager(SynchronizableProject project) {
        Assert.isNotNull((Object)project);
        return this.sourceChangeManagers.computeIfAbsent(project.getProject(), p -> this.createSourceChangeManager(project));
    }

    @Override
    public ExecutorService getSyncPool() {
        return this.syncPool;
    }

    @Override
    public void removeSyncSettings(IProject project) {
        IEclipsePreferences prefs = SyncPlugin.getDefault().getPreferences();
        try {
            prefs.node("SYNCHRONIZATION_SERVICE").node(project.getName()).removeNode();
        }
        catch (BackingStoreException e) {
            SyncPlugin.logError(e);
        }
    }

    @Override
    public void updateSyncSettings(IProject source, IProject translated, SyncStrategy strategy) {
        IEclipsePreferences prefs = SyncPlugin.getDefault().getPreferences();
        prefs.node("SYNCHRONIZATION_SERVICE").node(source.getName()).node(translated.getName()).putBoolean(SYNC_STRATEGY_KEY, strategy.equals((Object)SyncStrategy.AUTO));
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            SyncPlugin.logError(e);
        }
    }

    @Override
    public SyncStrategy getSyncSettings(IProject source, IProject translated) {
        IEclipsePreferences prefs = SyncPlugin.getDefault().getPreferences();
        boolean auto = prefs.node("SYNCHRONIZATION_SERVICE").node(source.getName()).node(translated.getName()).getBoolean(SYNC_STRATEGY_KEY, false);
        return auto ? SyncStrategy.AUTO : SyncStrategy.ON_DEMAND;
    }

    private ChangeManager createChangeManager(ITranslatedProject translatedProject) {
        InMemoryChangeManagerProxy manager = new InMemoryChangeManagerProxy(translatedProject.getSourceProject().getProject(), translatedProject.getProject());
        SyncPlugin.getDefault().getInjector().injectMembers((Object)manager);
        return manager;
    }

    private SourceChangeManager createSourceChangeManager(ITranslatingProject translatingProject) {
        SourceChangeManagerWrapper manager = new SourceChangeManagerWrapper(this, translatingProject);
        SyncPlugin.getDefault().getInjector().injectMembers((Object)manager);
        return manager;
    }

    private Collection<ITranslatedProject> getAllTranslatedProjects() {
        ArrayList result = Lists.newArrayList();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            ITranslatingProject translating = this.translatingProjectManager.getProject(project);
            if (translating.isTranslating() && translating instanceof SynchronizableProject && ((SynchronizableProject)translating).isSynchronizing()) {
                for (ITranslatedProject translated : translating.getTranslatedProjects()) {
                    if (translated == null || !translated.isTranslated()) continue;
                    result.add(translated);
                }
            }
            ++i;
        }
        return result;
    }

    private final class ContentChangeListerer
    implements IResourceChangeListener {
        private ContentChangeListerer() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            IResource resource = delta.getResource();
            if (resource == null || resource.getProject() == null) {
                return;
            }
            IProject project = resource.getProject();
            Optional<Map.Entry> entry = ProjectSynchronizationService.this.sourceChangeManagers.entrySet().stream().filter(e -> ((IProject)e.getKey()).equals((Object)project)).findFirst();
            if (!entry.isPresent()) {
                return;
            }
            try {
                delta.accept((IResourceDeltaVisitor)new DeltaVisitor((SourceChangeManager)entry.get().getValue()));
            }
            catch (CoreException e2) {
                SyncPlugin.logError(e2);
            }
        }
    }

    private final class DeltaVisitor
    implements IResourceDeltaVisitor {
        private final SourceChangeManager changeManager;

        public DeltaVisitor(SourceChangeManager changeManager) {
            this.changeManager = changeManager;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            if (resource instanceof IFile) {
                IFile file = (IFile)resource;
                if (delta.getKind() == 1 || delta.getKind() == 4) {
                    this.changeManager.markToSynchronize(file);
                } else if (delta.getKind() == 2) {
                    this.changeManager.markToRemove(file);
                }
            }
            return true;
        }
    }

    private final class ProjectChangeListener
    implements IResourceChangeListener {
        private ProjectChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResource res = event.getResource();
            if ((event.getType() == 2 || event.getType() == 4) && res instanceof IProject) {
                this.onProjectCloseOrRemove((IProject)res);
                this.updateManagerEqualityState(event, (IProject)res);
                ProjectSynchronizationService.this.removeSyncSettings((IProject)res);
            }
        }

        private void onProjectCloseOrRemove(IProject project) {
            Iterator<Map.Entry<IProject, SourceChangeManager>> iterator = ProjectSynchronizationService.this.sourceChangeManagers.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<IProject, SourceChangeManager> entry = iterator.next();
                if (!entry.getKey().equals((Object)project)) continue;
                SourceChangeManager manager = entry.getValue();
                iterator.remove();
                manager.clear();
                manager.dispose();
                ITranslatingProject translatingProject = ProjectSynchronizationService.this.translatingProjectManager.getProject(entry.getKey());
                for (ITranslatedProject translatedProject : translatingProject.getTranslatedProjects()) {
                    SynchronizationManager syncManager = ProjectSynchronizationService.this.syncManagers.get(translatedProject.getProject());
                    if (syncManager instanceof ProjectSynchronization) {
                        ((ProjectSynchronization)syncManager).setEqualityState(EqualityState.NOT_CREATED);
                    }
                    ProjectSynchronizationService.this.syncManagers.remove(translatedProject.getProject());
                }
            }
            ChangeManager manager = ProjectSynchronizationService.this.changeManagers.remove(project);
            if (manager != null) {
                manager.mute();
                manager.clear();
                manager.dispose();
            }
        }

        private void updateManagerEqualityState(IResourceChangeEvent event, IProject project) {
            SynchronizationManager manager = ProjectSynchronizationService.this.syncManagers.get(project);
            if (manager instanceof ProjectSynchronization) {
                if (event.getType() == 2) {
                    ((ProjectSynchronization)manager).setEqualityState(EqualityState.NEED_UPDATE);
                } else if (event.getType() == 4) {
                    ((ProjectSynchronization)manager).setEqualityState(EqualityState.NOT_CREATED);
                }
            }
        }
    }

    private static class ResourcePlan
    implements IResourcePlan {
        private ResourcePlan() {
        }

        public Map<String, IActivityDemandsDefinition> gatherActivities() {
            HashMap<String, IActivityDemandsDefinition> definitions = new HashMap<String, IActivityDemandsDefinition>(1);
            ActivityDemandsDefaultAdapter definition = new ActivityDemandsDefaultAdapter(){

                public ActivityResourcePermissions gatherPermissions(long availableSharedMemory, int availableCores, SystemLoadState overloadState) {
                    int cores = Runtime.getRuntime().availableProcessors() - 1;
                    cores = Math.min(cores, 8);
                    if (EXTERNAL_CORE_LIMIT != null) {
                        cores = Math.min(EXTERNAL_CORE_LIMIT, cores);
                    }
                    if (overloadState == SystemLoadState.OVERLOAD) {
                        cores /= 2;
                    }
                    if (overloadState == SystemLoadState.CRITICAL) {
                        cores = 1;
                    }
                    if (cores == 0) {
                        cores = 1;
                    }
                    return new ActivityResourcePermissions(cores, overloadState);
                }
            };
            definitions.put(ProjectSynchronizationService.SYNC_PROJECT_ACTIVITY, (IActivityDemandsDefinition)definition);
            return definitions;
        }
    }

    private static class SyncJob
    extends Job {
        private final InternalSynchronizationService service;
        private final SynchronizationManager manager;
        private final PostChangeListener syncJobSchedulerListener;

        public SyncJob(InternalSynchronizationService service, SynchronizationManager manager, PostChangeListener syncJobSchedulerListener) {
            super(MessageFormat.format(Messages.ProjectSynchronizationService_Synchronizing_project, manager.getTranslatedProject().getProjectName()));
            this.service = service;
            this.manager = manager;
            this.syncJobSchedulerListener = syncJobSchedulerListener;
        }

        protected IStatus run(IProgressMonitor monitor) {
            IStatus status = this.manager.synchronize(monitor);
            if (!monitor.isCanceled() && status.isOK() && this.manager.getSyncStrategy().equals((Object)SyncStrategy.AUTO) && !this.manager.getEqualityState().equals((Object)EqualityState.NOT_CREATED)) {
                ChangeManager changeManger;
                ITranslatingProject translating = this.manager.getTranslatedProject().getSourceProject();
                if (translating.isTranslating() && translating instanceof SynchronizableProject && !(changeManger = this.service.getChangeManager(this.manager.getTranslatedProject())).isDisposed() && changeManger.isInitialized()) {
                    if (!changeManger.getFilesToUpdate().isEmpty() && !changeManger.getFilesToRemove().isEmpty()) {
                        this.schedule(2000L);
                    } else {
                        changeManger.addPostChangeListener(this.syncJobSchedulerListener);
                    }
                }
            } else if (monitor.isCanceled() && this.manager.getSyncStrategy().equals((Object)SyncStrategy.AUTO)) {
                this.manager.setSyncStrategy(SyncStrategy.ON_DEMAND);
                ChangeManager changeManger = this.service.getChangeManager(this.manager.getTranslatedProject());
                if (!changeManger.isDisposed() && changeManger.isInitialized()) {
                    changeManger.removePostChangeListener(this.syncJobSchedulerListener);
                }
            }
            return status;
        }

        public boolean belongsTo(Object family) {
            if (family instanceof SynchronizationManager) {
                return family.equals(this.manager);
            }
            if (family instanceof ITranslatedProject) {
                return family.equals(this.manager.getTranslatedProject());
            }
            if (family instanceof ITranslatingProject) {
                return family.equals(this.manager.getTranslatedProject().getSourceProject());
            }
            return false;
        }
    }
}

