/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.sync;

import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.internal.sync.SyncPlugin;
import com.e1c.langtool.platform.ITranslatedProject;
import com.e1c.langtool.sync.SyncSession;
import com.e1c.langtool.sync.SyncSessionFactory;
import com.e1c.langtool.sync.SynchronizableProject;
import com.google.common.collect.Maps;
import com.google.inject.Singleton;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

@Singleton
public class SyncSessionFactoryRegistry {
    private static final String EXTENSION_POINT_ID = "com.e1c.langtool.sync.syncSessionFactory";
    private static final String ATT_CLASS = "class";
    private static final String ELEMENT_NATRURE_NAME = "nature";
    private static final String ELEMENT_NATURE_ID = "id";
    private volatile Map<String, SyncSessionFactory> factories;
    private volatile boolean initialized;
    private Object lock = new Object();

    public SyncSession createSyncSession(SynchronizableProject sourceProject, ITranslatedProject targetProject) {
        String[] natures;
        IProjectDescription description;
        Assert.isNotNull((Object)sourceProject);
        Assert.isNotNull((Object)targetProject);
        Assert.isLegal((boolean)targetProject.getSourceProject().equals(sourceProject), (String)MessageFormat.format("This translated project {0} cannot be syncronized with source project: {1}", targetProject, sourceProject));
        Assert.isLegal((boolean)sourceProject.getProject().isAccessible(), (String)MessageFormat.format("Source project {0} is not accessible", sourceProject));
        try {
            description = sourceProject.getProject().getDescription();
        }
        catch (CoreException e) {
            SyncPlugin.logError(e);
            return null;
        }
        String[] stringArray = natures = description.getNatureIds();
        int n = natures.length;
        int n2 = 0;
        while (n2 < n) {
            SyncSessionFactory factory;
            String nature = stringArray[n2];
            if (nature != null && !nature.equals("com.e1c.langtool.TranslatingNature") && (factory = this.getFactories().get(nature)) != null) {
                return factory.createSynSession(targetProject);
            }
            ++n2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, SyncSessionFactory> getFactories() {
        if (!this.initialized) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.initialized) {
                    IConfigurationElement[] configElements;
                    HashMap allFactories = Maps.newHashMap();
                    IConfigurationElement[] elements = configElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
                    int length = configElements.length;
                    int index = 0;
                    while (index < length) {
                        IConfigurationElement configElement = elements[index];
                        try {
                            SyncSessionFactory e = (SyncSessionFactory)configElement.createExecutableExtension(ATT_CLASS);
                            IConfigurationElement[] natures = configElement.getChildren(ELEMENT_NATRURE_NAME);
                            int i = 0;
                            while (i < natures.length) {
                                IConfigurationElement nature = natures[i];
                                String natureId = nature.getAttribute(ELEMENT_NATURE_ID);
                                if (StringUtils.isNotEmpty((String)natureId)) {
                                    allFactories.put(natureId, e);
                                }
                                ++i;
                            }
                        }
                        catch (CoreException e) {
                            SyncPlugin.logError(e);
                        }
                        ++index;
                    }
                    this.factories = allFactories;
                }
            }
        }
        return this.factories;
    }
}

