/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.sync.change;

import com.e1c.langtool.internal.sync.SyncPlugin;
import com.e1c.langtool.platform.ITranslatedProject;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.sync.SynchronizationService;
import com.e1c.langtool.sync.change.ChangeEvent;
import com.e1c.langtool.sync.change.ChangeManager;
import com.e1c.langtool.sync.change.PostChangeListener;
import com.e1c.langtool.sync.change.SourceChangeManager;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;

public class SourceChangeManagerWrapper
implements SourceChangeManager {
    private final SynchronizationService synchronizationService;
    private final ITranslatingProject translatingProject;
    private final AtomicInteger mute = new AtomicInteger(0);
    private final ListenerList<PostChangeListener> postChangeListeners = new ListenerList();
    private volatile boolean dispose = false;

    public SourceChangeManagerWrapper(SynchronizationService synchronizationService, ITranslatingProject translatingProject) {
        this.synchronizationService = synchronizationService;
        this.translatingProject = translatingProject;
    }

    @Override
    public void clear() {
        this.checkAccess();
        this.getChangeManagers().forEach(c -> c.clear());
        if (!this.isMuted()) {
            this.firePostChanged(new ChangeEvent(this, PostChangeListener.ChangeEventType.Cleared, this.translatingProject.getProject().getProjectRelativePath()));
        }
    }

    @Override
    public void mute() {
        this.checkAccess();
        this.mute.getAndIncrement();
        this.getChangeManagers().forEach(c -> c.mute());
    }

    @Override
    public boolean isMuted() {
        return this.mute.get() == 0;
    }

    @Override
    public void unmute() {
        this.checkAccess();
        if (this.mute.get() > 0) {
            this.mute.getAndDecrement();
        }
        this.getChangeManagers().forEach(c -> c.unmute());
    }

    @Override
    public void unmute(ChangeEvent event) {
        this.unmute();
        this.firePostChanged(event);
    }

    @Override
    public void addPostChangeListener(PostChangeListener listener) {
        this.checkAccess();
        this.postChangeListeners.add((Object)listener);
    }

    @Override
    public void removePostChangeListener(PostChangeListener listener) {
        this.postChangeListeners.remove((Object)listener);
    }

    @Override
    public void markToSynchronize(IFile file) {
        this.checkAccess();
        if (!file.isAccessible()) {
            return;
        }
        this.markToSynchronize(file.getFullPath());
    }

    @Override
    public void markToSynchronize(IPath fullPath) {
        this.checkAccess();
        this.getChangeManagers().forEach(c -> c.markToSynchronize(fullPath));
        if (!this.isMuted()) {
            this.firePostChanged(new ChangeEvent(this, PostChangeListener.ChangeEventType.MarkSynchronized, fullPath));
        }
    }

    @Override
    public void moved(IFile from, IFile to) {
        this.checkAccess();
        this.markToRemove(from);
        this.markToSynchronize(to);
    }

    @Override
    public void markToRemove(IPath fullPath) {
        this.checkAccess();
        this.getChangeManagers().forEach(c -> c.markToRemove(fullPath));
        if (!this.isMuted()) {
            this.firePostChanged(new ChangeEvent(this, PostChangeListener.ChangeEventType.MarkToRemove, fullPath));
        }
    }

    @Override
    public ITranslatingProject getProject() {
        return this.translatingProject;
    }

    @Override
    public void markToRemove(IFile file) {
        this.checkAccess();
        this.markToRemove(file.getFullPath());
    }

    private Collection<ChangeManager> getChangeManagers() {
        ArrayList managers = Lists.newArrayList();
        for (ITranslatedProject translatedProject : this.getProject().getTranslatedProjects()) {
            if (!translatedProject.getProject().isAccessible()) continue;
            ChangeManager manager = this.synchronizationService.getChangeManager(translatedProject);
            managers.add(manager);
        }
        return managers;
    }

    protected void firePostChanged(ChangeEvent event) {
        if (this.isMuted()) {
            return;
        }
        for (PostChangeListener l : this.postChangeListeners) {
            try {
                SafeRunner.run(() -> l.changed(event));
            }
            catch (Throwable e) {
                SyncPlugin.logError(e);
            }
        }
    }

    @Override
    public void dispose() {
        this.dispose = true;
    }

    @Override
    public boolean isDisposed() {
        return this.dispose;
    }

    protected void checkAccess() {
        if (this.isDisposed()) {
            throw new IllegalAccessError("The manager is already disposed");
        }
    }
}

