/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.sync;

import com.e1c.langtool.internal.sync.SyncPlugin;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.sync.DependentContentComputer;
import com.e1c.langtool.sync.SyncResourceVisitor;
import com.e1c.langtool.sync.SynchronizableProject;
import com.e1c.langtool.sync.SynchronizationService;
import com.e1c.langtool.sync.SynchronizerRegistry;
import com.e1c.langtool.sync.change.ChangeEvent;
import com.e1c.langtool.sync.change.PostChangeListener;
import com.e1c.langtool.sync.change.SourceChangeManager;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class SynchronizationBuilder
extends IncrementalProjectBuilder {
    public static final String BUILDER_ID = "com.e1c.langtool.sync.SynchronizationBuilder";
    private static final IProject[] EMPTY_PROJ_ARR = new IProject[0];
    @Inject
    protected ITranslatingProjectManager projectManager;
    @Inject
    private SynchronizationService service;
    @Inject
    private SynchronizerRegistry registry;
    private SourceChangeManager sourceChangeManager;

    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        if (!this.isValidProject()) {
            return EMPTY_PROJ_ARR;
        }
        if (kind == 6) {
            this.fullBuild(monitor);
        } else {
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta == null) {
                this.fullBuild(monitor);
            } else {
                this.incrementalBuild(delta, monitor);
            }
        }
        return EMPTY_PROJ_ARR;
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        if (!this.isValidProject()) {
            return;
        }
        SourceChangeManager changeManager = this.getSourceChangeManager();
        changeManager.clear();
    }

    protected boolean isValidProject() {
        ITranslatingProject translatingProject = this.getTranslatingProject();
        return translatingProject.isTranslating() && translatingProject instanceof SynchronizableProject && ((SynchronizableProject)translatingProject).isSynchronizing();
    }

    protected ITranslatingProject getTranslatingProject() {
        ITranslatingProject translatingProject = this.getProjectManager().getProject(this.getProject());
        return translatingProject;
    }

    protected void fullBuild(IProgressMonitor monitor) throws CoreException {
        SourceChangeManager changeManager = this.getSourceChangeManager();
        changeManager.clear();
        changeManager.mute();
        try {
            this.getProject().accept((IResourceVisitor)new SyncResourceVisitor(changeManager, monitor));
        }
        catch (CoreException e) {
            SyncPlugin.logError(e);
        }
        changeManager.unmute(new ChangeEvent(changeManager, PostChangeListener.ChangeEventType.MarkToSynchronize, this.getProject().getProjectRelativePath()));
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        delta.accept((IResourceDeltaVisitor)new SyncDeltaVisitor(monitor));
    }

    private void markChanged(IResource resource, IProgressMonitor monitor) {
        if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            SourceChangeManager changeManager = this.getSourceChangeManager();
            changeManager.markToSynchronize(file);
            if (this.getRegistry().dependentContentComputerExist(file)) {
                HashSet toSynchronize = Sets.newHashSet();
                HashSet toRemove = Sets.newHashSet();
                Collection<DependentContentComputer> computers = this.getRegistry().getDependentContentComputers(file);
                for (DependentContentComputer computer : computers) {
                    if (monitor.isCanceled()) {
                        return;
                    }
                    toSynchronize.addAll(computer.computeDependentContentToSynchronize(file, false, monitor));
                    toRemove.addAll(computer.computeDependentContentToRemove(file, false, monitor));
                }
                for (IFile dependent : toSynchronize) {
                    this.markChanged((IResource)dependent, monitor);
                }
                for (IFile dependent : toRemove) {
                    this.markToDelete((IResource)dependent, monitor);
                }
            }
        }
    }

    protected final SourceChangeManager getSourceChangeManager() {
        if (this.sourceChangeManager == null) {
            ITranslatingProject translatingProject = this.getTranslatingProject();
            this.sourceChangeManager = this.getService().getSourceChangeManager((SynchronizableProject)translatingProject);
        }
        return this.sourceChangeManager;
    }

    private void markToDelete(IResource resource, IProgressMonitor monitor) {
        if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            SourceChangeManager changeManager = this.getSourceChangeManager();
            changeManager.markToRemove(file);
            if (this.getRegistry().dependentContentComputerExist(file)) {
                if (monitor.isCanceled()) {
                    return;
                }
                HashSet toSynchronize = Sets.newHashSet();
                HashSet toRemove = Sets.newHashSet();
                Collection<DependentContentComputer> computers = this.getRegistry().getDependentContentComputers(file);
                for (DependentContentComputer computer : computers) {
                    toSynchronize.addAll(computer.computeDependentContentToSynchronize(file, true, monitor));
                    toRemove.addAll(computer.computeDependentContentToRemove(file, true, monitor));
                }
                for (IFile dependent : toSynchronize) {
                    this.markChanged((IResource)dependent, monitor);
                }
                for (IFile dependent : toRemove) {
                    this.markToDelete((IResource)dependent, monitor);
                }
            }
        }
    }

    protected ITranslatingProjectManager getProjectManager() {
        if (this.projectManager == null) {
            SyncPlugin.getDefault().getInjector().injectMembers((Object)this);
        }
        return this.projectManager;
    }

    protected SynchronizationService getService() {
        if (this.service == null) {
            SyncPlugin.getDefault().getInjector().injectMembers((Object)this);
        }
        return this.service;
    }

    protected SynchronizerRegistry getRegistry() {
        if (this.registry == null) {
            SyncPlugin.getDefault().getInjector().injectMembers((Object)this);
        }
        return this.registry;
    }

    private final class SyncDeltaVisitor
    implements IResourceDeltaVisitor {
        private final IProgressMonitor monitor;

        public SyncDeltaVisitor(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            if (this.monitor.isCanceled()) {
                return false;
            }
            IResource resource = delta.getResource();
            switch (delta.getKind()) {
                case 1: {
                    SynchronizationBuilder.this.markChanged(resource, this.monitor);
                    break;
                }
                case 2: {
                    SynchronizationBuilder.this.markToDelete(resource, this.monitor);
                    break;
                }
                case 4: {
                    SynchronizationBuilder.this.markChanged(resource, this.monitor);
                }
            }
            return true;
        }
    }
}

