/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.converter;

import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.converter.IConverterEngine;
import com.e1c.langtool.converter.IConverterManager;
import com.e1c.langtool.converter.IConverterService;
import com.e1c.langtool.internal.converter.ConverterPlugin;
import com.e1c.langtool.platform.ITranslatedProject;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.v8.dt.projectsettings.DependentManifestUtils;
import com.google.inject.Inject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

public class ConverterEngineImpl
implements IConverterEngine {
    private static final String REGEX_PARAM = "([\u0430-\u044f\u0410-\u042f\u0451\u0401a-zA-Z0-9._]+)";
    private static final String REGEX = "(?<!\\\\)=";
    private static final String FOLDER_NAME_SRC = "src";
    private static final IPath PATH_SRC = new Path("src");
    private static final String FILE_EXTENSION_INTERFACE = "lstr";
    private static final String FILE_EXTENSION_INTERFACE_NSTR = "nstr";
    private static final String FILE_EXTENSION_DICT_INTERFACE = "lsdict";
    private static final String FILE_EXTENSION_TLX = "tlx";
    private static final String FILE_EXTENSION_HTML = "html";
    private static final String TEMPLATE = "%s=%s";
    private final IConverterService converterService;
    @Inject
    private ITranslatingProjectManager translatingProjectManager;

    @Inject
    public ConverterEngineImpl(IConverterService converterService) {
        this.converterService = converterService;
    }

    @Override
    public IStatus convert(IProject project, IProject sourceProject, IProject targetProject, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        if (!project.isAccessible()) {
            return Status.CANCEL_STATUS;
        }
        IConverterManager manager = this.converterService.getManager(project);
        try {
            this.copyProjectAndProcessFiles(sourceProject, targetProject, manager, monitor);
        }
        catch (CoreException e) {
            ConverterPlugin.logError(e);
            return ConverterPlugin.createErrorStatus(e.getMessage(), e);
        }
        ITranslatingProject translatingProject = this.translatingProjectManager.getProject(project);
        List translatedProjects = translatingProject.getTranslatedProjects();
        if (translatedProjects.size() == 1) {
            IProject translatedProject = ((ITranslatedProject)translatedProjects.get(0)).getProject();
            DependentManifestUtils.writeManifest((IProject)translatedProject, (IProject)targetProject.getProject(), (IProgressMonitor)new NullProgressMonitor());
        }
        return Status.OK_STATUS;
    }

    private void copyProjectAndProcessFiles(IProject sourceProject, IProject targetProject, IConverterManager manager, IProgressMonitor monitor) throws CoreException {
        if (!sourceProject.isAccessible()) {
            return;
        }
        this.deleteFolderIfExists(targetProject, FOLDER_NAME_SRC, monitor);
        sourceProject.accept(resource -> {
            if (resource.getType() != 1) {
                return true;
            }
            IPath sourcePath = resource.getProjectRelativePath();
            if (!this.isPathEligibleForCopy(sourcePath)) {
                return true;
            }
            IFile sourceFile = (IFile)resource;
            IPath relativePath = manager.getConvertedKey(sourceFile.getProjectRelativePath());
            if (relativePath.isEmpty()) {
                return true;
            }
            IFile targetFile = targetProject.getFile(relativePath);
            Map<String, String> targetValues = manager.getConvertedValues(sourceFile.getProjectRelativePath());
            try {
                this.copyFile(sourceFile, targetFile, targetValues, manager.getLanguage());
            }
            catch (IOException e) {
                ConverterPlugin.logError(e);
            }
            return true;
        });
        targetProject.refreshLocal(2, monitor);
    }

    private void deleteFolderIfExists(IProject project, String folderName, IProgressMonitor monitor) throws CoreException {
        IFolder folder = project.getFolder(folderName);
        if (folder.exists()) {
            folder.delete(true, monitor);
        }
    }

    private boolean isPathEligibleForCopy(IPath sourcePath) {
        String fileExtension = sourcePath.getFileExtension();
        return PATH_SRC.isPrefixOf(sourcePath) && (FILE_EXTENSION_INTERFACE.equals(fileExtension) || FILE_EXTENSION_INTERFACE_NSTR.equals(fileExtension) || FILE_EXTENSION_DICT_INTERFACE.equals(fileExtension) || FILE_EXTENSION_TLX.equals(fileExtension) || FILE_EXTENSION_HTML.equals(fileExtension));
    }

    private boolean isLanguagePath(IPath sourcePath) {
        return FILE_EXTENSION_TLX.equals(sourcePath.getFileExtension());
    }

    private boolean isHtmlPath(IPath sourcePath) {
        return FILE_EXTENSION_HTML.equals(sourcePath.getFileExtension());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void copyFile(IFile sourceFile, IFile targetFile, Map<String, String> keys, TranslateLanguage translateLanguage) throws IOException {
        java.nio.file.Path source = sourceFile.getLocation().toFile().toPath();
        java.nio.file.Path target = targetFile.getLocation().toFile().toPath();
        if (!this.isLanguagePath(sourceFile.getLocation())) {
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
        }
        if (this.isLanguagePath(sourceFile.getLocation())) {
            BufferedReader reader;
            String targetLanguageCode = translateLanguage.getLanguageCode();
            String fileName = source.getFileName().toString();
            String originalName = fileName.substring(0, fileName.lastIndexOf(46));
            String targetLanguageName = LanguageTranslator.translateLanguage(originalName, targetLanguageCode);
            String adjustedTargetPath = targetFile.getLocation().toString().replace(originalName, targetLanguageName);
            java.nio.file.Path targetPath = Paths.get(adjustedTargetPath, new String[0]);
            Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
            HashSet<String> existingKeys = new HashSet<String>();
            Throwable throwable = null;
            Object var15_26 = null;
            try {
                reader = Files.newBufferedReader(source, StandardCharsets.UTF_8);
                try {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        if (!line.trim().contains("<key>")) continue;
                        String keyValue = line.trim().replaceAll("<key>|</key>", "").trim();
                        existingKeys.add(keyValue);
                    }
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                } else {
                    if (throwable == throwable2) throw throwable;
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            throwable = null;
            var15_26 = null;
            try {
                reader = Files.newBufferedReader(source, StandardCharsets.UTF_8);
                try {
                    try (BufferedWriter writer = Files.newBufferedWriter(targetPath, StandardCharsets.UTF_8, new OpenOption[0]);){
                        String line;
                        boolean isSynonymBlock = false;
                        boolean isKeyRuOrEn = false;
                        while ((line = reader.readLine()) != null) {
                            if (line.trim().contains("<name>")) {
                                line = this.replaceTagValue(line, "name", targetLanguageName);
                            }
                            if (line.trim().contains("<synonym>")) {
                                isSynonymBlock = true;
                                isKeyRuOrEn = false;
                            }
                            if (isSynonymBlock && line.trim().contains("<key>")) {
                                String currentKey = line.trim().replaceAll("<key>|</key>", "").trim();
                                if ((currentKey.equals("ru") || currentKey.equals("en")) && !existingKeys.contains(targetLanguageCode)) {
                                    isKeyRuOrEn = true;
                                    existingKeys.add(targetLanguageCode);
                                    line = this.replaceTagValue(line, "key", targetLanguageCode);
                                } else {
                                    isKeyRuOrEn = false;
                                }
                            }
                            if (isSynonymBlock && isKeyRuOrEn && line.trim().contains("<value>")) {
                                line = this.replaceTagValue(line, "value", targetLanguageName);
                            }
                            if (line.trim().contains("</synonym>")) {
                                isSynonymBlock = false;
                            }
                            writer.write(line);
                            writer.newLine();
                        }
                    }
                    if (reader == null) return;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    if (reader == null) throw throwable;
                    reader.close();
                    throw throwable;
                }
                reader.close();
                return;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                } else {
                    if (throwable == throwable4) throw throwable;
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        if (this.isHtmlPath(sourceFile.getLocation())) {
            Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
            return;
        }
        Throwable throwable = null;
        Object var8_11 = null;
        try {
            BufferedReader reader = Files.newBufferedReader(source, StandardCharsets.UTF_8);
            try {
                try (BufferedWriter writer = Files.newBufferedWriter(target, StandardCharsets.UTF_8, new OpenOption[0]);){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        String processedLine = this.processLine(line, keys);
                        if (processedLine == null) continue;
                        writer.write(processedLine);
                        writer.newLine();
                    }
                }
                if (reader == null) return;
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                if (reader == null) throw throwable;
                reader.close();
                throw throwable;
            }
            reader.close();
            return;
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
                throw throwable;
            } else {
                if (throwable == throwable6) throw throwable;
                throwable.addSuppressed(throwable6);
            }
            throw throwable;
        }
    }

    private String processLine(String line, Map<String, String> keys) {
        if (line.startsWith("#")) {
            return line;
        }
        String[] parts = line.split(REGEX);
        if (parts.length == 0) {
            return line;
        }
        String key = parts[0].trim();
        if (key.isEmpty()) {
            return line;
        }
        String value = parts.length > 1 ? parts[1] : "";
        value = this.replacePlaceholders(value, keys, "%", "%");
        value = this.replacePlaceholders(value, keys, "[", "]");
        value = this.replaceLinks(value, keys);
        return String.format(TEMPLATE, keys.getOrDefault(key, key), value);
    }

    private String replacePlaceholders(String value, Map<String, String> keys, String startPlaceholder, String endPlaceholder) {
        String placeholderPattern = Pattern.quote(startPlaceholder) + REGEX_PARAM + Pattern.quote(endPlaceholder);
        return this.replacePattern(value, keys, placeholderPattern, startPlaceholder, endPlaceholder);
    }

    private String replacePattern(String value, Map<String, String> keys, String pattern, String startTag, String endTag) {
        Matcher matcher = Pattern.compile(pattern).matcher(value);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String match = matcher.group(1);
            if (StringUtils.isNullOrEmpty((String)match)) continue;
            String[] parts = match.split("\\.");
            StringBuilder replacement = new StringBuilder();
            String[] stringArray = parts;
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                replacement.append(keys.getOrDefault(part, part)).append(".");
                ++n2;
            }
            if (replacement.length() > 0) {
                replacement.setLength(replacement.length() - 1);
            }
            matcher.appendReplacement(result, startTag + replacement.toString() + endTag);
        }
        matcher.appendTail(result);
        return result.toString();
    }

    private String replaceLinks(String value, Map<String, String> keys) {
        String linkPattern = "<link ([^>]+)>|v8config://[^/]+/([^>]+)/>";
        Matcher matcher = Pattern.compile(linkPattern).matcher(value.replace("\\:", ":").replace("\\#", "#"));
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String match = matcher.group(1);
            if (match == null) {
                match = matcher.group(2);
            }
            if (StringUtils.isNullOrEmpty((String)match)) continue;
            matcher.appendReplacement(result, "<link " + keys.getOrDefault(match, match) + ">");
        }
        matcher.appendTail(result);
        return result.toString();
    }

    private String replaceTagValue(String line, String tagName, String newValue) {
        String openTag = "<" + tagName + ">";
        String closeTag = "</" + tagName + ">";
        if (line.contains(openTag) && line.contains(closeTag)) {
            int start = line.indexOf(openTag) + openTag.length();
            int end = line.indexOf(closeTag);
            return line.substring(0, start) + newValue + line.substring(end);
        }
        return line;
    }

    private static class LanguageTranslator {
        private static final Map<String, String> russianToEnglish = new HashMap<String, String>();
        private static final Map<String, String> englishToRussian = new HashMap<String, String>();

        static {
            LanguageTranslator.addLanguage("\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439", "English");
            LanguageTranslator.addLanguage("\u041a\u0438\u0442\u0430\u0439\u0441\u043a\u0438\u0439", "Chinese");
            LanguageTranslator.addLanguage("\u0418\u0441\u043f\u0430\u043d\u0441\u043a\u0438\u0439", "Spanish");
            LanguageTranslator.addLanguage("\u0425\u0438\u043d\u0434\u0438", "Hindi");
            LanguageTranslator.addLanguage("\u0410\u0440\u0430\u0431\u0441\u043a\u0438\u0439", "Arabic");
            LanguageTranslator.addLanguage("\u041f\u043e\u0440\u0442\u0443\u0433\u0430\u043b\u044c\u0441\u043a\u0438\u0439", "Portuguese");
            LanguageTranslator.addLanguage("\u0411\u0435\u043d\u0433\u0430\u043b\u044c\u0441\u043a\u0438\u0439", "Bengali");
            LanguageTranslator.addLanguage("\u0424\u0440\u0430\u043d\u0446\u0443\u0437\u0441\u043a\u0438\u0439", "French");
            LanguageTranslator.addLanguage("\u0420\u0443\u0441\u0441\u043a\u0438\u0439", "Russian");
            LanguageTranslator.addLanguage("\u042f\u043f\u043e\u043d\u0441\u043a\u0438\u0439", "Japanese");
            LanguageTranslator.addLanguage("\u041d\u0435\u043c\u0435\u0446\u043a\u0438\u0439", "German");
            LanguageTranslator.addLanguage("\u041a\u043e\u0440\u0435\u0439\u0441\u043a\u0438\u0439", "Korean");
            LanguageTranslator.addLanguage("\u0412\u044c\u0435\u0442\u043d\u0430\u043c\u0441\u043a\u0438\u0439", "Vietnamese");
            LanguageTranslator.addLanguage("\u0422\u0430\u043c\u0438\u043b\u044c\u0441\u043a\u0438\u0439", "Tamil");
            LanguageTranslator.addLanguage("\u0423\u0440\u0434\u0443", "Urdu");
            LanguageTranslator.addLanguage("\u0418\u0442\u0430\u043b\u044c\u044f\u043d\u0441\u043a\u0438\u0439", "Italian");
            LanguageTranslator.addLanguage("\u041f\u0435\u0440\u0441\u0438\u0434\u0441\u043a\u0438\u0439", "Persian");
            LanguageTranslator.addLanguage("\u041f\u043e\u043b\u044c\u0441\u043a\u0438\u0439", "Polish");
            LanguageTranslator.addLanguage("\u0423\u043a\u0440\u0430\u0438\u043d\u0441\u043a\u0438\u0439", "Ukrainian");
            LanguageTranslator.addLanguage("\u0413\u043e\u043b\u043b\u0430\u043d\u0434\u0441\u043a\u0438\u0439", "Dutch");
            LanguageTranslator.addLanguage("\u0422\u0443\u0440\u0435\u0446\u043a\u0438\u0439", "Turkish");
            LanguageTranslator.addLanguage("\u041c\u0430\u0440\u0430\u0442\u0445\u0438", "Marathi");
            LanguageTranslator.addLanguage("\u0422\u0435\u043b\u0443\u0433\u0443", "Telugu");
            LanguageTranslator.addLanguage("\u041c\u0430\u043b\u0430\u0439\u0441\u043a\u0438\u0439", "Malay");
            LanguageTranslator.addLanguage("\u0422\u0430\u0439\u0441\u043a\u0438\u0439", "Thai");
            LanguageTranslator.addLanguage("\u0413\u0443\u0434\u0436\u0430\u0440\u0430\u0442\u0438", "Gujarati");
            LanguageTranslator.addLanguage("\u041f\u0430\u043d\u0434\u0436\u0430\u0431\u0438", "Punjabi");
            LanguageTranslator.addLanguage("\u0420\u0443\u043c\u044b\u043d\u0441\u043a\u0438\u0439", "Romanian");
            LanguageTranslator.addLanguage("\u042f\u0432\u0430\u043d\u0441\u043a\u0438\u0439", "Javanese");
            LanguageTranslator.addLanguage("\u0425\u0430\u0443\u0441\u0430", "Hausa");
            LanguageTranslator.addLanguage("\u041e\u0434\u0438\u0430", "Odia");
            LanguageTranslator.addLanguage("\u0411\u0438\u0440\u043c\u0430\u043d\u0441\u043a\u0438\u0439", "Burmese");
            LanguageTranslator.addLanguage("\u0418\u043d\u0434\u043e\u043d\u0435\u0437\u0438\u0439\u0441\u043a\u0438\u0439", "Indonesian");
            LanguageTranslator.addLanguage("\u0410\u043c\u0445\u0430\u0440\u0441\u043a\u0438\u0439", "Amharic");
            LanguageTranslator.addLanguage("\u0428\u0432\u0435\u0434\u0441\u043a\u0438\u0439", "Swedish");
            LanguageTranslator.addLanguage("\u0419\u043e\u0440\u0443\u0431\u0430", "Yoruba");
            LanguageTranslator.addLanguage("\u0421\u0435\u0440\u0431\u0441\u043a\u0438\u0439", "Serbian");
            LanguageTranslator.addLanguage("\u041a\u0430\u0437\u0430\u0445\u0441\u043a\u0438\u0439", "Kazakh");
            LanguageTranslator.addLanguage("\u0418\u0433\u0431\u043e", "Igbo");
            LanguageTranslator.addLanguage("\u0413\u0440\u0435\u0447\u0435\u0441\u043a\u0438\u0439", "Greek");
            LanguageTranslator.addLanguage("\u0412\u0435\u043d\u0433\u0435\u0440\u0441\u043a\u0438\u0439", "Hungarian");
        }

        private LanguageTranslator() {
        }

        private static void addLanguage(String russianName, String englishName) {
            russianToEnglish.put(russianName, englishName);
            englishToRussian.put(englishName, russianName);
        }

        public static String translateLanguage(String originalName, String targetLangCode) {
            if ("ru".equalsIgnoreCase(targetLangCode)) {
                return englishToRussian.getOrDefault(originalName, originalName);
            }
            if ("en".equalsIgnoreCase(targetLangCode)) {
                return russianToEnglish.getOrDefault(originalName, originalName);
            }
            return originalName;
        }
    }
}

