/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.converter;

import com.e1c.langtool.converter.IConverterEngine;
import com.e1c.langtool.converter.IConverterManager;
import com.e1c.langtool.converter.IConverterService;
import com.e1c.langtool.internal.converter.AsyncConverter;
import com.e1c.langtool.internal.converter.ConverterManagerImpl;
import com.e1c.langtool.internal.converter.EmptyConverterManager;
import com.e1c.langtool.internal.converter.db.ProjectConverterStorage;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.platform.TranslateLanguage;
import com.google.inject.Inject;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IProject;

public class ConverterServiceImpl
implements IConverterService {
    private static final String LANG_EN = "en";
    private static final IConverterManager EMPTY_MANAGER = new EmptyConverterManager();
    private final Map<IProject, IConverterManager> managers = new ConcurrentHashMap<IProject, IConverterManager>();
    private final Map<IProject, ProjectConverterStorage> storages = new ConcurrentHashMap<IProject, ProjectConverterStorage>();
    private final ITranslatingProjectManager translatingProjectManager;
    private final AsyncConverter converter;

    @Inject
    public ConverterServiceImpl(ITranslatingProjectManager translatingProjectManager, IConverterEngine engine) {
        this.translatingProjectManager = translatingProjectManager;
        this.converter = new AsyncConverter(engine);
    }

    public void activate() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate() {
        for (Map.Entry<IProject, ProjectConverterStorage> entry : this.storages.entrySet()) {
            ProjectConverterStorage storage = entry.getValue();
            storage.close();
        }
        this.storages.clear();
        Map<IProject, IConverterManager> map = this.managers;
        synchronized (map) {
            this.managers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IConverterManager getManager(IProject project) {
        Map<IProject, IConverterManager> map = this.managers;
        synchronized (map) {
            IConverterManager manager = this.managers.get(project);
            if (manager == null) {
                ProjectConverterStorage storage = this.storages.computeIfAbsent(project, k -> {
                    ITranslatingProject translating = this.translatingProjectManager.getProject(k);
                    if (translating.isTranslating()) {
                        return new ProjectConverterStorage((IProject)k);
                    }
                    return null;
                });
                if (storage == null) {
                    return EMPTY_MANAGER;
                }
                Optional<TranslateLanguage> lang = this.translatingProjectManager.getProject(project).getInterfaceLanguages().stream().filter(l -> LANG_EN.equals(l.getLanguageCode())).findFirst();
                if (lang.isPresent()) {
                    manager = new ConverterManagerImpl(project, storage, this.converter, lang.get());
                    this.managers.put(project, manager);
                }
            }
            if (manager == null) {
                return EMPTY_MANAGER;
            }
            return manager;
        }
    }
}

